package com.tydic.dyc.pro.base.core.dictionary.enums;
/**
 * @description 运输方式，1汽运，2三方物流枚举值
 * @author Luokan
 * @date 2025/04/16
 **/
public enum EgcShipOrderTransportMode implements DictionaryEnum{
    /**
     * 汽运
     */
    CAR("TRANSPORT_MODE","1","汽运", "运输方式"),
    /**
     * 三方物流
     */
    THIRD("TRANSPORT_MODE","2","三方物流", "运输方式");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EgcShipOrderTransportMode(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
