package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 协议明细税率 枚举
 *
 * @author lihulin
 */
public enum DmcAgrItemTaxRate implements DictionaryEnum {
    RATE_0("DMC_AGR_ITEM_TAX_RATE", "0", "0%", "协议明细税率"),
    RATE_3("DMC_AGR_ITEM_TAX_RATE", "3", "3%", "协议明细税率"),
    RATE_6("DMC_AGR_ITEM_TAX_RATE", "6", "6%", "协议明细税率"),
    RATE_9("DMC_AGR_ITEM_TAX_RATE", "9", "9%", "协议明细税率"),
    RATE_12("DMC_AGR_ITEM_TAX_RATE", "12", "12%", "协议明细税率"),
    RATE_13("DMC_AGR_ITEM_TAX_RATE", "13", "13%", "协议明细税率");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrItemTaxRate(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
