/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.base.core.encode.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.pro.base.core.dao.SysSerialInstanceMapper;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialRuleGetService;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRuleBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRuleGetReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRuleGetRspBO;
import com.tydic.dyc.pro.base.core.po.SysSerialInstancePO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProEncodeSerialServiceImpl
implements DycProEncodeSerialService {
    private static final Logger log = LoggerFactory.getLogger(DycProEncodeSerialServiceImpl.class);
    @Value(value="${encode.write.table.max.num:100}")
    private int maxNum;
    @Autowired
    private CacheClient cacheClient;
    private static final String PREFIX_INSTANCE = "PK_ENCODE_INSTANCE";
    private static final String PREFIX_RULE = "PK_ENCODE_RULE";
    private static final String CONNECTOR_UNDERLINE = "_";
    @Autowired
    private SysSerialInstanceMapper sysSerialInstanceMapper;
    @Autowired
    private DycProEncodeSerialRuleGetService dycProEncodeSerialRuleGetService;
    private static final String SERIAL_SYMBOL = "#[SERIAL_SYMBOL]#";

    @Override
    public DycProEncodeSerialRspBO getEncode(DycProEncodeSerialReqBO reqBO) {
        Long numRange;
        String encodeSerialGenerateKey;
        Long newSerial;
        DycProEncodeSerialServiceImpl.val(reqBO);
        String encodeSerialRuleKey = "PK_ENCODE_RULE_" + reqBO.getCenterCode() + CONNECTOR_UNDERLINE + reqBO.getEncodeRuleCode() + CONNECTOR_UNDERLINE;
        String encodeSerialInstanceKey = "PK_ENCODE_INSTANCE_" + reqBO.getCenterCode() + CONNECTOR_UNDERLINE + reqBO.getEncodeRuleCode() + CONNECTOR_UNDERLINE;
        DycProEncodeSerialRuleBO dycProEncodeSerialRuleBO = this.getSerialRule(encodeSerialRuleKey, encodeSerialInstanceKey, reqBO);
        String prefix = this.createPrefix(dycProEncodeSerialRuleBO);
        Long stepRange = 1L;
        if (null != dycProEncodeSerialRuleBO.getStepRange()) {
            stepRange = dycProEncodeSerialRuleBO.getStepRange();
        }
        Long num = 1L;
        if (null != reqBO.getNum()) {
            num = reqBO.getNum();
        }
        if ((newSerial = this.cacheClient.incrBy(encodeSerialGenerateKey = encodeSerialInstanceKey + CONNECTOR_UNDERLINE + prefix, (numRange = Long.valueOf(num * stepRange)).longValue())).equals(numRange)) {
            this.clearExpiredKey(encodeSerialInstanceKey, encodeSerialGenerateKey);
        }
        ArrayList<String> serialNoList = new ArrayList<String>();
        ArrayList<SysSerialInstancePO> serialInstancePOS = new ArrayList<SysSerialInstancePO>();
        for (int i = num.intValue() - 1; i >= 0; --i) {
            String serial = String.format("%0" + dycProEncodeSerialRuleBO.getSerialNum() + "d", newSerial - (long)i * stepRange);
            String serialNo = prefix.replace(SERIAL_SYMBOL, serial);
            serialNoList.add(serialNo);
            if ((newSerial - (long)i * stepRange) % (long)this.maxNum != 0L) continue;
            SysSerialInstancePO serialInstancePO = new SysSerialInstancePO();
            serialInstancePO.setEncodeRuleId(dycProEncodeSerialRuleBO.getEncodeRuleId());
            serialInstancePO.setPrefix(prefix);
            serialInstancePO.setSerial(serial);
            serialInstancePO.setInstanceId(IdWorker.getId());
            serialInstancePOS.add(serialInstancePO);
        }
        if (!CollectionUtils.isEmpty(serialInstancePOS)) {
            this.sysSerialInstanceMapper.insertBatch(serialInstancePOS);
        }
        DycProEncodeSerialRspBO rspBO = new DycProEncodeSerialRspBO();
        rspBO.setSerialNoList(serialNoList);
        return rspBO;
    }

    private void clearExpiredKey(String encodeSerialInstanceKey, String encodeSerialGenerateKey) {
        Set keys = this.cacheClient.getkeys(encodeSerialInstanceKey + "*");
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            for (String key : keys) {
                if (encodeSerialGenerateKey.equals(key)) continue;
                this.cacheClient.delete(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DycProEncodeSerialRuleBO getSerialRule(String encodeSerialRuleKey, String encodeSerialInstanceKey, DycProEncodeSerialReqBO reqBO) {
        DycProEncodeSerialRuleBO dycProEncodeSerialRuleBO;
        Object encodeSerial = this.cacheClient.get(encodeSerialRuleKey);
        if (encodeSerial == null) {
            DycProEncodeSerialRuleGetRspBO dycProEncodeSerialRuleGetRspBO = this.getRuleByDb(reqBO);
            DycProEncodeSerialServiceImpl dycProEncodeSerialServiceImpl = this;
            synchronized (dycProEncodeSerialServiceImpl) {
                dycProEncodeSerialRuleBO = dycProEncodeSerialRuleGetRspBO.getDycProEncodeSerialRuleBO();
                if (null == dycProEncodeSerialRuleBO.getSerialNum()) {
                    throw new ZTBusinessException("\u5e8f\u53f7\u53f7\u4f4d\u6570\u4e3a\u7a7a");
                }
                this.cacheClient.set(encodeSerialRuleKey, (Object)JSON.toJSONString((Object)dycProEncodeSerialRuleBO));
                String encodeSerialGenerateKey = encodeSerialInstanceKey + CONNECTOR_UNDERLINE + this.createPrefix(dycProEncodeSerialRuleBO);
                Long serialValue = dycProEncodeSerialRuleGetRspBO.getSerialValue();
                if (serialValue > 0L) {
                    serialValue = serialValue + (long)this.maxNum;
                }
                this.cacheClient.incrBy(encodeSerialGenerateKey, serialValue.longValue());
            }
        } else {
            dycProEncodeSerialRuleBO = (DycProEncodeSerialRuleBO)JSON.parseObject((String)encodeSerial.toString(), DycProEncodeSerialRuleBO.class);
        }
        if (null == dycProEncodeSerialRuleBO) {
            throw new ZTBusinessException("\u6ca1\u6709\u914d\u7f6e\u7f16\u7801\u89c4\u5219");
        }
        return dycProEncodeSerialRuleBO;
    }

    private DycProEncodeSerialRuleGetRspBO getRuleByDb(DycProEncodeSerialReqBO reqBO) {
        DycProEncodeSerialRuleGetReqBO dycProEncodeSerialRuleGetReqBO = (DycProEncodeSerialRuleGetReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycProEncodeSerialRuleGetReqBO.class);
        DycProEncodeSerialRuleGetRspBO dycProEncodeSerialRuleGetRspBO = this.dycProEncodeSerialRuleGetService.getRule(dycProEncodeSerialRuleGetReqBO);
        if (!"0000".equals(dycProEncodeSerialRuleGetRspBO.getRespCode())) {
            throw new ZTBusinessException(dycProEncodeSerialRuleGetRspBO.getRespDesc());
        }
        return dycProEncodeSerialRuleGetRspBO;
    }

    private static void val(DycProEncodeSerialReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u7f16\u7801\u89c4\u5219\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCenterCode())) {
            throw new ZTBusinessException("\u7f16\u7801\u89c4\u5219\u6240\u5c5e\u6a21\u5757\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getEncodeRuleCode())) {
            throw new ZTBusinessException("\u7f16\u7801\u89c4\u5219\u7f16\u7801\u4e3a\u7a7a");
        }
    }

    private String createPrefix(DycProEncodeSerialRuleBO dycProEncodeSerialRuleBO) {
        String ruleOrder = dycProEncodeSerialRuleBO.getRuleOrder();
        if (null == ruleOrder) {
            ruleOrder = "1-2-3-4-5";
        }
        String[] orderArray = ruleOrder.split("-");
        StringBuilder prefix = new StringBuilder();
        for (String order : orderArray) {
            if ("1".equals(order) && !StringUtils.isBlank((CharSequence)dycProEncodeSerialRuleBO.getPrefix())) {
                prefix.append(dycProEncodeSerialRuleBO.getPrefix());
            }
            if ("2".equals(order) && !StringUtils.isBlank((CharSequence)dycProEncodeSerialRuleBO.getFirstConnectSymbol())) {
                prefix.append(dycProEncodeSerialRuleBO.getFirstConnectSymbol());
            }
            if ("3".equals(order) && !StringUtils.isBlank((CharSequence)dycProEncodeSerialRuleBO.getDateInfix())) {
                DateTimeFormatter df = DateTimeFormatter.ofPattern(dycProEncodeSerialRuleBO.getDateInfix());
                String date = df.format(LocalDateTime.now());
                prefix.append(date);
            }
            if ("4".equals(order) && !StringUtils.isBlank((CharSequence)dycProEncodeSerialRuleBO.getSecondConnectSymbol())) {
                prefix.append(dycProEncodeSerialRuleBO.getSecondConnectSymbol());
            }
            if (!"5".equals(order)) continue;
            prefix.append(SERIAL_SYMBOL);
        }
        return prefix.toString();
    }
}

