package com.tydic.dyc.pro.base.core.contentreview.config;

import com.aliyun.imageaudit20191230.Client;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
/**
 * @Author HeDengHui
 * @Date 2025/5/30 12.51
 * @Description:阿里云客户端配置
 **/
@Configuration
@Slf4j
public class DycProContentReviewAliyunClientConfig {

    /**
     * 阿里云用户AccessKey ID
     */
    @Value("${ali.contentReview.accessKey.id}")
    private String aliContentReviewAccessKeyId;
    /**
     * 阿里云用户AccessKey Secret
     */
    @Value("${ali.contentReview.accessKey.secret}")
    private String aliContentReviewAccessKeySecret;
    /**
     * 阿里云监测绿色地址
     */
    @Value("${ali.contentReview.endpoint}")
    private String aliContentReviewEndpoint;

    @Bean
    public Client createClient() throws Exception{
        log.debug("初始化图文检测链接");
        com.aliyun.teaopenapi.models.Config config = new com.aliyun.teaopenapi.models.Config()
                .setAccessKeyId(this.aliContentReviewAccessKeyId)
                .setAccessKeySecret(this.aliContentReviewAccessKeySecret);
        config.endpoint = this.aliContentReviewEndpoint;
        return new Client(config);
    }

}
