package com.tydic.dyc.pro.base.core.dictionary.enums;
/**
 * @description 物流编码枚举值
 * @author Luokan
 * @date 2025/04/16
 **/
public enum EgcShipOrderShipCompanyId implements DictionaryEnum{
    /**
     * 百世物流
     */
    BAI_SHI_WU_LIU("SHIP_COMPANY_ID","baishiwuliu","百世物流", "物流编码"),
    /**
     * 德邦
     */
    DE_BANG_WU_LIU("SHIP_COMPANY_ID","debangwuliu","德邦", "物流编码"),
    /**
     * EMS
     */
    EMS("SHIP_COMPANY_ID","ems","EMS", "物流编码"),
    /**
     * 国通
     */
    GUO_TONG_KUAI_DI("SHIP_COMPANY_ID","guotongkuaidi","国通", "物流编码"),
    /**
     * 百世汇通
     */
    HUI_TONG_KUAI_DI("SHIP_COMPANY_ID","huitongkuaidi","百世汇通", "物流编码"),
    /**
     * 京东
     */
    JD("SHIP_COMPANY_ID","jd","京东", "物流编码"),
    /**
     * 极兔
     */
    JI_TU("SHIP_COMPANY_ID","jitu","极兔", "物流编码"),
    /**
     * 顺丰
     */
    SHUN_FENG("SHIP_COMPANY_ID","shunfeng","顺丰", "物流编码"),
    /**
     * 天天
     */
    TIAN_TIAN("SHIP_COMPANY_ID","tiantian","天天", "物流编码"),
    /**
     * 邮政包裹
     */
    YOU_ZHENG_GUO_NEI("SHIP_COMPANY_ID","youzhengguonei","邮政包裹", "物流编码"),
    /**
     * 圆通
     */
    YUAN_TONG("SHIP_COMPANY_ID","yuantong","圆通", "物流编码"),
    /**
     * 韵达
     */
    YUN_DA("SHIP_COMPANY_ID","yunda","韵达", "物流编码"),
    /**
     * 宅急送
     */
    ZHAI_JI_SONG("SHIP_COMPANY_ID","zhaijisong","宅急送", "物流编码"),
    /**
     * 中通
     */
    ZHONG_TONG("SHIP_COMPANY_ID","zhongtong","中通", "物流编码"),
    /**
     * 申通
     */
    SHEN_TONG("SHIP_COMPANY_ID","shentong","申通", "物流编码");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EgcShipOrderShipCompanyId(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
