/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.base.core.flow.repository.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dao.PublicProcInstMapper;
import com.tydic.dyc.pro.base.core.dao.PublicProcTaskInstMapper;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.constants.DycProCommonFlowConstant;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicProcInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;
import com.tydic.dyc.pro.base.core.po.PublicProcInstPO;
import com.tydic.dyc.pro.base.core.po.PublicProcTaskInstPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycProPublicTaskInstRepositoryImpl
implements DycProPublicTaskInstRepository {
    @Autowired
    private PublicProcInstMapper publicProcInstMapper;
    @Autowired
    private PublicProcTaskInstMapper publicProcTaskInstMapper;
    @Autowired
    private DycProEncodeSerialService dycProEncodeSerialService;

    @Override
    public void addFlowTasks(DycProPublicProcInstDTO flowProcInstDto) {
        Date currentDateTime = new Date();
        ArrayList<PublicProcTaskInstPO> addTaskInstList = new ArrayList<PublicProcTaskInstPO>();
        this.addFlowTasksParamVerify(flowProcInstDto.getTaskList());
        PublicProcInstPO publicProcInstPO = (PublicProcInstPO)this.publicProcInstMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)flowProcInstDto.getProcInstId()), PublicProcInstPO::getProcInstId, (Object)flowProcInstDto.getProcInstId()));
        if (null == publicProcInstPO) {
            PublicProcInstPO addProcInstPO = new PublicProcInstPO();
            BeanUtils.copyProperties((Object)flowProcInstDto, (Object)addProcInstPO);
            addProcInstPO.setDataId(Sequence.getInstance().nextId());
            addProcInstPO.setDataStatus(DycProCommonFlowConstant.DataStatus.PENDING_APPROVE);
            if ("APPROVE".equals(addProcInstPO.getProcType())) {
                DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
                encodeSerialReqBO.setCenterCode(flowProcInstDto.getCenterCode());
                encodeSerialReqBO.setEncodeRuleCode(flowProcInstDto.getBusiType());
                DycProEncodeSerialRspBO encode = this.dycProEncodeSerialService.getEncode(encodeSerialReqBO);
                String dataCode = encode.getSerialNoList().get(0);
                addProcInstPO.setDataCode(dataCode);
                String dataName = DictionaryFrameworkUtils.getDicDataByCode("PublicProcInstBusiType", flowProcInstDto.getBusiType()) + "\u5355\uff1a" + dataCode;
                addProcInstPO.setDataName(dataName);
            }
            addProcInstPO.setFinishTag(0);
            addProcInstPO.setDelFlag(DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
            addProcInstPO.setCreateTime(currentDateTime);
            this.publicProcInstMapper.insert(addProcInstPO);
        }
        for (DycProPublicTaskInstDTO flowTaskInfoDto : flowProcInstDto.getTaskList()) {
            PublicProcTaskInstPO orderTaskInstPO = (PublicProcTaskInstPO)JSON.parseObject((String)JSON.toJSONString((Object)flowTaskInfoDto), PublicProcTaskInstPO.class);
            orderTaskInstPO.setDataId(Sequence.getInstance().nextId());
            orderTaskInstPO.setFinishTag(0);
            orderTaskInstPO.setDelFlag(DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
            orderTaskInstPO.setCreateTime(currentDateTime);
            addTaskInstList.add(orderTaskInstPO);
        }
        this.publicProcTaskInstMapper.insertBatch(addTaskInstList);
    }

    @Override
    public void completeFlowTask(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto) {
        this.completeFlowTaskParamVerify(flowTaskInstHandleDto);
        PublicProcTaskInstPO procTaskInstQryResultPO = (PublicProcTaskInstPO)this.publicProcTaskInstMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PublicProcTaskInstPO::getTaskInstId, (Object)flowTaskInstHandleDto.getTaskInstId())).eq(PublicProcTaskInstPO::getFinishTag, (Object)0));
        if (null == procTaskInstQryResultPO) {
            throw new ZTBusinessException("\u4e0d\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4efb\u52a1\u3010" + flowTaskInstHandleDto.getTaskInstId() + "\u3011");
        }
        PublicProcTaskInstPO updateProcTaskInstPO = new PublicProcTaskInstPO();
        BeanUtils.copyProperties((Object)flowTaskInstHandleDto, (Object)updateProcTaskInstPO);
        updateProcTaskInstPO.setDataId(procTaskInstQryResultPO.getDataId());
        updateProcTaskInstPO.setFinishTag(1);
        updateProcTaskInstPO.setFinishTime(new Date());
        this.publicProcTaskInstMapper.updateById(updateProcTaskInstPO);
        if (!"undetermined".equals(flowTaskInstHandleDto.getLinkJudge())) {
            PublicProcTaskInstPO updateOtherTaskInstPO = new PublicProcTaskInstPO();
            updateOtherTaskInstPO.setFinishTag(2);
            updateOtherTaskInstPO.setFinishTime(new Date());
            updateOtherTaskInstPO.setDealRemark("\u4f1a\u7b7e\u5904\u7406\uff0c\u81ea\u52a8\u53d6\u6d88");
            this.publicProcTaskInstMapper.update(updateOtherTaskInstPO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PublicProcTaskInstPO::getStepCode, (Object)procTaskInstQryResultPO.getStepCode())).eq(PublicProcTaskInstPO::getProcInstId, (Object)procTaskInstQryResultPO.getProcInstId())).eq(PublicProcTaskInstPO::getFinishTag, (Object)0)).eq(PublicProcTaskInstPO::getDelFlag, (Object)DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL));
        }
        if (null != flowTaskInstHandleDto.getIsFinish() && flowTaskInstHandleDto.getIsFinish().booleanValue()) {
            PublicProcInstPO updateProcInstPO = new PublicProcInstPO();
            updateProcInstPO.setFinishTag(1);
            if ("true".equals(flowTaskInstHandleDto.getLinkJudge())) {
                updateProcInstPO.setDataStatus(DycProCommonFlowConstant.DataStatus.PASS);
            }
            if ("false".equals(flowTaskInstHandleDto.getLinkJudge())) {
                updateProcInstPO.setDataStatus(DycProCommonFlowConstant.DataStatus.REJECT);
            }
            updateProcInstPO.setFinishTime(new Date());
            this.publicProcInstMapper.update(updateProcInstPO, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PublicProcInstPO::getProcInstId, (Object)procTaskInstQryResultPO.getProcInstId())).eq(PublicProcInstPO::getFinishTag, (Object)0));
        }
    }

    @Override
    public void completeBusiFlowTask(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto) {
        this.completeBusiFlowTaskParamVerify(flowTaskInstHandleDto);
        PublicProcTaskInstPO procTaskInstQryResultPO = (PublicProcTaskInstPO)this.publicProcTaskInstMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PublicProcTaskInstPO::getTaskInstId, (Object)flowTaskInstHandleDto.getTaskInstId())).eq(PublicProcTaskInstPO::getFinishTag, (Object)0));
        if (null == procTaskInstQryResultPO) {
            throw new ZTBusinessException("\u4e0d\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4efb\u52a1\u3010" + flowTaskInstHandleDto.getTaskInstId() + "\u3011");
        }
        PublicProcTaskInstPO updateProcTaskInstPO = new PublicProcTaskInstPO();
        BeanUtils.copyProperties((Object)flowTaskInstHandleDto, (Object)updateProcTaskInstPO);
        updateProcTaskInstPO.setDataId(procTaskInstQryResultPO.getDataId());
        updateProcTaskInstPO.setFinishTag(1);
        updateProcTaskInstPO.setFinishTime(new Date());
        this.publicProcTaskInstMapper.update(updateProcTaskInstPO, (Wrapper)Wrappers.lambdaUpdate().eq(PublicProcTaskInstPO::getTaskInstId, (Object)flowTaskInstHandleDto.getTaskInstId()));
    }

    @Override
    public void beforeJoinFlowTask(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto) {
        this.beforeJoinFlowTaskParamVerify(flowTaskInstHandleDto);
        PublicProcTaskInstPO oldProcTaskInstPO = (PublicProcTaskInstPO)this.publicProcTaskInstMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PublicProcTaskInstPO::getTaskInstId, (Object)flowTaskInstHandleDto.getOldTaskInstId())).eq(PublicProcTaskInstPO::getFinishTag, (Object)0)).eq(PublicProcTaskInstPO::getDelFlag, (Object)DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL));
        if (null == oldProcTaskInstPO) {
            throw new ZTBusinessException("\u8be5\u4efb\u52a1\u3010" + flowTaskInstHandleDto.getOldTaskInstId() + "\u3011\u4e0d\u4e3a\u672a\u5b8c\u6210\u72b6\u6001\uff0c\u4e0d\u53ef\u524d\u52a0\u7b7e");
        }
        PublicProcTaskInstPO updateOldProcTaskInstPO = new PublicProcTaskInstPO();
        updateOldProcTaskInstPO.setDataId(oldProcTaskInstPO.getDataId());
        updateOldProcTaskInstPO.setFinishTime(new Date());
        updateOldProcTaskInstPO.setFinishTag(2);
        updateOldProcTaskInstPO.setDealRemark("\u4efb\u52a1\u524d\u52a0\u7b7e\u64cd\u4f5c\uff0c\u81ea\u52a8\u53d6\u6d88");
        this.publicProcTaskInstMapper.updateById(updateOldProcTaskInstPO);
        PublicProcTaskInstPO newProcTaskInstPO = new PublicProcTaskInstPO();
        BeanUtils.copyProperties((Object)oldProcTaskInstPO, (Object)newProcTaskInstPO);
        newProcTaskInstPO.setDataId(Sequence.getInstance().nextId());
        newProcTaskInstPO.setFinishTag(0);
        newProcTaskInstPO.setDelFlag(DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
        newProcTaskInstPO.setCreateTime(new Date());
        newProcTaskInstPO.setTaskSignTag(DycProCommonFlowConstant.TaskSignTag.BEFORE_JOIN);
        newProcTaskInstPO.setTaskInstId(flowTaskInstHandleDto.getTaskInstId());
        newProcTaskInstPO.setTaskUserId(flowTaskInstHandleDto.getTaskUserId());
        newProcTaskInstPO.setTaskUserName(flowTaskInstHandleDto.getTaskUserName());
        newProcTaskInstPO.setTaskUserOrgId(flowTaskInstHandleDto.getTaskUserOrgId());
        newProcTaskInstPO.setTaskUserOrgName(flowTaskInstHandleDto.getTaskUserOrgName());
        newProcTaskInstPO.setTaskUserOrgPath(flowTaskInstHandleDto.getTaskUserOrgPath());
        newProcTaskInstPO.setTaskUserCompanyId(flowTaskInstHandleDto.getTaskUserCompanyId());
        newProcTaskInstPO.setTaskUserCompanyName(flowTaskInstHandleDto.getTaskUserCompanyName());
        this.publicProcTaskInstMapper.insert(newProcTaskInstPO);
    }

    @Override
    public void transfFlowTask(DycProPublicTaskInstDTO flowTaskInstDto) {
        this.transfFlowTaskParamVerify(flowTaskInstDto);
        PublicProcTaskInstPO oldProcTaskInstPO = (PublicProcTaskInstPO)this.publicProcTaskInstMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PublicProcTaskInstPO::getTaskInstId, (Object)flowTaskInstDto.getTaskInstId())).eq(PublicProcTaskInstPO::getFinishTag, (Object)0)).eq(PublicProcTaskInstPO::getDelFlag, (Object)DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL));
        if (null == oldProcTaskInstPO) {
            throw new ZTBusinessException("\u8be5\u4efb\u52a1\u3010" + flowTaskInstDto.getTaskInstId() + "\u3011\u4e0d\u4e3a\u672a\u5b8c\u6210\u72b6\u6001\uff0c\u4e0d\u53ef\u8f6c\u7b7e");
        }
        PublicProcTaskInstPO updateOldProcTaskInstPO = new PublicProcTaskInstPO();
        BeanUtils.copyProperties((Object)oldProcTaskInstPO, (Object)updateOldProcTaskInstPO);
        updateOldProcTaskInstPO.setTaskSignTag(DycProCommonFlowConstant.TaskSignTag.TRANSFER);
        updateOldProcTaskInstPO.setTaskUserId(flowTaskInstDto.getTaskUserId());
        updateOldProcTaskInstPO.setTaskUserName(flowTaskInstDto.getTaskUserName());
        updateOldProcTaskInstPO.setTaskUserOrgId(flowTaskInstDto.getTaskUserOrgId());
        updateOldProcTaskInstPO.setTaskUserOrgName(flowTaskInstDto.getTaskUserOrgName());
        updateOldProcTaskInstPO.setTaskUserOrgPath(flowTaskInstDto.getTaskUserOrgPath());
        updateOldProcTaskInstPO.setTaskUserCompanyId(flowTaskInstDto.getTaskUserCompanyId());
        updateOldProcTaskInstPO.setTaskUserCompanyName(flowTaskInstDto.getTaskUserCompanyName());
        this.publicProcTaskInstMapper.updateById(updateOldProcTaskInstPO);
    }

    @Override
    public List<DycProPublicTaskInstDTO> queryFlowTaskList(DycProPublicTaskInstDTO flowTaskInstDto) {
        List publicProcTaskInstPOS = this.publicProcTaskInstMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(flowTaskInstDto.getObjId() != null, PublicProcTaskInstPO::getObjId, (Object)flowTaskInstDto.getObjId())).eq(!ObjectUtils.isEmpty((Object)flowTaskInstDto.getObjType()), PublicProcTaskInstPO::getObjType, (Object)flowTaskInstDto.getObjType())).eq(flowTaskInstDto.getFinishTag() != null, PublicProcTaskInstPO::getFinishTag, (Object)flowTaskInstDto.getFinishTag())).orderByDesc(PublicProcTaskInstPO::getCreateTime));
        if (!CollectionUtils.isEmpty((Collection)publicProcTaskInstPOS)) {
            return JSON.parseArray((String)JSON.toJSONString((Object)publicProcTaskInstPOS), DycProPublicTaskInstDTO.class);
        }
        return Collections.emptyList();
    }

    private void beforeJoinFlowTaskParamVerify(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto) {
        if (StringUtils.isBlank((CharSequence)flowTaskInstHandleDto.getOldTaskInstId())) {
            throw new ZTBusinessException("\u539f\u4efb\u52a1\u5b9e\u4f8bID\u3010oldTaskInstId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)flowTaskInstHandleDto.getTaskInstId())) {
            throw new ZTBusinessException("\u4efb\u52a1ID\u3010taskInstId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == flowTaskInstHandleDto.getTaskUserId()) {
            throw new ZTBusinessException("\u4efb\u52a1\u5f85\u529e\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)flowTaskInstHandleDto.getTaskUserName())) {
            throw new ZTBusinessException("\u4efb\u52a1\u5f85\u529e\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == flowTaskInstHandleDto.getTaskUserOrgId()) {
            throw new ZTBusinessException("\u4efb\u52a1\u5f85\u529e\u4eba\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)flowTaskInstHandleDto.getTaskUserOrgName())) {
            throw new ZTBusinessException("\u4efb\u52a1\u5f85\u529e\u4eba\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == flowTaskInstHandleDto.getTaskUserCompanyId()) {
            throw new ZTBusinessException("\u4efb\u52a1\u5f85\u529e\u4eba\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)flowTaskInstHandleDto.getTaskUserCompanyName())) {
            throw new ZTBusinessException("\u4efb\u52a1\u5f85\u529e\u4eba\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void addFlowTasksParamVerify(List<DycProPublicTaskInstDTO> procTaskList) {
        if (procTaskList.isEmpty()) {
            throw new ZTBusinessException("\u4efb\u52a1\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProPublicTaskInstDTO flowTaskInstDto : procTaskList) {
            int index = procTaskList.indexOf(flowTaskInstDto);
            if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getTaskInstId())) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getProcInstId())) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getCenterCode())) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u6240\u5c5e\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getProcDefKey())) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u6d41\u7a0b\u5b9a\u4e49key\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getProcType())) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u6d41\u7a0b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == flowTaskInstDto.getObjId()) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u4e1a\u52a1\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == flowTaskInstDto.getObjType()) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == flowTaskInstDto.getTaskSignTag()) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u4efb\u52a1\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getStepCode())) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u73af\u8282\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getStepName())) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u73af\u8282\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!"APPROVE".equals(flowTaskInstDto.getProcType())) continue;
            if (null == flowTaskInstDto.getTaskUserId()) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u4efb\u52a1\u5f85\u529e\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getTaskUserName())) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u4efb\u52a1\u5f85\u529e\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == flowTaskInstDto.getTaskUserOrgId()) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u4efb\u52a1\u5f85\u529e\u4eba\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getTaskUserOrgName())) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u4efb\u52a1\u5f85\u529e\u4eba\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == flowTaskInstDto.getTaskUserCompanyId()) {
                throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u4efb\u52a1\u5f85\u529e\u4eba\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((CharSequence)flowTaskInstDto.getTaskUserCompanyName())) continue;
            throw new ZTBusinessException("\u96c6\u5408\u5f53\u4e2d\u7b2c" + (index + 1) + "\u4e2a\u4efb\u52a1\u5f85\u529e\u4eba\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void transfFlowTaskParamVerify(DycProPublicTaskInstDTO flowTaskInstDto) {
        if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getTaskInstId())) {
            throw new ZTBusinessException("\u4efb\u52a1ID\u3010taskInstId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == flowTaskInstDto.getTaskUserId()) {
            throw new ZTBusinessException("\u4efb\u52a1\u5f52\u5c5e\u4ebaID\u3010taskUserId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getTaskUserName())) {
            throw new ZTBusinessException("\u4efb\u52a1\u5f85\u529e\u4eba\u540d\u79f0\u3010taskUserName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == flowTaskInstDto.getTaskUserOrgId()) {
            throw new ZTBusinessException("\u4efb\u52a1\u5f85\u529e\u4eba\u673a\u6784ID\u3010taskUserOrgId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getTaskUserOrgName())) {
            throw new ZTBusinessException("\u4efb\u52a1\u5f85\u529e\u4eba\u673a\u6784\u540d\u79f0\u3010taskUserOrgName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == flowTaskInstDto.getTaskUserCompanyId()) {
            throw new ZTBusinessException("\u4efb\u52a1\u5f85\u529e\u4eba\u516c\u53f8ID\u3010taskUserCompanyId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)flowTaskInstDto.getTaskUserCompanyName())) {
            throw new ZTBusinessException("\u4efb\u52a1\u5f85\u529e\u4eba\u516c\u53f8\u540d\u79f0\u3010taskUserCompanyName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void completeFlowTaskParamVerify(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto) {
        if (StringUtils.isBlank((CharSequence)flowTaskInstHandleDto.getTaskInstId())) {
            throw new ZTBusinessException("\u4efb\u52a1ID\u3010taskInstId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)flowTaskInstHandleDto.getLinkJudge())) {
            throw new ZTBusinessException("\u73af\u8282\u662f\u5426\u7ed3\u675f\u5224\u65ad\u3010linkJudge\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == flowTaskInstHandleDto.getIsFinish()) {
            throw new ZTBusinessException("\u6d41\u7a0b\u662f\u5426\u7ed3\u675f\u5224\u65ad\u3010isFinish\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void completeBusiFlowTaskParamVerify(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto) {
        if (StringUtils.isBlank((CharSequence)flowTaskInstHandleDto.getTaskInstId())) {
            throw new ZTBusinessException("\u4efb\u52a1ID\u3010taskInstId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

