package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @Author XiongHao
 * @Date 2025/9/17 11:00
 * @Description: 采购类型字典
 */
public enum ZLEgcPurApplyType implements DictionaryEnum{

    /**
     * 办公类：OFFICE
     */
    OFFICE("PUR_APPLY_TYPE", "1", "办公类", "采购类型"),

    /**
     * MRO集采：MRO
     */
    MRO("PUR_APPLY_TYPE", "2", "MRO集采", "采购类型"),

    /**
     * 公车：VEHICLE
     */
    VEHICLE("PUR_APPLY_TYPE", "3", "公车", "采购类型"),

    /**
     * 实验设备：LAB_EQUIPMENT
     */
    LAB_EQUIPMENT("PUR_APPLY_TYPE", "4", "实验设备", "采购类型"),

    /**
     * 服务类：SERVICE
     */
    SERVICE("PUR_APPLY_TYPE", "5", "服务类", "采购类型");

    /**
     * 编码
     */
    private final String dictionaryCode;
    /**
     * 编码
     */
    private final String code;
    /**
     * 编码值
     */
    private final String value;
    /**
     * 名称
     */
    private final String dictionaryName;

    ZLEgcPurApplyType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
