package com.tydic.dyc.pro.base.core.dictionary.enums;
/**
 * @description 支付状态，1401（未付款），1402（已付款）
 * @author Luokan
 * @date 2025/04/16
 **/
public enum EgcSaleOrderPayState implements DictionaryEnum{
    /**
     * 未付款 1401
     */
    TO_PAY("UOC_SALE_ORDER_PAY_STATE","1401","未付款", "支付状态"),
    /**
     * 已付款 1402
     */
    PAYED("UOC_SALE_ORDER_PAY_STATE","1402","已付款", "支付状态");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EgcSaleOrderPayState(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
