package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @description 商品池关联方式 1管理目录 2 框架协议 3 供应商 4 SKU 5 SPU
 * @author luoyou
 * @date 2025/04/24
 **/

public enum DmcCommPoolInfoPoolRelated implements DictionaryEnum{
    MANAGE_CATALOG("DMC_COMM_POOL_INFO_POOL_RELATED", "1","后台管理类目+商品", "商品池关联方式"),
    AGR("DMC_COMM_POOL_INFO_POOL_RELATED", "2","协议+商品", "商品池关联方式"),
    SUPPLIER("DMC_COMM_POOL_INFO_POOL_RELATED", "3","供应商+商品", "商品池关联方式"),
    SKU("DMC_COMM_POOL_INFO_POOL_RELATED", "4","商品", "商品池关联方式"),
    SPU("DMC_COMM_POOL_INFO_POOL_RELATED", "5","SPU", "商品池关联方式"),
    ;
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommPoolInfoPoolRelated(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
