package com.tydic.dyc.pro.base.core.encode.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.constant.DycProCoreRspConstant;
import com.tydic.dyc.pro.base.core.dao.SysSerialInstanceMapper;
import com.tydic.dyc.pro.base.core.dao.SysSerialRuleMapper;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialRuleGetService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRuleGetReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRuleGetRspBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRuleBO;
import com.tydic.dyc.pro.base.core.po.SysSerialInstancePO;
import com.tydic.dyc.pro.base.core.po.SysSerialRulePO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题:EncodeSerialRuleGetServiceImpl
 * 说明:TODO
 * 时间:2025/4/17 19:18
 * 作者:罗有
 */

@HTServiceImpl
public class DycProEncodeSerialRuleGetServiceImpl implements DycProEncodeSerialRuleGetService {

	@Autowired
	private SysSerialRuleMapper sysSerialRuleMapper;
	@Autowired
	private SysSerialInstanceMapper sysSerialInstanceMapper;

	@Override
	public DycProEncodeSerialRuleGetRspBO getRule(DycProEncodeSerialRuleGetReqBO reqBO) {
		DycProEncodeSerialRuleGetRspBO rspBO = new DycProEncodeSerialRuleGetRspBO();

		LambdaQueryWrapperX<SysSerialRulePO> serialRuleQueryWrapper = new LambdaQueryWrapperX<>();
		serialRuleQueryWrapper.eq(SysSerialRulePO::getEncodeRuleCode, reqBO.getEncodeRuleCode());
		serialRuleQueryWrapper.eq(SysSerialRulePO::getCenterCode, reqBO.getCenterCode());
		List<SysSerialRulePO> serialRulePOS = sysSerialRuleMapper.selectList(serialRuleQueryWrapper);
		if(CollectionUtils.isEmpty(serialRulePOS)){
			throw new ZTBusinessException("没有配置编码规则");
		}
		DycProEncodeSerialRuleBO dycProEncodeSerialRuleBO = JSON.parseObject(JSON.toJSONString(serialRulePOS.get(0)), DycProEncodeSerialRuleBO.class);
		SysSerialInstancePO sysSerialInstancePO = sysSerialInstanceMapper.selectOne(new LambdaQueryWrapperX<SysSerialInstancePO>()
				.eq(SysSerialInstancePO::getEncodeRuleId, dycProEncodeSerialRuleBO.getEncodeRuleId())
				.last("ORDER BY serial + 0 DESC limit 1"));
		if(null != sysSerialInstancePO){
			rspBO.setSerialValue(removeLeadingZeros(sysSerialInstancePO.getSerial()));
		} else {
			rspBO.setSerialValue(0L);
		}
		rspBO.setDycProEncodeSerialRuleBO(dycProEncodeSerialRuleBO);
		rspBO.setRespCode(DycProCoreRspConstant.RSP_CODE_SUCCEED);
		rspBO.setRespDesc(DycProCoreRspConstant.RSP_DESC_SUCCEED);
		return rspBO;
	}

	private static Long removeLeadingZeros(String input) {
		if (StringUtils.isBlank(input)) {
			return 0L;
		}
		int i = 0;
		while (i < input.length() && input.charAt(i) == '0') {
			i++;
		}
		return i == input.length() ? 0L : Long.parseLong(input.substring(i));
	}
}
