package com.tydic.dyc.pro.base.core.flow.repository.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dao.PublicProcInstMapper;
import com.tydic.dyc.pro.base.core.dao.PublicProcTaskInstMapper;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.constants.DycProCommonFlowConstant;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicProcInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;
import com.tydic.dyc.pro.base.core.po.PublicProcInstPO;
import com.tydic.dyc.pro.base.core.po.PublicProcTaskInstPO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;

/**
 * 描述：流程实例实体基建层实现
 * @author yuhao
 * @date 2025-04-17 17:47
 **/
@Service
public class DycProPublicTaskInstRepositoryImpl implements DycProPublicTaskInstRepository {

    @Autowired
    private PublicProcInstMapper publicProcInstMapper;


    @Autowired
    private PublicProcTaskInstMapper publicProcTaskInstMapper;
    /**
     * 编码生成服务
     */
    @Autowired
    private DycProEncodeSerialService dycProEncodeSerialService;

    /**
     * 任务的新增(批量)
     */
    @Override
    public void addFlowTasks(DycProPublicProcInstDTO flowProcInstDto) {
        Date currentDateTime = new Date();
        //需要新增的任务集合
        List<PublicProcTaskInstPO> addTaskInstList = new ArrayList<>();

        //参数校验
        this.addFlowTasksParamVerify(flowProcInstDto.getTaskList());
        //判断流程实例是否存在
        PublicProcInstPO publicProcInstPO = this.publicProcInstMapper.selectOne(Wrappers.<PublicProcInstPO>lambdaQuery()
                .eq(StringUtils.isNotBlank(flowProcInstDto.getProcInstId()), PublicProcInstPO::getProcInstId, flowProcInstDto.getProcInstId()));
        if(null == publicProcInstPO){
            //如果流程实例不存在，先新增流程实例数据
            //组装流程实例
            PublicProcInstPO addProcInstPO = new PublicProcInstPO();
            BeanUtils.copyProperties(flowProcInstDto,addProcInstPO);
            //设置数据id
            addProcInstPO.setDataId(Sequence.getInstance().nextId());
            //设置单据状态为待审批
            addProcInstPO.setDataStatus(DycProCommonFlowConstant.DataStatus.PENDING_APPROVE);
            if (DycProCommonFlowConstant.ProcType.APPROVE.equals(addProcInstPO.getProcType())) {
                //设置单据编号
                DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
                encodeSerialReqBO.setCenterCode(flowProcInstDto.getCenterCode());
                encodeSerialReqBO.setEncodeRuleCode(flowProcInstDto.getBusiType());
                DycProEncodeSerialRspBO encode = this.dycProEncodeSerialService.getEncode(encodeSerialReqBO);
                String dataCode = encode.getSerialNoList().get(0);
                addProcInstPO.setDataCode(dataCode);
                //设置单据名称
                String dataName = DictionaryFrameworkUtils.getDicDataByCode("PublicProcInstBusiType", flowProcInstDto.getBusiType()) + "单：" + dataCode;
                addProcInstPO.setDataName(dataName);

            }
            //设置流程为未完成
            addProcInstPO.setFinishTag(DycProCommonFlowConstant.FinishTag.FINISH_TAG_NOT_FINISH);
            //设置流程为未删除
            addProcInstPO.setDelFlag(DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
            //设置创建时间
            addProcInstPO.setCreateTime(currentDateTime);
            this.publicProcInstMapper.insert(addProcInstPO);
        }

        //生成流程实例任务数据
        for (DycProPublicTaskInstDTO flowTaskInfoDto : flowProcInstDto.getTaskList()){
            PublicProcTaskInstPO orderTaskInstPO = JSON.parseObject(JSON.toJSONString(flowTaskInfoDto), PublicProcTaskInstPO.class);
            //设置数据id
            orderTaskInstPO.setDataId(Sequence.getInstance().nextId());
            //设置任务为未完成
            orderTaskInstPO.setFinishTag(DycProCommonFlowConstant.FinishTag.FINISH_TAG_NOT_FINISH);
            //设置任务为未删除
            orderTaskInstPO.setDelFlag(DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
            //设置创建时间
            orderTaskInstPO.setCreateTime(currentDateTime);
            //放入需新增任务集合
            addTaskInstList.add(orderTaskInstPO);
        }
        //批量插入任务
        this.publicProcTaskInstMapper.insertBatch(addTaskInstList);
    }


    /**
     * 完成流程任务
     */
    @Override
    public void completeFlowTask(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto) {
        //完成流程任务参数校验
        this.completeFlowTaskParamVerify(flowTaskInstHandleDto);

        //判断该任务是否存在
        PublicProcTaskInstPO procTaskInstQryResultPO = this.publicProcTaskInstMapper.selectOne(Wrappers.<PublicProcTaskInstPO>lambdaQuery()
                .eq(PublicProcTaskInstPO::getTaskInstId, flowTaskInstHandleDto.getTaskInstId())
                .eq(PublicProcTaskInstPO::getFinishTag, DycProCommonFlowConstant.FinishTag.FINISH_TAG_NOT_FINISH));
        if(null == procTaskInstQryResultPO){
            throw new ZTBusinessException("不存在未完成的任务【"+flowTaskInstHandleDto.getTaskInstId()+"】");
        }else{
            //更新任务
            PublicProcTaskInstPO updateProcTaskInstPO = new PublicProcTaskInstPO();
            //拷贝完成人相关信息
            BeanUtils.copyProperties(flowTaskInstHandleDto,updateProcTaskInstPO);
            //设置数据id
            updateProcTaskInstPO.setDataId(procTaskInstQryResultPO.getDataId());
            //设置任务为完成状态
            updateProcTaskInstPO.setFinishTag(DycProCommonFlowConstant.FinishTag.FINISH_TAG_FINISH);
            //设置完成时间
            updateProcTaskInstPO.setFinishTime(new Date());
            this.publicProcTaskInstMapper.updateById(updateProcTaskInstPO);

            //判断当前环节是否结束
            if(!DycProCommonFlowConstant.LinkJudge.LINK_JUDGE_UNDETERMINED.equals(flowTaskInstHandleDto.getLinkJudge())){
                //如果当前环节结束了，需要将当前环节待处理的任务处理为自动取消
                PublicProcTaskInstPO updateOtherTaskInstPO = new PublicProcTaskInstPO();
                //更新字段
                updateOtherTaskInstPO.setFinishTag(DycProCommonFlowConstant.FinishTag.FINISH_TAG_CANCEL);
                updateOtherTaskInstPO.setFinishTime(new Date());
                updateOtherTaskInstPO.setDealRemark("会签处理，自动取消");
                this.publicProcTaskInstMapper.update(updateOtherTaskInstPO,Wrappers.<PublicProcTaskInstPO>lambdaQuery()
                        .eq(PublicProcTaskInstPO::getStepCode,procTaskInstQryResultPO.getStepCode())
                        .eq(PublicProcTaskInstPO::getProcInstId,procTaskInstQryResultPO.getProcInstId())
                        .eq(PublicProcTaskInstPO::getFinishTag, DycProCommonFlowConstant.FinishTag.FINISH_TAG_NOT_FINISH)
                        .eq(PublicProcTaskInstPO::getDelFlag, DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL));

            }
            //判断流程是否结束
            if(null != flowTaskInstHandleDto.getIsFinish() && flowTaskInstHandleDto.getIsFinish()){
                //组装流程实例对象为完成
                PublicProcInstPO updateProcInstPO = new PublicProcInstPO();
                updateProcInstPO.setFinishTag(DycProCommonFlowConstant.FinishTag.FINISH_TAG_FINISH);
                if(DycProCommonFlowConstant.LinkJudge.LINK_JUDGE_TRUE.equals(flowTaskInstHandleDto.getLinkJudge())){
                    updateProcInstPO.setDataStatus(DycProCommonFlowConstant.DataStatus.PASS);
                }
                if(DycProCommonFlowConstant.LinkJudge.LINK_JUDGE_FALSE.equals(flowTaskInstHandleDto.getLinkJudge())){
                    updateProcInstPO.setDataStatus(DycProCommonFlowConstant.DataStatus.REJECT);
                }
                updateProcInstPO.setFinishTime(new Date());
                this.publicProcInstMapper.update(updateProcInstPO,Wrappers.<PublicProcInstPO>lambdaQuery()
                        .eq(PublicProcInstPO::getProcInstId,procTaskInstQryResultPO.getProcInstId())
                        .eq(PublicProcInstPO::getFinishTag, DycProCommonFlowConstant.FinishTag.FINISH_TAG_NOT_FINISH));
            }
        }
    }

    @Override
    public void completeBusiFlowTask(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto) {
        //参数校验
        this.completeBusiFlowTaskParamVerify(flowTaskInstHandleDto);
        //判断该任务是否存在
        PublicProcTaskInstPO procTaskInstQryResultPO = this.publicProcTaskInstMapper.selectOne(Wrappers.<PublicProcTaskInstPO>lambdaQuery()
                .eq(PublicProcTaskInstPO::getTaskInstId, flowTaskInstHandleDto.getTaskInstId())
                .eq(PublicProcTaskInstPO::getFinishTag, DycProCommonFlowConstant.FinishTag.FINISH_TAG_NOT_FINISH));
        if (null == procTaskInstQryResultPO) {
            throw new ZTBusinessException("不存在未完成的任务【" + flowTaskInstHandleDto.getTaskInstId() + "】");
        } else {
            //更新任务
            PublicProcTaskInstPO updateProcTaskInstPO = new PublicProcTaskInstPO();
            //拷贝完成人相关信息
            BeanUtils.copyProperties(flowTaskInstHandleDto, updateProcTaskInstPO);
            //设置数据id
            updateProcTaskInstPO.setDataId(procTaskInstQryResultPO.getDataId());
            //设置任务为完成状态
            updateProcTaskInstPO.setFinishTag(DycProCommonFlowConstant.FinishTag.FINISH_TAG_FINISH);
            //设置完成时间
            updateProcTaskInstPO.setFinishTime(new Date());
            this.publicProcTaskInstMapper.update(updateProcTaskInstPO, Wrappers.<PublicProcTaskInstPO>lambdaUpdate()
                    .eq(PublicProcTaskInstPO::getTaskInstId, flowTaskInstHandleDto.getTaskInstId()));
        }
    }

    /**
     * 任务前加签，需要传入原任务实例ID
     */
    @Override
    public void beforeJoinFlowTask(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto) {
        //参数校验
        this.beforeJoinFlowTaskParamVerify(flowTaskInstHandleDto);
        //查询原任务数据
        PublicProcTaskInstPO oldProcTaskInstPO = this.publicProcTaskInstMapper.selectOne(Wrappers.<PublicProcTaskInstPO>lambdaQuery()
                .eq(PublicProcTaskInstPO::getTaskInstId, flowTaskInstHandleDto.getOldTaskInstId())
                .eq(PublicProcTaskInstPO::getFinishTag, DycProCommonFlowConstant.FinishTag.FINISH_TAG_NOT_FINISH)
                .eq(PublicProcTaskInstPO::getDelFlag, DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL));
        if(null == oldProcTaskInstPO){
            throw new ZTBusinessException("该任务【"+flowTaskInstHandleDto.getOldTaskInstId()+"】不为未完成状态，不可前加签");
        }else{
            //更新原任务为取消
            PublicProcTaskInstPO updateOldProcTaskInstPO = new PublicProcTaskInstPO();
            updateOldProcTaskInstPO.setDataId(oldProcTaskInstPO.getDataId());
            updateOldProcTaskInstPO.setFinishTime(new Date());
            updateOldProcTaskInstPO.setFinishTag(DycProCommonFlowConstant.FinishTag.FINISH_TAG_CANCEL);
            updateOldProcTaskInstPO.setDealRemark("任务前加签操作，自动取消");
            this.publicProcTaskInstMapper.updateById(updateOldProcTaskInstPO);

            //生成新的前加签任务
            PublicProcTaskInstPO newProcTaskInstPO = new PublicProcTaskInstPO();
            BeanUtils.copyProperties(oldProcTaskInstPO,newProcTaskInstPO);
            //设置新的数据id
            newProcTaskInstPO.setDataId(Sequence.getInstance().nextId());
            //设置任务状态为未完成
            newProcTaskInstPO.setFinishTag(DycProCommonFlowConstant.FinishTag.FINISH_TAG_NOT_FINISH);
            //设置删除标识为未删除
            newProcTaskInstPO.setDelFlag(DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL);
            //设置任务创建时间
            newProcTaskInstPO.setCreateTime(new Date());
            //设置任务标识为前加签任务
            newProcTaskInstPO.setTaskSignTag(DycProCommonFlowConstant.TaskSignTag.BEFORE_JOIN);
            //设置新任务实例id
            newProcTaskInstPO.setTaskInstId(flowTaskInstHandleDto.getTaskInstId());
            //设置新任务实例处理人id
            newProcTaskInstPO.setTaskUserId(flowTaskInstHandleDto.getTaskUserId());
            //设置新任务实例处理人名称
            newProcTaskInstPO.setTaskUserName(flowTaskInstHandleDto.getTaskUserName());
            //设置新任务实例处理人机构id
            newProcTaskInstPO.setTaskUserOrgId(flowTaskInstHandleDto.getTaskUserOrgId());
            //设置新任务实例处理人机构名称
            newProcTaskInstPO.setTaskUserOrgName(flowTaskInstHandleDto.getTaskUserOrgName());
            //设置新任务实例处理人机构路径
            newProcTaskInstPO.setTaskUserOrgPath(flowTaskInstHandleDto.getTaskUserOrgPath());
            //设置新任务实例处理人公司id
            newProcTaskInstPO.setTaskUserCompanyId(flowTaskInstHandleDto.getTaskUserCompanyId());
            //设置新任务实例处理人公司名称
            newProcTaskInstPO.setTaskUserCompanyName(flowTaskInstHandleDto.getTaskUserCompanyName());

            this.publicProcTaskInstMapper.insert(newProcTaskInstPO);
        }
    }

    /**
     * 任务的转签
     */
    @Override
    public void transfFlowTask(DycProPublicTaskInstDTO flowTaskInstDto) {
        //参数校验
        this.transfFlowTaskParamVerify(flowTaskInstDto);

        //查询原任务数据
        PublicProcTaskInstPO oldProcTaskInstPO = this.publicProcTaskInstMapper.selectOne(Wrappers.<PublicProcTaskInstPO>lambdaQuery()
                .eq(PublicProcTaskInstPO::getTaskInstId, flowTaskInstDto.getTaskInstId())
                .eq(PublicProcTaskInstPO::getFinishTag, DycProCommonFlowConstant.FinishTag.FINISH_TAG_NOT_FINISH)
                .eq(PublicProcTaskInstPO::getDelFlag, DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL));

        if(null == oldProcTaskInstPO){
            throw new ZTBusinessException("该任务【"+flowTaskInstDto.getTaskInstId()+"】不为未完成状态，不可转签");
        }else {
            //更新原任务处理人
            PublicProcTaskInstPO updateOldProcTaskInstPO = new PublicProcTaskInstPO();
            BeanUtils.copyProperties(oldProcTaskInstPO,updateOldProcTaskInstPO);
            //设置任务标识为转签
            updateOldProcTaskInstPO.setTaskSignTag(DycProCommonFlowConstant.TaskSignTag.TRANSFER);
            //设置任务新的处理人id
            updateOldProcTaskInstPO.setTaskUserId(flowTaskInstDto.getTaskUserId());
            //设置任务新的处理人名称
            updateOldProcTaskInstPO.setTaskUserName(flowTaskInstDto.getTaskUserName());
            //设置任务新的处理人机构id
            updateOldProcTaskInstPO.setTaskUserOrgId(flowTaskInstDto.getTaskUserOrgId());
            //设置任务新的处理人机构名称
            updateOldProcTaskInstPO.setTaskUserOrgName(flowTaskInstDto.getTaskUserOrgName());
            //设置任务新的处理人机构路径
            updateOldProcTaskInstPO.setTaskUserOrgPath(flowTaskInstDto.getTaskUserOrgPath());
            //设置任务新的处理人公司id
            updateOldProcTaskInstPO.setTaskUserCompanyId(flowTaskInstDto.getTaskUserCompanyId());
            //设置任务新的处理人公司名称
            updateOldProcTaskInstPO.setTaskUserCompanyName(flowTaskInstDto.getTaskUserCompanyName());
            this.publicProcTaskInstMapper.updateById(updateOldProcTaskInstPO);
        }
    }

    @Override
    public List<DycProPublicTaskInstDTO> queryFlowTaskList(DycProPublicTaskInstDTO flowTaskInstDto) {

        List<PublicProcTaskInstPO> publicProcTaskInstPOS = publicProcTaskInstMapper.selectList(Wrappers.<PublicProcTaskInstPO>lambdaQuery()
                .eq(flowTaskInstDto.getObjId() != null, PublicProcTaskInstPO::getObjId, flowTaskInstDto.getObjId())
                .eq(!ObjectUtils.isEmpty(flowTaskInstDto.getObjType()), PublicProcTaskInstPO::getObjType, flowTaskInstDto.getObjType())
                .eq(flowTaskInstDto.getFinishTag() != null, PublicProcTaskInstPO::getFinishTag, flowTaskInstDto.getFinishTag())
                .orderByDesc(PublicProcTaskInstPO::getCreateTime));
        if (!CollectionUtils.isEmpty(publicProcTaskInstPOS)) {
            return JSON.parseArray(JSON.toJSONString(publicProcTaskInstPOS), DycProPublicTaskInstDTO.class);
        } else {
            return Collections.emptyList();
        }
    }

    /**
     * 前加签入参校验
     */
    private void beforeJoinFlowTaskParamVerify(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto){
        if (StringUtils.isBlank(flowTaskInstHandleDto.getOldTaskInstId())) {
            throw new ZTBusinessException("原任务实例ID【oldTaskInstId】不能为空");
        }
        if (StringUtils.isBlank(flowTaskInstHandleDto.getTaskInstId())) {
            throw new ZTBusinessException("任务ID【taskInstId】不能为空");
        }
        if (null == flowTaskInstHandleDto.getTaskUserId()) {
            throw new ZTBusinessException("任务待办人id不能为空");
        }
        if (StringUtils.isBlank(flowTaskInstHandleDto.getTaskUserName())) {
            throw new ZTBusinessException("任务待办人名称不能为空");
        }
        if (null == flowTaskInstHandleDto.getTaskUserOrgId()) {
            throw new ZTBusinessException("任务待办人机构id不能为空");
        }
        if (StringUtils.isBlank(flowTaskInstHandleDto.getTaskUserOrgName())) {
            throw new ZTBusinessException("任务待办人机构名称不能为空");
        }
        if (null == flowTaskInstHandleDto.getTaskUserCompanyId()) {
            throw new ZTBusinessException("任务待办人公司id不能为空");
        }
        if (StringUtils.isBlank(flowTaskInstHandleDto.getTaskUserCompanyName())) {
            throw new ZTBusinessException("任务待办人公司名称不能为空");
        }
    }

    /**
     * 任务的新增(批量)参数校验
     */
    private void addFlowTasksParamVerify(List<DycProPublicTaskInstDTO> procTaskList) {

        if(procTaskList.isEmpty()){
            throw new ZTBusinessException("任务集合不能为空");
        }
        for (DycProPublicTaskInstDTO flowTaskInstDto : procTaskList) {
            int index = procTaskList.indexOf(flowTaskInstDto);
            if (StringUtils.isBlank(flowTaskInstDto.getTaskInstId())) {
                throw new ZTBusinessException("集合当中第" + (index+1) + "个任务ID不能为空");
            }
            if (StringUtils.isBlank(flowTaskInstDto.getProcInstId())) {
                throw new ZTBusinessException("集合当中第" + (index+1) + "个流程实例ID不能为空");
            }
            if (StringUtils.isBlank(flowTaskInstDto.getCenterCode())) {
                throw new ZTBusinessException("集合当中第" + (index+1) + "个所属中心不能为空");
            }
            if (StringUtils.isBlank(flowTaskInstDto.getProcDefKey())) {
                throw new ZTBusinessException("集合当中第" + (index+1) + "个流程定义key不能为空");
            }
            if (StringUtils.isBlank(flowTaskInstDto.getProcType())) {
                throw new ZTBusinessException("集合当中第" + (index+1) + "个流程类型不能为空");
            }
            if (null == flowTaskInstDto.getObjId()) {
                throw new ZTBusinessException("集合当中第" + (index+1) + "个业务单据id不能为空");
            }
            if (null == flowTaskInstDto.getObjType()) {
                throw new ZTBusinessException("集合当中第" + (index+1) + "个业务单据类型不能为空");
            }
            if (null == flowTaskInstDto.getTaskSignTag()) {
                throw new ZTBusinessException("集合当中第" + (index+1) + "个任务标识不能为空");
            }
            if (StringUtils.isBlank(flowTaskInstDto.getStepCode())) {
                throw new ZTBusinessException("集合当中第" + (index+1) + "个环节编码不能为空");
            }
            if (StringUtils.isBlank(flowTaskInstDto.getStepName())) {
                throw new ZTBusinessException("集合当中第" + (index+1) + "个环节名称不能为空");
            }
            if (DycProCommonFlowConstant.ProcType.APPROVE.equals(flowTaskInstDto.getProcType())) {
                if (null == flowTaskInstDto.getTaskUserId()) {
                    throw new ZTBusinessException("集合当中第" + (index + 1) + "个任务待办人id不能为空");
                }
                if (StringUtils.isBlank(flowTaskInstDto.getTaskUserName())) {
                    throw new ZTBusinessException("集合当中第" + (index + 1) + "个任务待办人名称不能为空");
                }
                if (null == flowTaskInstDto.getTaskUserOrgId()) {
                    throw new ZTBusinessException("集合当中第" + (index + 1) + "个任务待办人机构id不能为空");
                }
                if (StringUtils.isBlank(flowTaskInstDto.getTaskUserOrgName())) {
                    throw new ZTBusinessException("集合当中第" + (index + 1) + "个任务待办人机构名称不能为空");
                }
                if (null == flowTaskInstDto.getTaskUserCompanyId()) {
                    throw new ZTBusinessException("集合当中第" + (index + 1) + "个任务待办人公司id不能为空");
                }
                if (StringUtils.isBlank(flowTaskInstDto.getTaskUserCompanyName())) {
                    throw new ZTBusinessException("集合当中第" + (index + 1) + "个任务待办人公司名称不能为空");
                }
            }
        }
    }

    /**
     * 任务转签参数校验
     */
    private void transfFlowTaskParamVerify(DycProPublicTaskInstDTO flowTaskInstDto) {
        if (StringUtils.isBlank(flowTaskInstDto.getTaskInstId())) {
            throw new ZTBusinessException("任务ID【taskInstId】不能为空");
        }
        if (null == flowTaskInstDto.getTaskUserId()) {
            throw new ZTBusinessException("任务归属人ID【taskUserId】不能为空");
        }
        if (StringUtils.isBlank(flowTaskInstDto.getTaskUserName())) {
            throw new ZTBusinessException("任务待办人名称【taskUserName】不能为空");
        }
        if (null == flowTaskInstDto.getTaskUserOrgId()) {
            throw new ZTBusinessException("任务待办人机构ID【taskUserOrgId】不能为空");
        }
        if (StringUtils.isBlank(flowTaskInstDto.getTaskUserOrgName())) {
            throw new ZTBusinessException("任务待办人机构名称【taskUserOrgName】不能为空");
        }
        if (null == flowTaskInstDto.getTaskUserCompanyId()) {
            throw new ZTBusinessException("任务待办人公司ID【taskUserCompanyId】不能为空");
        }
        if (StringUtils.isBlank(flowTaskInstDto.getTaskUserCompanyName())) {
            throw new ZTBusinessException("任务待办人公司名称【taskUserCompanyName】不能为空");
        }
    }

    /**
     * 完成流程任务参数校验(审批流)
     */
    private void completeFlowTaskParamVerify(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto) {
        if(StringUtils.isBlank(flowTaskInstHandleDto.getTaskInstId())){
            throw new ZTBusinessException("任务ID【taskInstId】不能为空");
        }
        if (StringUtils.isBlank(flowTaskInstHandleDto.getLinkJudge())) {
            throw new ZTBusinessException("环节是否结束判断【linkJudge】不能为空");
        }
        if (null == flowTaskInstHandleDto.getIsFinish()) {
            throw new ZTBusinessException("流程是否结束判断【isFinish】不能为空");
        }
    }

    /**
     * 完成流程任务参数校验(业务流)
     */
    private void completeBusiFlowTaskParamVerify(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto) {
        if(StringUtils.isBlank(flowTaskInstHandleDto.getTaskInstId())){
            throw new ZTBusinessException("任务ID【taskInstId】不能为空");
        }
    }

}

