package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 交易模式 枚举
 *
 * @author lihulin
 */

public enum DmcAgrMainTradeMode implements DictionaryEnum {
    MY("DMC_AGR_MAIN_TRADE_MODE", "1", "贸易模式", "交易模式"),
    CH("DMC_AGR_MAIN_TRADE_MODE", "2", "撮合模式", "交易模式");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrMainTradeMode(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
