package com.tydic.dyc.pro.base.core.dictionary.utils;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.pro.base.core.dictionary.enums.*;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: 欧迅
 * @CreateTime: 2024-12-30
 * @Description: 字典工具类
 * @Version: 1.0
 */
@Slf4j
public class DictionaryFrameworkUtils {

    //public static final Map<String, List<SysDictionaryDataBO>> dicMap = new ConcurrentHashMap();

    public static final Map<String, Class<? extends DictionaryEnum>> ENUM_MAP = new HashMap<>();

    static {
        // 通用枚举
        ENUM_MAP.put(EnableFlag.class.getSimpleName(), EnableFlag.class);
        ENUM_MAP.put(BooleanFlag.class.getSimpleName(), BooleanFlag.class);
        ENUM_MAP.put(IsProfessFlag.class.getSimpleName(), IsProfessFlag.class);
        ENUM_MAP.put(PublicProcInstBusiType.class.getSimpleName(), PublicProcInstBusiType.class);
        ENUM_MAP.put(PublicProcInstDealResult.class.getSimpleName(), PublicProcInstDealResult.class);
        ENUM_MAP.put(PublicPorcInstDataStatus.class.getSimpleName(), PublicPorcInstDataStatus.class);

        // 订单相关枚举
        ENUM_MAP.put(EgcSaleOrderSaleOrderState.class.getSimpleName(), EgcSaleOrderSaleOrderState.class);
        ENUM_MAP.put(EgcSaleOrderChngOrderState.class.getSimpleName(), EgcSaleOrderChngOrderState.class);
        ENUM_MAP.put(EgcSaleOrderOrderStage.class.getSimpleName(), EgcSaleOrderOrderStage.class);
        ENUM_MAP.put(EgcShipOrderTransportMode.class.getSimpleName(), EgcShipOrderTransportMode.class);
        ENUM_MAP.put(EgcShipOrderShipCompanyId.class.getSimpleName(), EgcShipOrderShipCompanyId.class);
        ENUM_MAP.put(EgcShipOrderShipOrderState.class.getSimpleName(), EgcShipOrderShipOrderState.class);
        ENUM_MAP.put(EgcAfOrderServState.class.getSimpleName(), EgcAfOrderServState.class);
        ENUM_MAP.put(EgcAfOrderServType.class.getSimpleName(), EgcAfOrderServType.class);
        ENUM_MAP.put(EgcAfOrderPickwareType.class.getSimpleName(), EgcAfOrderPickwareType.class);
        ENUM_MAP.put(EgcAfOrderAfsReason.class.getSimpleName(), EgcAfOrderAfsReason.class);
        ENUM_MAP.put(EgcAfOrderWaybillFlag.class.getSimpleName(), EgcAfOrderWaybillFlag.class);
        ENUM_MAP.put(EgcChngOrderChngType.class.getSimpleName(), EgcChngOrderChngType.class);
        ENUM_MAP.put(EgcSaleOrderPayState.class.getSimpleName(), EgcSaleOrderPayState.class);


        // 商品相关枚举
        ENUM_MAP.put(DmcCommExtSkuMessageRecordsSupplierHsn.class.getSimpleName(), DmcCommExtSkuMessageRecordsSupplierHsn.class);
        ENUM_MAP.put(DmcCommPoolInfoPoolRelated.class.getSimpleName(), DmcCommPoolInfoPoolRelated.class);
        ENUM_MAP.put(DmcCommChannelInfoDispalyFlag.class.getSimpleName(), DmcCommChannelInfoDispalyFlag.class);
        ENUM_MAP.put(DmcCommChannelInfoRelatedType.class.getSimpleName(), DmcCommChannelInfoRelatedType.class);
        ENUM_MAP.put(DmcCommMallPropertyInfoMallPropertyFlag.class.getSimpleName(), DmcCommMallPropertyInfoMallPropertyFlag.class);
        ENUM_MAP.put(DmcCommMallPropertyValueInfoMallPropertyFlag.class.getSimpleName(), DmcCommMallPropertyValueInfoMallPropertyFlag.class);
        ENUM_MAP.put(DmcCommMallPropertyInfoMallPropertySource.class.getSimpleName(), DmcCommMallPropertyInfoMallPropertySource.class);
        ENUM_MAP.put(DmcCommMallPropertyInfoHavePropertyValue.class.getSimpleName(), DmcCommMallPropertyInfoHavePropertyValue.class);
        ENUM_MAP.put(DmcCommManageCatalogInfoLastLevelFlag.class.getSimpleName(), DmcCommManageCatalogInfoLastLevelFlag.class);
        ENUM_MAP.put(DmcCommManageCatalogInfoManageCatalogLevel.class.getSimpleName(), DmcCommManageCatalogInfoManageCatalogLevel.class);
        ENUM_MAP.put(DmcCommManageCatalogMallPropertyMountRelRequiredFlag.class.getSimpleName(), DmcCommManageCatalogMallPropertyMountRelRequiredFlag.class);
        ENUM_MAP.put(DmcCommBanRuleStatusEnum.class.getSimpleName(), DmcCommBanRuleStatusEnum.class);
        ENUM_MAP.put(DmcCommExtSkuMessageRecordsExtPoolState.class.getSimpleName(), DmcCommExtSkuMessageRecordsExtPoolState.class);
        ENUM_MAP.put(DmcCommExtSkuMessageRecordsMessageStatus.class.getSimpleName(), DmcCommExtSkuMessageRecordsMessageStatus.class);
        ENUM_MAP.put(DmcCommExtSkuMessageRecordsMessageType.class.getSimpleName(), DmcCommExtSkuMessageRecordsMessageType.class);
        ENUM_MAP.put(DmcCommSkuInfoSkuStatus.class.getSimpleName(), DmcCommSkuInfoSkuStatus.class);
        ENUM_MAP.put(DmcCommSkuInfoApprovalStatus.class.getSimpleName(), DmcCommSkuInfoApprovalStatus.class);
        ENUM_MAP.put(DmcCommSkuInfoExamineStatus.class.getSimpleName(), DmcCommSkuInfoExamineStatus.class);
        ENUM_MAP.put(DmcCommPurchaseOrgTypeEnum.class.getSimpleName(), DmcCommPurchaseOrgTypeEnum.class);
        ENUM_MAP.put(DmcCommSkuInfoBansFlag.class.getSimpleName(), DmcCommSkuInfoBansFlag.class);
        ENUM_MAP.put(DmcCommSkuInfoOnShelveWay.class.getSimpleName(), DmcCommSkuInfoOnShelveWay.class);
        ENUM_MAP.put(DmcCommSkuAfterSaleInfoIsAllowAfterSale.class.getSimpleName(), DmcCommSkuAfterSaleInfoIsAllowAfterSale.class);
        ENUM_MAP.put(DmcCommSkuAfterSaleInfoTimeLimit.class.getSimpleName(), DmcCommSkuAfterSaleInfoTimeLimit.class);
        ENUM_MAP.put(DmcCommSkuAfterSaleInfoReturnType.class.getSimpleName(), DmcCommSkuAfterSaleInfoReturnType.class);
        ENUM_MAP.put(DmcCommBansRecordBansTypeEnum.class.getSimpleName(), DmcCommBansRecordBansTypeEnum.class);
        ENUM_MAP.put(DmcCommManageCatalogInfoPurchaseType.class.getSimpleName(), DmcCommManageCatalogInfoPurchaseType.class);
        ENUM_MAP.put(DmcCommManageCatalogInfoMaterialType.class.getSimpleName(), DmcCommManageCatalogInfoMaterialType.class);
        ENUM_MAP.put(DmcCommMStatus.class.getSimpleName(), DmcCommMStatus.class);
        ENUM_MAP.put(DmcCommUpcSource.class.getSimpleName(), DmcCommUpcSource.class);
        ENUM_MAP.put(DmcCommUpcInfoStatus.class.getSimpleName(), DmcCommUpcInfoStatus.class);


        // 协议相关枚举
        ENUM_MAP.put(DmcAgrItemTaxRate.class.getSimpleName(), DmcAgrItemTaxRate.class);
        ENUM_MAP.put(DmcAgrConfirmType.class.getSimpleName(), DmcAgrConfirmType.class);
        ENUM_MAP.put(DmcAgrMainAdjustPriceType.class.getSimpleName(), DmcAgrMainAdjustPriceType.class);
        ENUM_MAP.put(DmcAgrMainAgreementVariety.class.getSimpleName(), DmcAgrMainAgreementVariety.class);
        ENUM_MAP.put(DmcAgrMainAgrMode.class.getSimpleName(), DmcAgrMainAgrMode.class);
        ENUM_MAP.put(DmcAgrMainAgrSrc.class.getSimpleName(), DmcAgrMainAgrSrc.class);
        ENUM_MAP.put(DmcAgrMainAgrStatus.class.getSimpleName(), DmcAgrMainAgrStatus.class);
        ENUM_MAP.put(DmcAgrMainAgrType.class.getSimpleName(), DmcAgrMainAgrType.class);
        ENUM_MAP.put(DmcAgrMainAgrVersionFormWay.class.getSimpleName(), DmcAgrMainAgrVersionFormWay.class);
        ENUM_MAP.put(DmcAgrMainPurScopeType.class.getSimpleName(), DmcAgrMainPurScopeType.class);
        ENUM_MAP.put(DmcAgrMainQuaprotectUnit.class.getSimpleName(), DmcAgrMainQuaprotectUnit.class);
        ENUM_MAP.put(DmcAgrMainTradeMode.class.getSimpleName(), DmcAgrMainTradeMode.class);
        ENUM_MAP.put(DmcAgrMainVendorMode.class.getSimpleName(), DmcAgrMainVendorMode.class);
        ENUM_MAP.put(DmcAgrChngApplyChngType.class.getSimpleName(), DmcAgrChngApplyChngType.class);
        ENUM_MAP.put(DmcAgrChngApplyChngApplyStatus.class.getSimpleName(), DmcAgrChngApplyChngApplyStatus.class);
        ENUM_MAP.put(DmcAgrItemChngOperRecorAgrItemChngType.class.getSimpleName(), DmcAgrItemChngOperRecorAgrItemChngType.class);
        ENUM_MAP.put(DmcAgrItemInitCommFlag.class.getSimpleName(), DmcAgrItemInitCommFlag.class);

        // 检测规则相关
        ENUM_MAP.put("DmcCommCheckExecActionEnum", DmcCommCheckExecActionEnum.class);
        ENUM_MAP.put("DmcCommCheckItemCheckIndexEnum", DmcCommCheckItemCheckIndexEnum.class);
        ENUM_MAP.put("DmcCommCheckItemVarificationIndexEnum", DmcCommCheckItemVarificationIndexEnum.class);
        ENUM_MAP.put("DmcCommCheckObjEnum", DmcCommCheckObjEnum.class);
        ENUM_MAP.put("DmcCommCheckResultEnum", DmcCommCheckResultEnum.class);
        ENUM_MAP.put("DmcCommCheckRuleStatusEnum", DmcCommCheckRuleStatusEnum.class);
        ENUM_MAP.put("DmcCommCheckRuleTypeEnum", DmcCommCheckRuleTypeEnum.class);
        ENUM_MAP.put("DmcCommCheckSenceEnum", DmcCommCheckSenceEnum.class);
        ENUM_MAP.put("DmcCommCheckStatusEnum", DmcCommCheckStatusEnum.class);

        //寻源相关枚举
        ENUM_MAP.put(DmcSscSupplyApplyInfoPurchaseForm.class.getSimpleName(), DmcSscSupplyApplyInfoPurchaseForm.class);
        ENUM_MAP.put(DmcSscSupplyApplyInfoStatus.class.getSimpleName(), DmcSscSupplyApplyInfoStatus.class);
        ENUM_MAP.put(DmcSscAuditDealResult.class.getSimpleName(), DmcSscAuditDealResult.class);
        ENUM_MAP.put(DmcSscSupplyApplyItemStatus.class.getSimpleName(), DmcSscSupplyApplyItemStatus.class);
        ENUM_MAP.put(DmcSscConsultStatus.class.getSimpleName(), DmcSscConsultStatus.class);
        ENUM_MAP.put(DmcSscConsultStatusJJ.class.getSimpleName(), DmcSscConsultStatusJJ.class);
        ENUM_MAP.put(DmcSscConsultStatusYJ.class.getSimpleName(), DmcSscConsultStatusYJ.class);
        ENUM_MAP.put(DmcSscConsultIsChosen.class.getSimpleName(), DmcSscConsultIsChosen.class);
        ENUM_MAP.put(DmcSscConsultQuoteTurn.class.getSimpleName(), DmcSscConsultQuoteTurn.class);
        ENUM_MAP.put(DmcSscConsultQuoteStatus.class.getSimpleName(), DmcSscConsultQuoteStatus.class);
        ENUM_MAP.put(DmcSscConsultShelveType.class.getSimpleName(), DmcSscConsultShelveType.class);

        ENUM_MAP.put(DmcSscConsultAllowMissingItems.class.getSimpleName(), DmcSscConsultAllowMissingItems.class);
        ENUM_MAP.put(DmcSscConsultProductScopeType.class.getSimpleName(), DmcSscConsultProductScopeType.class);

        //加价规则相关枚举
        ENUM_MAP.put(DmcCommPriceRuleHighMarketPriceRuleEnum.class.getSimpleName(), DmcCommPriceRuleHighMarketPriceRuleEnum.class);
        ENUM_MAP.put(DmcCommPriceRuleRoundRuleEnum.class.getSimpleName(), DmcCommPriceRuleRoundRuleEnum.class);
        ENUM_MAP.put(DmcCommPriceRuleSkuRangeTypeEnum.class.getSimpleName(), DmcCommPriceRuleSkuRangeTypeEnum.class);
        ENUM_MAP.put(DmcCommPriceRuleStatusEnum.class.getSimpleName(), DmcCommPriceRuleStatusEnum.class);

        //店铺相关枚举
        ENUM_MAP.put(DmcShopMainShopStatus.class.getSimpleName(), DmcShopMainShopStatus.class);

        //操作记录
        ENUM_MAP.put(DmcCommOperateRecordOperateUserType.class.getSimpleName(), DmcCommOperateRecordOperateUserType.class);

        //图文检测
        ENUM_MAP.put(DmcAliyunImageScanLableEnum.class.getSimpleName(), DmcAliyunImageScanLableEnum.class);

        // 工作日历表
        ENUM_MAP.put(DmcSscWorkDayDateType.class.getSimpleName(), DmcSscWorkDayDateType.class);
        ENUM_MAP.put(DmcSscWorkDayFestival.class.getSimpleName(), DmcSscWorkDayFestival.class);
        ENUM_MAP.put(DmcSscWorkDayIsDel.class.getSimpleName(), DmcSscWorkDayIsDel.class);
        ENUM_MAP.put(DmcSscWorkDayWeek.class.getSimpleName(), DmcSscWorkDayWeek.class);
        ENUM_MAP.put(DmcSscWorkDayYear.class.getSimpleName(), DmcSscWorkDayYear.class);
        // 采购管理
        ENUM_MAP.put(ZLEgcPurApplyStatus.class.getSimpleName(), ZLEgcPurApplyStatus.class);
        ENUM_MAP.put(ZLEgcPurApplyItemStatus.class.getSimpleName(), ZLEgcPurApplyItemStatus.class);
        ENUM_MAP.put(ZLEgcPurApplySourceStatus.class.getSimpleName(), ZLEgcPurApplySourceStatus.class);
        //预算管理
        ENUM_MAP.put(ZLEgcBudgetStatus.class.getSimpleName(), ZLEgcBudgetStatus.class);



    }

    @SneakyThrows
    public static String getDicDataByValue(String centerTableField, String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        List<SysDictionaryDataBO> values = getListByCenterTableField(centerTableField);
        if (!CollectionUtils.isEmpty(values)) {
            for (SysDictionaryDataBO item : values) {
                if (item.getValue().equals(value)) {
                    return item.getCode();
                }
            }
        }
        return null;
    }

    @SneakyThrows
    public static String getDicDataByCode(String centerTableField, String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        List<SysDictionaryDataBO> values = getListByCenterTableField(centerTableField);
        if (!CollectionUtils.isEmpty(values)) {
            for (SysDictionaryDataBO item : values) {
                if (item.getCode().equals(code)) {
                    return item.getValue();
                }
            }
        }
        return null;
    }

    @SneakyThrows
    public static List<SysDictionaryDataBO> getListByCenterTableField(String centerTableField) {
        if (StringUtils.isBlank(centerTableField)) {
            return null;
        }
        // 通过类名加载枚举类
        Class<?> enumClass = ENUM_MAP.get(centerTableField);
        if (null == enumClass) {
            return null;
        }
        // 遍历枚举常量
        List<SysDictionaryDataBO> values = new ArrayList<>();
        for (DictionaryEnum item : (DictionaryEnum[]) enumClass.getEnumConstants()) {
            SysDictionaryDataBO sysDictionaryDataBO = new SysDictionaryDataBO();
            sysDictionaryDataBO.setDictionaryCode(item.getDictionaryCode());
            sysDictionaryDataBO.setDictionaryName(item.getDictionaryName());
            sysDictionaryDataBO.setCode(item.getCode());
            sysDictionaryDataBO.setValue(item.getValue());
            values.add(sysDictionaryDataBO);
        }
        return values;
    }

    public static void main(String[] args) {
        //System.out.println(JSON.toJSONString(dicMap));
        List<SysDictionaryDataBO> values = DictionaryFrameworkUtils.getListByCenterTableField("UocUocShipOrderShipOrderState");
        System.out.println(JSON.toJSONString(values));
        //SysDictionaryDataBO code = DictionaryFrameworkUtils.getDicDataByCode("UocUocShipOrderShipOrderState", "XS_YS_DH");
        //System.out.println(JSON.toJSONString(code));
        //SysDictionaryDataBO value = DictionaryFrameworkUtils.getDicDataByValue("UocUocShipOrderShipOrderState", "已拒收");
        //System.out.println(JSON.toJSONString(value));
    }
}
