package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @description 电商识别编码 cg:晨光 zkh:震坤行
 * @author Luokan
 * @date 2025/04/23
 **/

public enum DmcCommExtSkuMessageRecordsSupplierHsn implements DictionaryEnum{
    /**
     * cg:晨光
     */
    CG("SUPPLIER_HSN", "cg","晨光", "电商识别编码"),
    /**
     * zkh:震坤行
     */
    ZKH("SUPPLIER_HSN", "zkh","震坤行工业超市（上海）有限公司", "电商识别编码"),
    /**
     * bigao:比高
     */
    BIGAO("SUPPLIER_HSN", "bigao","江苏比高机电设备有限公司", "电商识别编码"),
    /**
     * xmh:新明辉
     */
    XMH("SUPPLIER_HSN", "xmh","山东新明辉安全科技有限公司", "电商识别编码"),
    /**
     * ehsy:西域
     */
    ehsy("SUPPLIER_HSN", "ehsy","西域智慧供应链（上海）股份公司", "电商识别编码"),
    /**
     * qstbg:企事通
     */
    qstbg("SUPPLIER_HSN", "qstbg","企事通集团有限公司", "电商识别编码"),
    /**
     * jihua:际华
     */
    jihua("SUPPLIER_HSN", "jihua","际华三五零二职业装有限公司", "电商识别编码"),
    /**
     * xhgj:咸亨国际
     */
    xhgj("SUPPLIER_HSN", "xhgj","咸亨国际科技股份有限公司", "电商识别编码"),
    /**
     * jd:京东
     */
    JD("SUPPLIER_HSN", "jd","北京京东世纪信息技术有限公司", "电商识别编码"),
    /**
     * jdvop:京东VOP
     */
    JD_VOP("SUPPLIER_HSN", "jdvop","京东VOP", "电商识别编码");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommExtSkuMessageRecordsSupplierHsn(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
