package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：EgcAfOrderWaybillFlag
 * 描述：售后是否可维护发运信息
 */
public enum EgcAfOrderWaybillFlag implements DictionaryEnum {

    CAN_MAINTAIN("WAYBILL_FLAG", "1", "是", "售后是否可维护发运信息"),
    CAN_NOT_MAINTAIN("WAYBILL_FLAG", "0", "否", "售后是否可维护发运信息");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EgcAfOrderWaybillFlag(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
