package com.tydic.dyc.pro.base.core.po;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 描述：流程实例对象
 * @author yuhao
 * @date 2025-04-17 17:47
 **/
@Data
@TableName("PUBLIC_PROC_INST")
public class PublicProcInstPO implements Serializable {

	private static final long serialVersionUID = 6644164232519620587L;

	/**
	 * 单据id
	 */
	@TableField(value = "DATA_ID")
	@TableId
    private Long dataId;
	/**
	 * 单据编码
	 */
	@TableField(value = "DATA_CODE")
	private String dataCode;
	/**
	 * 单据名称
	 */
	@TableField(value = "DATA_NAME")
	private String dataName;
	/**
	 * 单据备注
	 */
	@TableField(value = "DATA_REMARK")
	private String dataRemark;
	/**
	 * 单据状态:
	 * 1：审批中
	 * 2：已通过
	 * 3：已驳回
	 */
	@TableField(value = "DATA_STATUS")
	private Integer dataStatus;
	/**
	 * 业务类型
	 */
	@TableField(value = "BUSI_TYPE")
	private String busiType;
	/**
	 * 单据申请人id
	 */
	@TableField(value = "CREATE_USER_ID")
	private Long createUserId;
	/**
	 * 单据申请人名称
	 */
	@TableField(value = "CREATE_USER_NAME")
	private String createUserName;
	/**
	 * 单据申请人机构id
	 */
	@TableField(value = "CREATE_USER_ORG_ID")
	private Long createUserOrgId;
	/**
	 * 单据申请人机构名称
	 */
	@TableField(value = "CREATE_USER_ORG_NAME")
	private String createUserOrgName;
	/**
	 * 单据申请人公司id
	 */
	@TableField(value = "CREATE_USER_COMPANY_ID")
	private Long createUserCompanyId;
	/**
	 * 单据申请人公司名称
	 */
	@TableField(value = "CREATE_USER_COMPANY_NAME")
	private String createUserCompanyName;
	/**
	 * 单据申请人机构树
	 */
	@TableField(value = "CREATE_USER_ORG_PATH")
	private String createUserOrgPath;
	/**
	 * 所属中心:
            AGR：协议
            UOC：订单
            UMC：会员
            FSC：结算
            UCC：商品
            
	 */
	@TableField(value = "CENTER_CODE")
    private String centerCode;
	/**
	 * 流程实例id
	 */
	@TableField(value = "PROC_INST_ID")
    private String procInstId;
	/**
	 * 流程定义key
	 */
	@TableField(value = "PROC_DEF_KEY")
    private String procDefKey;
	/**
	 * 流程名称
	 */
	@TableField(value = "PROC_NAME")
    private String procName;
	/**
	 * 流程类型:
            业务流：BUSINESS;
            审批流：APPROVE
	 */
	@TableField(value = "PROC_TYPE")
    private String procType;
	/**
	 * 业务对象id
	 */
	@TableField(value = "OBJ_ID")
    private Long objId;
	/**
	 * 业务对象类型:
            订单相关单据：10打头，后面加2位数字编码，如10XX；
            商品相关单据：20打头，后面加2位数字编码，如20XX；
            协议相关单据：30打头，后面加2位数字编码，如30XX；
            会员相关单据：40打头，后面加2位数字编码，如40XX；
            结算相关单据：50打头，后面加2位数字编码，如50XX；
            
	 */
	@TableField(value = "OBJ_TYPE")
    private String objType;
	/**
	 * 流程创建时间
	 */
	@TableField(value = "CREATE_TIME")
    private Date createTime;
	/**
	 * 流程完结标志：
            0：未完结
            1：已完结;
            2：已取消
	 */
	@TableField(value = "FINISH_TAG")
    private Integer finishTag;
	/**
	 * 流程完成时间
	 */
	@TableField(value = "FINISH_TIME")
    private Date finishTime;
	/**
	 * 删除标志：0:未删除；1已删除
	 */
	@TableField(value = "DEL_FLAG")
    private Integer delFlag;

}