package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标准商品赋码状态
 */
public enum DmcCommMStatus implements DictionaryEnum{
    FORMAL("DMC_COMM_M_STATUS", "1", "正式码", "标准商品赋码状态"),
    TEMPORARY("DMC_COMM_M_STATUS", "2", "临时码", "标准商品赋码状态");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;
    DmcCommMStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    @Override
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    @Override
    public String getDictionaryName() {
        return dictionaryName;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
