package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @Author yuhao
 * @Date 2025/8/15 15:53
 * @Description:
 */
public enum ZLDmcProCompanyCode implements DictionaryEnum{

    /**
     * 糖业
     */
    TANG_YE_COMPANY_CODE("RPO_COMPANY_CODE", "1", "6800", "糖业专业公司代码"),

    /**
     * 粮谷
     */
    LIANG_GU_COMPANY_CODE("RPO_COMPANY_CODE", "2", "1019", "粮谷专业公司代码");

    /**
     * 编码
     */
    private final String dictionaryCode;
    /**
     * 编码
     */
    private final String code;
    /**
     * 编码值
     */
    private final String value;
    /**
     * 名称
     */
    private final String dictionaryName;

    ZLDmcProCompanyCode(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
