package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @description 商品池关联方式
 *   0：草稿
 * 	 1：待上架
 * 	 2：已上架
 * 	 3：已下架
 * 	 4：已失效
 * 	 5：合规校验失败
 * @author luoyou
 * @date 2025/04/24
 **/

public enum DmcCommUpcInfoStatus implements DictionaryEnum{

    DRAFT("DMC_COMM_UPC_INFO_STATUS", "0","审批中", "标准商品状态"),
    PASS("DMC_COMM_UPC_INFO_STATUS", "1","审批通过", "标准商品状态"),
    REJECT("DMC_COMM_UPC_INFO_STATUS", "2","审批驳回", "标准商品状态"),
    ;
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommUpcInfoStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
