package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：DmcCommManageCatalogInfoPurchaseType
 * 说明：采购类型
 * 时间：2025/08/11 11:13
 *
 * @author lihulin
 **/
public enum DmcCommManageCatalogInfoPurchaseType implements DictionaryEnum {
    BGL("PURCHASE_TYPE", "1", "办公类", "采购类型"),
    MOR("PURCHASE_TYPE", "2", "MRO集采", "采购类型"),
    GC("PURCHASE_TYPE", "3", "公车", "采购类型"),
    SYSB("PURCHASE_TYPE", "4", "实验设备", "采购类型"),
    FWL("PURCHASE_TYPE", "5", "服务类", "采购类型"),
    ALL("PURCHASE_TYPE", "99", "全部", "采购类型");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommManageCatalogInfoPurchaseType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
