package com.tydic.dyc.pro.base.core.flow.repository.constants;

/**
 * 描述: 〈流程常量类〉
 * @author : yuhao
 * @date : 2024/12/23 15:52
 */
public class DycProCommonFlowConstant {

    /**
     * 流程类型
     */
    public static final class ProcType{
        /**
         * 业务流：BUSINESS;
         */
        public static final String BUSINESS = "BUSINESS";
        /**
         * 审批流：APPROVE
         */
        public static final String APPROVE = "APPROVE";
    }
    /**
     * 完结标志
     */
    public static final class FinishTag{
        /**
         * 未完结
         */
        public static final int FINISH_TAG_NOT_FINISH =0;
        /**
         * 已完结
         */
        public static final int FINISH_TAG_FINISH =1;
        /**
         * 已取消
         */
        public static final int FINISH_TAG_CANCEL =2;
    }

    /**
     * 单据状态:
     */
    public static final class DataStatus{
        /**
         * 审批中
         */
        public static final Integer PENDING_APPROVE =1;
        /**
         * 已通过
         */
        public static final Integer PASS =2;
        /**
         * 已驳回
         */
        public static final Integer REJECT =3;
    }


    /**
     * 所属中心
     */
    public static final class CenterCode{
        /**
         * 协议
         */
        public static final String AGR = "AGR";
        /**
         *商品
         */
        public static final String UCC = "UCC";
        /**
         *店铺
         */
        public static final String SHOP = "SHOP";
        /**
         *寻源
         */
        public static final String SSC = "SSC";
        /**
         *订单
         */
        public static final String UOC = "UOC";
    }

    /**
     * 删除标志
     */
    public static final class DelFlag{
        /**
         * 未删除
         */
        public static final Integer DEL_FLAG_NOT_DEL =0;
        /**
         * 已删除
         */
        public static final Integer DEL_FLAG_DEL =1;
    }

    /**
     * 环节是否结束
     */
    public static final class LinkJudge{
        /**
         * 通过
         */
        public static final String LINK_JUDGE_TRUE ="true";
        /**
         * 驳回
         */
        public static final String LINK_JUDGE_FALSE ="false";
        /**
         * 未审批完
         */
        public static final String LINK_JUDGE_UNDETERMINED = "undetermined";
    }

    /**
     * 处理结果
     */
    public static final class DealResult{
        /**
         * 通过
         */
        public static final String DEAL_RESULT_PASS ="PASS";
        /**
         * 驳回
         */
        public static final String DEAL_RESULT_REJECT ="REJECT";
        /**
         * 转交
         */
        public static final String DEAL_RESULT_TRANSFER ="TRANSFER";
    }

    /**
     * 任务标识
     */
    public static final class TaskSignTag{
        /**
         * 正常任务
         */
        public static final Integer NORMAL = 0;
        /**
         *前加签任务
         */
        public static final Integer BEFORE_JOIN = 1;
        /**
         *后加签任务
         */
        public static final Integer AFTER_JOIN = 2;
        /**
         *转签任务
         */
        public static final Integer TRANSFER = 3;
    }
}
