package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：EgcAfOrderServType
 * 描述：售后服务单类型
 */
public enum EgcAfOrderServType implements DictionaryEnum {

    RETURN_GOODS("SERV_TYPE", "10", "退货", "售后服务单类型"),
    EXCHANGE_GOODS("SERV_TYPE", "20", "换货", "售后服务单类型"),
    REPAIR("SERV_TYPE", "30", "维修", "售后服务单类型");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EgcAfOrderServType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
