package com.tydic.dyc.pro.base.core.flow.repository.api;


import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicProcInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;

import java.util.List;

/**
 * 描述：流程任务实例实体基建层
 *
 * @author yuhao
 * @date 2025-04-17 17:47
 **/
public interface DycProPublicTaskInstRepository {

    /**
     * 任务的新增(批量)
     */
    void addFlowTasks(DycProPublicProcInstDTO flowProcInstDto);

    /**
     * 任务的完成(审批流)
     */
    void completeFlowTask(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto);
    /**
     * 任务的完成(业务流)
     */
    void completeBusiFlowTask(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto);
    /**
     * 任务的前加签
     */
    void beforeJoinFlowTask(DycProPublicTaskInstHandleDTO flowTaskInstHandleDto);

    /**
     * 任务的转签
     */
    void transfFlowTask(DycProPublicTaskInstDTO flowTaskInstDto);

    /**
     * 任务实例列表查询
     */
    List<DycProPublicTaskInstDTO> queryFlowTaskList(DycProPublicTaskInstDTO flowTaskInstDto);

}

