package com.tydic.dyc.pro.base.core.dictionary.enums;
/**
 * @description 销售单状态枚举值
 * @author Luokan
 * @date 2025/04/16
 **/
public enum EgcSaleOrderSaleOrderState implements DictionaryEnum{
    /**
     * 审批中
     */
    XS_SP_SPZ("SALE_ORDER_STATE","XS_SP_SPZ","审批中", "销售单状态"),
    /**
     * 待确认
     */
    XS_QR_DQR("SALE_ORDER_STATE","XS_QR_DQR","待确认", "销售单状态"),
    /**
     * 拒单待处理
     */
    XS_QR_JDDCL("SALE_ORDER_STATE","XS_QR_JDDCL","拒单待处理", "销售单状态"),
    /**
     * 待发货
     */
    XS_FH_DFH("SALE_ORDER_STATE","XS_FH_DFH","待发货", "销售单状态"),
    /**
     * 发货中
     */
    XS_FH_FHZ("SALE_ORDER_STATE","XS_FH_FHZ","发货中", "销售单状态"),
    /**
     * 发货完成
     */
    XS_FH_FHWC("SALE_ORDER_STATE","XS_FH_FHWC","发货完成", "销售单状态"),
    /**
     * 部分到货
     */
    XS_DH_BFDH("SALE_ORDER_STATE","XS_DH_BFDH","部分到货", "销售单状态"),
    /**
     * 已到货
     */
    XS_DH_DH("SALE_ORDER_STATE","XS_DH_DH","已到货", "销售单状态"),
    /**
     * 已拒收
     */
    XS_DH_JS("SALE_ORDER_STATE","XS_DH_JS","已拒收", "销售单状态"),
    /**
     * 部分验收
     */
    XS_YS_BFYS("SALE_ORDER_STATE","XS_YS_BFYS","部分验收", "销售单状态"),
    /**
     * 已验收
     */
    XS_YS_YS("SALE_ORDER_STATE","XS_YS_YS","已验收", "销售单状态"),
    /**
     * 已取消
     */
    XS_QX_QX("SALE_ORDER_STATE","XS_QX_QX","已取消", "销售单状态"),
    /**
     * 订单取消申请中
     */
    XS_QX_QXSQ("SALE_ORDER_STATE","XS_QX_QXSQ","订单取消申请中", "销售单状态"),
    /**
     * 下单失败
     */
    XS_XD_SB("SALE_ORDER_STATE","XS_XD_SB","下单失败", "销售单状态"),
    /**
     * 待确认（公车）
     */
    XS_CAR_QR_DQR("SALE_ORDER_STATE","XS_CAR_QR_DQR","待确认", "销售单状态"),
    /**
     * 待复核（公车）
     */
    XS_CAR_HD_DHD("SALE_ORDER_STATE","XS_CAR_HD_DHD","待复核", "销售单状态");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EgcSaleOrderSaleOrderState(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
