package com.tydic.dyc.pro.base.core.encode.service.impl;


import com.alibaba.fastjson.JSON;
import com.tydic.dyc.pro.base.core.dao.SysSerialInstanceMapper;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEnCodeSerialInstanceInsertService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEnCodeSerialInstanceInsertReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEnCodeSerialInstanceInsertRspBO;
import com.tydic.dyc.pro.base.core.po.SysSerialInstancePO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 描述：DycProEnCodeSerialInstanceInsertServiceImpl
 *
 * @author luoyou
 * @date 2025/10/20 17:22
 */

@HTServiceImpl
public class DycProEnCodeSerialInstanceInsertServiceImpl implements DycProEnCodeSerialInstanceInsertService {

	@Autowired
	private SysSerialInstanceMapper sysSerialInstanceMapper;

	@Override
	public DycProEnCodeSerialInstanceInsertRspBO insertSerialInstance(DycProEnCodeSerialInstanceInsertReqBO reqBO) {

		if(!CollectionUtils.isEmpty(reqBO.getInstanceList())){
			List<SysSerialInstancePO> sysSerialInstancePOList = JSON.parseArray(JSON.toJSONString(reqBO.getInstanceList()), SysSerialInstancePO.class);
			sysSerialInstanceMapper.insertBatch(sysSerialInstancePOList);
		}
		DycProEnCodeSerialInstanceInsertRspBO rspBO = new DycProEnCodeSerialInstanceInsertRspBO();

		return rspBO;
	}
}
