package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author yuhao
 * @Date 2025/6/3 13:00
 * @Description:标准商品 es index mapping 对象
 **/
@Data
public class DycProEsindexMappingUpcBO implements Serializable {

    private static final long serialVersionUID = -7564762111790481311L;
    /**
     * 标准商品id
     */
    private Long upcId;
    /**
     * 标准商品编码
     */
    private String upcCode;
    /**
     * 标准商品名称
     */
    private String upcName;
    /**
     * 外部标准商品id
     */
    private String extUpcId;
    /**
     * 品牌id
     */
    private Long brandId;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 参照价格
     */
    private BigDecimal referencePrice;
    /**
     * 属性模版id
     */
    private Long propertyTemplateId;
    /**
     * 管理目录路径
     */
    private String manageCatalogPath;
    /**
     * 管理目录路径翻译
     */
    private String manageCatalogPathName;
    /**
     * 物料编码
     */
    private String materialCode;
    /**
     * 物料名称
     */
    private String materialName;
    /**
     * 物料长描述
     */
    private String materialLongDesc;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 标准商品来源：
     * 1：自建
     * 2：外部同步
     */
    private Integer upcSource;
    /**
     * 赋码状态
     */
    private Integer mStatus;
    /**
     * 类型（MRO  办公用品）
     */
    private Integer upcType;
    /**
     * 计量单位id
     */
    private Long measureId;
    /**
     * 计量单位名称
     */
    private String measureName;
    /**
     * 商品数量
     */
    private Integer skuNum;
    /**
     * 属性实例
     */
    private String propertyInstInfo;
    /**
     * 供应商id集合
     */
    private List<Long> supplierIdList;
    /**
     * 后台类目id集合
     */
    private List<Long> manageCatalogIdList;
    /**
     * 商品信息集合
     */
    private List<DycProEsIndexMappingSkuInUpcBO> skuList;
}
