package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 标题：DycProEsIndexMappingSaleOrderItemBO
 * 描述：销售单明细索引映射
 */
@Data
public class DycProEsIndexMappingSaleOrderItemBO implements Serializable {

    private static final long serialVersionUID = 3876454505683353676L;

    /**
     * 销售明细id
     */
    private Long saleOrderItemId;

    /**
     * 单品ID
     */
    private String skuId;

    /**
     * 单品编码
     */
    private String skuCode;

    /**
     * 单品名称
     */
    private String skuName;

    /**
     * 供应商ID
     */
    private String supplierId;

    /**
     * 销售金额
     */
    private BigDecimal salePrice;

    /**
     * 采购金额
     */
    private BigDecimal purchasePrice;

    /**
     * 采购数量
     */
    private BigDecimal purchaseCount;

    /**
     * 销售金额
     */
    private BigDecimal saleFee;

    /**
     * 采购金额
     */
    private BigDecimal purchaseFee;

    /**
     * sku物料编码
     */
    private String skuMaterialCode;

    /**
     * sku物料名称
     */
    private String skuMaterialName;

    /**
     * 规格
     */
    private String spec;

    /**
     * 型号
     */
    private String model;

    /**
     * 计量单位位数
     */
    private String unitDigit;

    /**
     * 售后在途数量
     */
    private BigDecimal afterServingCount;

    /**
     * sku外部单品id
     */
    private String skuExtSkuId;

    /**
     * sku单品主图url
     */
    private String skuMainPicUrl;
    /**
     * 价格指数
     */
    private BigDecimal referencePrice;
    /**
     * 价格指数比例
     */
    private BigDecimal referencePriceRate;
    /**
     * 验收数量
     */
    private BigDecimal acceptanceCount;
    /**
     * 验收销售金额
     */
    private BigDecimal inspSaleFee;

    /**
     * 验收采购金额
     */
    private BigDecimal inspPurchaseFee;
    /**
     * M码
     */
    private String mCode;
    /**
     * M名称
     */
    private String mName;
    /**
     * 专业公司物料组编码
     */
    private String majorCompanyCatalogCode;
    /**
     * 标准商品编码
     */
    private String upcCode;
    /**
     * 协议id
     */
    private String agreementId;
    /**
     * 协议名称
     */
    private String agreementName;
    /**
     * 税率
     */
    private BigDecimal tax;
    /**
     * 税务编码
     */
    private String taxId;
    /**
     * 计量单位
     */
    private String unitName;
    /**
     * 协议来源描述
     */
    private String agreementSourceDesc;
}
