package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @description 删除标识 删除标识 1已删除 0未删除
 * @author Luokan
 * @date 2025/04/23
 **/

public enum DelFlag implements DictionaryEnum{
    /**
     * 0未删除
     */
    UN_DELETE("DEL_FLAG", "0","未删除", "删除标识"),
    /**
     * 1已删除
     */
    DELETED("DEL_FLAG", "1","已删除", "删除标识");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DelFlag(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
