package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 调价机制 枚举
 *
 * @author lihulin
 */

public enum DmcAgrMainAdjustPriceType implements DictionaryEnum {
    W("DMC_AGR_MAIN_ADJUST_PRICE_TYPE", "0", "无", "调价机制"),
    XYGJ("DMC_AGR_MAIN_ADJUST_PRICE_TYPE", "1", "协议改价", "调价机制"),
    DDGJ("DMC_AGR_MAIN_ADJUST_PRICE_TYPE", "2", "订单改价", "调价机制");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrMainAdjustPriceType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
