package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标准商品来源
 */
public enum DmcCommUpcSource implements DictionaryEnum{
    ONE("DMC_COMM_UPC_SOURCE", "1", "中标清单", "标准商品来源"),
    TWO("DMC_COMM_UPC_SOURCE", "2", "智能聚合", "标准商品来源"),
    THREE("DMC_COMM_UPC_SOURCE", "3", "数据继承", "标准商品来源"),
    FOUR("DMC_COMM_UPC_SOURCE", "4", "商城新建", "标准商品来源");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;
    DmcCommUpcSource(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    @Override
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    @Override
    public String getDictionaryName() {
        return dictionaryName;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
