package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 协议种类 枚举
 *
 * @author lihulin
 */

public enum DmcAgrMainAgrType implements DictionaryEnum {
    JCXY("DMC_AGR_MAIN_AGR_TYPE", "1", "品类折扣协议", "协议种类"),
    DSXY("DMC_AGR_MAIN_AGR_TYPE", "2", "固定价协议", "协议种类"),
    GCXY("DMC_AGR_MAIN_AGR_TYPE", "3", "公车采购协议", "协议种类"),
    SYSB("DMC_AGR_MAIN_AGR_TYPE", "4", "实验设备协议", "协议种类"),
    XCSB("DMC_AGR_MAIN_AGR_TYPE", "5", "信创设备协议", "协议种类");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrMainAgrType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
