package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：EgcAfOrderPickwareType
 * 描述：售后取货服务类型
 */
public enum EgcAfOrderPickwareType implements DictionaryEnum {

    PICK_UP_FROM_PATRON("PICKWARE_TYPE", "1", "上门取件", "售后取货服务类型"),
    SEND_BY_ONESELF("PICKWARE_TYPE", "2", "客户发货", "售后取货服务类型"),
    DELIVERY_BY_ONESELF("PICKWARE_TYPE", "3", "客户送货", "售后取货服务类型");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EgcAfOrderPickwareType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
