package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author yuhao
 * @Date 2025/5/20 10:41
 * @Description:
 **/
@Data
public class DycProBaseCallEsbUtilGetSkuDetailResultBO implements Serializable {

    private static final long serialVersionUID = -5117587522135586068L;
    /**
     * spu编号
     */
    private String spu;
    /**
     * 主图地址
     */
    private String imagePath;
    /**
     * 品牌
     */
    private String brandName;
    /**
     * 商品描述
     */
    private String introduction;
    /**
     * 包装内的数量及单位
     */
    private String wareNum;
    /**
     * 包装单位
     */
    private String ware;
    /**
     * 包装信息
     */
    private String wareQD;
    /**
     * spu名称
     */
    private String name;
    /**
     * 类目编码集合，按提供该SKU对应的所有类目信息，并按照照一二三四级顺序提供
     */
    private List<String> category;
    /**
     * 是否允许退换货货,
     * 0：允许退换货
     * 1：不允许退换货
     * 默认为0，不传默认按0处理
     */
    private Integer isReturn;
    /**
     * 规格属性信息
     */
    private List<DycProBaseCallEsbUtilSkuParamBO> param;
    /**
     * 税率
     */
    private Integer tax;
    /**
     * 产地
     */
    private String productArea;
    /**
     * 商品集合
     */
    private List<DycProBaseCallEsbUtilSkuInfoBO> skuGroup;
}
