package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author yuhao
 * @Date 2025/5/20 11:29
 * @Description:
 **/
@Data
public class DycProBaseCallEsbUtilSkuInfoBO implements Serializable {

    private static final long serialVersionUID = -6646605828902091602L;
    /**
     * 商品编号
     */
    private String sku;
    /**
     * 重量
     */
    private String weight;
    /**
     * 主图地址
     */
    private String imagePath;
    /**
     * 上下架状态
     * 1：上架
     * 0：下架
     */
    private Integer state;
    /**
     * 品牌
     */
    private String brandName;
    /**
     * 品牌图片
     */
    private String brandPic;
    /**
     * 商品名称
     */
    private String name;
    /**
     * 产地
     */
    private String productArea;
    /**
     * 条形码
     */
    private String upc;
    /**
     * 销售单位
     */
    private String saleUnit;
    /**
     * 销售结算单位是否一致
     * 1：一致 0：不一致 默认一致
     */
    private Integer type;
    /**
     * 结算单位
     */
    private String settleUnit;
    /**
     * 结算转换率
     */
    private String settleRate;
    /**
     * 分子
     */
    private String molecule;
    /**
     * 分母
     */
    private String denominator;
    /**
     * 最小起订量
     */
    private String moq;
    /**
     * 制造商型号
     */
    private String mfgSku;
    /**
     * 预计发货日
     */
    private String deliveryTime;
    /**
     * 是否允许退换货货
     */
    private String isReturn;
    /**
     * 商品描述，HTML页面，可直接展现
     */
    private String introduction;
    /**
     * 包装信息,包装描述信息，HTML页面，可直接展现
     */
    private String wareQD;
    /**
     * 包装内的数量及单位
     */
    private String wareNum;
    /**
     * 规格属性信息
     */
    private List<DycProBaseCallEsbUtilSkuParamBO> param;
    /**
     * 商品组信息
     */
    private String group;
    /**
     * 税率
     */
    private Integer tax;
    /**
     * 规格
     */
    private String spec;
    /**
     * 型号
     */
    private String model;
    /**
     * 所属协议编号
     */
    private String agrCode;
    /**
     * 商品短名称
     */
    private String shortName;
    /**
     * 京东自营商品编码
     */
    private String jdSku;
    /**
     * 自报京东折扣率
     */
    private String jdDiscountRate;
    /**
     * 三方同品链接
     */
    private String sameSkuUrl;
    /**
     * 上游供应商注册资本是否大于100w
     */
    private Integer upSupCapital;
}
