/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainTradeMode;
import com.tydic.dyc.pro.dmc.constant.DycProAgrConstants;
import com.tydic.dyc.pro.dmc.repository.agrchng.api.DycProAgrChngRepository;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrCommSkuPriceInfoHandleDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrItemListQryApiService;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrItemApiBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrItemListQryApiReqBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrItemListQryApiRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrItemListQryApiService"})
public class DycProAgrItemListQryApiServiceImpl
implements DycProAgrItemListQryApiService {
    @Autowired
    private DycProAgrRepository agrMainRepository;
    @Autowired
    private DycProAgrChngRepository agrChngRepository;

    @PostMapping(value={"qryAgrItemList"})
    public DycProAgrItemListQryApiRspBO qryAgrItemList(@RequestBody DycProAgrItemListQryApiReqBO reqBO) {
        DycProAgrItemListQryApiRspBO rspBO = new DycProAgrItemListQryApiRspBO();
        DycProAgrItemListQryDTO qryDTO = (DycProAgrItemListQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycProAgrItemListQryDTO.class);
        qryDTO.setHistoryFlag(Boolean.valueOf(false));
        List dycProAgrItemDTOS = null;
        if (reqBO.getPageFlag().booleanValue()) {
            RspPage rspPage = this.agrMainRepository.selectAgrItemListPage(qryDTO);
            dycProAgrItemDTOS = rspPage.getRows();
            rspBO.setTotal(rspPage.getTotal());
            rspBO.setRecordsTotal(rspPage.getRecordsTotal());
        } else {
            dycProAgrItemDTOS = this.agrMainRepository.selectAgrItemList(qryDTO);
        }
        if (!CollectionUtils.isEmpty((Collection)dycProAgrItemDTOS)) {
            DycProAgrMainDTO dycProAgrMainDTO = new DycProAgrMainDTO();
            if (reqBO.getAgrOrderQryFlag().booleanValue()) {
                DycProAgrListQryDTO agrListQryDTO = new DycProAgrListQryDTO();
                agrListQryDTO.setAgrObjPrimaryId(((DycProAgrItemDTO)dycProAgrItemDTOS.get(0)).getAgrObjPrimaryId());
                List agrMainList = this.agrMainRepository.selectAgrMainList(agrListQryDTO);
                dycProAgrMainDTO = (DycProAgrMainDTO)agrMainList.get(0);
            }
            rspBO.setRows(JSON.parseArray((String)JSON.toJSONString((Object)dycProAgrItemDTOS), DycProAgrItemApiBO.class));
            if (reqBO.getAgrOrderQryFlag().booleanValue()) {
                for (DycProAgrItemApiBO each : rspBO.getRows()) {
                    if (Integer.valueOf(DmcAgrMainTradeMode.MY.getCode()).equals(dycProAgrMainDTO.getTradeMode())) {
                        each.setSalePrice(this.computeSkuPrice(dycProAgrMainDTO.getSupplierId(), each));
                        continue;
                    }
                    each.setSalePrice(each.getSupplyPrice());
                }
            }
        }
        return rspBO;
    }

    private BigDecimal computeSkuPrice(Long supplierId, DycProAgrItemApiBO agrItemBO) {
        DycProAgrCommSkuPriceInfoHandleDTO handleDTO = new DycProAgrCommSkuPriceInfoHandleDTO();
        handleDTO.setSupplierPrice(agrItemBO.getSupplyPrice());
        handleDTO.setSupplierId(supplierId);
        handleDTO.setAgrId(agrItemBO.getAgrId());
        handleDTO.setManageCatalogId(agrItemBO.getManageCatalogId());
        handleDTO.setPriceRuleType(DycProAgrConstants.PriceRuleType.AGR);
        DycProAgrCommSkuPriceInfoDTO result = this.agrChngRepository.computeSkuAgrPrice(handleDTO);
        return result.getSalePrice();
    }
}

