/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agrchng.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.constant.DycProAgrConstants;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainQryDTO;
import com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrGetAgrChngTypeService;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngTypeBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrGetAgrChngTypeReqBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrGetAgrChngTypeRspBO;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrGetAgrChngTypeService"})
public class DycProAgrGetAgrChngTypeServiceImpl
implements DycProAgrGetAgrChngTypeService {
    @Autowired
    private DycProAgrRepository agrMainRepository;

    @Override
    @PostMapping(value={"getAgrChngType"})
    public DycProAgrGetAgrChngTypeRspBO getAgrChngType(@RequestBody DycProAgrGetAgrChngTypeReqBO reqBO) {
        DycProAgrGetAgrChngTypeRspBO rspBO = new DycProAgrGetAgrChngTypeRspBO();
        this.validateParam(reqBO);
        DycProAgrMainQryDTO qryDTO = new DycProAgrMainQryDTO();
        qryDTO.setAgrObjPrimaryId(reqBO.getAgrObjPrimaryId());
        qryDTO.setAgrId(reqBO.getAgrId());
        qryDTO.setQryManageCatalogFlag(Boolean.valueOf(true));
        qryDTO.setQryScopeFlag(Boolean.valueOf(true));
        DycProAgrMainDTO agrDetail = this.agrMainRepository.getAgrDetail(qryDTO);
        if (null == agrDetail) {
            throw new ZTBusinessException("\u534f\u8bae\u4e0d\u5b58\u5728\uff01");
        }
        String[] chngType = new String[]{};
        if (DycProAgrConstants.AgrStatus.ACTIVE.equals(agrDetail.getAgrStatus())) {
            chngType = DycProAgrConstants.AgrAdjustPriceType.AGR_ADJUST_PRICE.equals(agrDetail.getAdjustPriceType()) ? (agrDetail.getWhetherHaveItem().equals(DycProAgrConstants.AgrBooleanFlag.YES) ? new String[]{"1->\u6682\u505c", "3->\u7ec8\u6b62", "4->\u8c03\u4ef7", "5->\u5ef6\u671f", "6->\u8865\u5145", "7->\u5176\u4ed6\u53d8\u66f4"} : new String[]{"1->\u6682\u505c", "3->\u7ec8\u6b62", "5->\u5ef6\u671f", "7->\u5176\u4ed6\u53d8\u66f4"}) : (agrDetail.getWhetherHaveItem().equals(DycProAgrConstants.AgrBooleanFlag.YES) ? new String[]{"1->\u6682\u505c", "3->\u7ec8\u6b62", "5->\u5ef6\u671f", "6->\u8865\u5145", "7->\u5176\u4ed6\u53d8\u66f4"} : new String[]{"1->\u6682\u505c", "3->\u7ec8\u6b62", "5->\u5ef6\u671f", "7->\u5176\u4ed6\u53d8\u66f4"});
        }
        if (DycProAgrConstants.AgrStatus.SUSPENDED.equals(agrDetail.getAgrStatus())) {
            chngType = agrDetail.getWhetherHaveItem().equals(DycProAgrConstants.AgrBooleanFlag.YES) ? new String[]{"2->\u542f\u7528", "3->\u7ec8\u6b62", "5->\u5ef6\u671f", "6->\u8865\u5145", "7->\u5176\u4ed6\u53d8\u66f4"} : new String[]{"2->\u542f\u7528", "3->\u7ec8\u6b62", "5->\u5ef6\u671f", "7->\u5176\u4ed6\u53d8\u66f4"};
        }
        if (DycProAgrConstants.AgrStatus.EXPIRED.equals(agrDetail.getAgrStatus())) {
            chngType = new String[]{"3->\u7ec8\u6b62", "5->\u5ef6\u671f"};
        }
        ArrayList<DycProAgrChngTypeBO> data = new ArrayList<DycProAgrChngTypeBO>();
        for (String type : chngType) {
            String[] temp = type.split("->");
            DycProAgrChngTypeBO bo = new DycProAgrChngTypeBO();
            bo.setCode(temp[0]);
            bo.setTitle(temp[1]);
            data.add(bo);
        }
        rspBO.setData(data);
        return rspBO;
    }

    private void validateParam(DycProAgrGetAgrChngTypeReqBO reqBO) {
        if (null == reqBO.getAgrObjPrimaryId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010agrObjPrimaryId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

