/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agrchng.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrItemChngOperRecorAgrItemChngType;
import com.tydic.dyc.pro.dmc.repository.agrchng.api.DycProAgrChngRepository;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrChngMainDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrChngQryDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrItemChngDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrItemChngOperRecorDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainQryDTO;
import com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrItemChngOperSaveService;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrItemChngOperSaveReqBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrItemChngOperSaveRspBO;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrItemChngOperSaveService"})
public class DycProAgrItemChngOperSaveServiceImpl
implements DycProAgrItemChngOperSaveService {
    private static final Logger log = LoggerFactory.getLogger(DycProAgrItemChngOperSaveServiceImpl.class);
    @Autowired
    private DycProAgrRepository agrMainRepository;
    @Autowired
    private DycProAgrChngRepository agrChngRepository;

    @Override
    @PostMapping(value={"saveAgrItemChngOper"})
    public DycProAgrItemChngOperSaveRspBO saveAgrItemChngOper(@RequestBody DycProAgrItemChngOperSaveReqBO reqBO) {
        this.validateParam(reqBO);
        DycProAgrItemChngOperSaveRspBO rspBO = new DycProAgrItemChngOperSaveRspBO();
        DycProAgrMainQryDTO qryAgrDTO = new DycProAgrMainQryDTO();
        qryAgrDTO.setAgrObjPrimaryId(reqBO.getAgrObjPrimaryId());
        qryAgrDTO.setQryScopeFlag(Boolean.valueOf(false));
        qryAgrDTO.setQryManageCatalogFlag(Boolean.valueOf(false));
        DycProAgrMainDTO agrDetail = this.agrMainRepository.getAgrDetail(qryAgrDTO);
        if (!CollectionUtils.isEmpty(reqBO.getAgrItemChngOperRecorBOList())) {
            DycProAgrChngMainDTO dycProAgrChngMainDTO = new DycProAgrChngMainDTO();
            dycProAgrChngMainDTO.setChngApplyId(reqBO.getChngApplyId());
            dycProAgrChngMainDTO.setAgrId(agrDetail.getAgrId());
            dycProAgrChngMainDTO.setAgrItemChngOperRecorBOList(JSON.parseArray((String)JSON.toJSONString(reqBO.getAgrItemChngOperRecorBOList()), DycProAgrItemChngOperRecorDTO.class));
            this.agrChngRepository.saveAgrItemChngOper(dycProAgrChngMainDTO);
        }
        this.validateAgrItemChngOperList(reqBO, rspBO);
        this.handleSupplementAgrItemChngResult(reqBO, agrDetail);
        return rspBO;
    }

    private void validateParam(DycProAgrItemChngOperSaveReqBO reqBO) {
        if (null == reqBO.getChngApplyId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010chngApplyId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getSubmitFlag()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010submitFlag\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public void handleSupplementAgrItemChngResult(DycProAgrItemChngOperSaveReqBO reqBO, DycProAgrMainDTO agrDetail) {
        if (null != agrDetail) {
            DycProAgrItemListQryDTO dycProAgrItemDTO = new DycProAgrItemListQryDTO();
            dycProAgrItemDTO.setAgrObjPrimaryId(agrDetail.getAgrObjPrimaryId());
            List agrItemList = this.agrMainRepository.selectAgrItemList(dycProAgrItemDTO);
            log.debug("\u539f\u534f\u8bae\u660e\u7ec6\u96c6\u5408\uff1a{}", (Object)JSON.toJSONString((Object)agrItemList));
            List agrItemChngResultList = JSON.parseArray((String)JSON.toJSONString((Object)agrItemList), DycProAgrItemChngDTO.class);
            DycProAgrChngQryDTO qryItemChngOperRecorDTO = (DycProAgrChngQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProAgrChngQryDTO.class);
            qryItemChngOperRecorDTO.setChngApplyId(reqBO.getChngApplyId());
            qryItemChngOperRecorDTO.setPageNo(Integer.valueOf(1));
            qryItemChngOperRecorDTO.setPageSize(Integer.valueOf(10000));
            RspPage agrItemChngOperRecorListPage = this.agrChngRepository.getAgrItemChngOperRecorListPage(qryItemChngOperRecorDTO);
            log.debug("\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u8bb0\u5f55\u96c6\u5408\uff1a{}", (Object)JSON.toJSONString((Object)agrItemChngOperRecorListPage));
            if (!CollectionUtils.isEmpty((Collection)agrItemChngOperRecorListPage.getRows())) {
                List changeRecordList = agrItemChngOperRecorListPage.getRows();
                agrItemChngResultList.removeIf(item -> changeRecordList.stream().filter(record -> record.getAgrItemChngType() == Integer.parseInt(DmcAgrItemChngOperRecorAgrItemChngType.REDUCE.getCode())).filter(record -> record.getAgrItemId() != null).anyMatch(record -> record.getAgrItemId().equals(item.getAgrItemId())));
                changeRecordList.stream().filter(record -> record.getAgrItemChngType() == Integer.parseInt(DmcAgrItemChngOperRecorAgrItemChngType.ADD.getCode())).forEach(record -> {
                    DycProAgrItemChngDTO dto = new DycProAgrItemChngDTO();
                    BeanUtils.copyProperties((Object)record, (Object)dto);
                    dto.setAgrItemId(Long.valueOf(Sequence.getInstance().nextId()));
                    agrItemChngResultList.add(dto);
                    log.debug("\u65b0\u589e\u660e\u7ec6\u9879: {}", (Object)JSON.toJSONString((Object)dto));
                });
                log.debug("\u53d8\u66f4\u540e\u7684\u660e\u7ec6\u7ed3\u679c\u96c6\uff1a{}", (Object)JSON.toJSONString((Object)agrItemChngResultList));
                DycProAgrChngMainDTO dycProAgrChngMainDTO = new DycProAgrChngMainDTO();
                dycProAgrChngMainDTO.setAgrObjPrimaryId(agrDetail.getAgrObjPrimaryId());
                dycProAgrChngMainDTO.setChngApplyId(reqBO.getChngApplyId());
                dycProAgrChngMainDTO.setAgrId(agrDetail.getAgrId());
                dycProAgrChngMainDTO.setAgrItemChngBOList(JSON.parseArray((String)JSON.toJSONString((Object)agrItemChngResultList), DycProAgrItemChngDTO.class));
                this.agrChngRepository.handleSupplementAgrItemChngResult(dycProAgrChngMainDTO);
            }
        }
    }

    private void validateAgrItemChngOperList(DycProAgrItemChngOperSaveReqBO reqBO, DycProAgrItemChngOperSaveRspBO rspBO) {
        boolean chngItemValidateFlag = true;
        if (reqBO.getSubmitFlag() == 1) {
            DycProAgrChngQryDTO qryDTO = new DycProAgrChngQryDTO();
            qryDTO.setChngApplyId(reqBO.getChngApplyId());
            qryDTO.setPageNo(Integer.valueOf(1));
            qryDTO.setPageSize(Integer.valueOf(1));
            RspPage agrItemChngListPage = this.agrChngRepository.getAgrItemChngOperRecorListPage(qryDTO);
            int total = agrItemChngListPage.getRecordsTotal() / 1000 + 1;
            block0: for (int i = 1; i <= total; ++i) {
                DycProAgrChngQryDTO qry = new DycProAgrChngQryDTO();
                qry.setChngApplyId(reqBO.getChngApplyId());
                qry.setPageNo(Integer.valueOf(i));
                qry.setPageSize(Integer.valueOf(1000));
                RspPage agrItemChngOperList = this.agrChngRepository.getAgrItemChngOperRecorListPage(qry);
                if (CollectionUtils.isEmpty((Collection)agrItemChngOperList.getRows())) continue;
                for (DycProAgrItemChngOperRecorDTO row : agrItemChngOperList.getRows()) {
                    if (StringUtils.isEmpty((String)row.getBrandName())) {
                        chngItemValidateFlag = false;
                        rspBO.setChngItemValidateFlag(chngItemValidateFlag);
                        continue block0;
                    }
                    if (null == row.getSupplyCycle()) {
                        chngItemValidateFlag = false;
                        rspBO.setChngItemValidateFlag(chngItemValidateFlag);
                        continue block0;
                    }
                    if (null == row.getSupplyPrice()) {
                        chngItemValidateFlag = false;
                        rspBO.setChngItemValidateFlag(chngItemValidateFlag);
                        continue block0;
                    }
                    if (null != row.getTaxRate()) continue;
                    chngItemValidateFlag = false;
                    rspBO.setChngItemValidateFlag(chngItemValidateFlag);
                    continue block0;
                }
            }
        }
    }
}

