/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrSrc;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrStatus;
import com.tydic.dyc.pro.dmc.constant.DycProAgrConstants;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainQryDTO;
import com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrCopyService;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrCopyReqBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrCopyRspBO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrCopyService"})
public class DycProAgrCopyServiceImpl
implements DycProAgrCopyService {
    @Autowired
    private DycProAgrRepository agrMainRepository;

    @Override
    @PostMapping(value={"copyAgr"})
    public DycProAgrCopyRspBO copyAgr(@RequestBody DycProAgrCopyReqBO reqBO) {
        this.judge(reqBO);
        DycProAgrMainDTO oldAgrDetail = this.getAgrDetail(reqBO.getAgrObjPrimaryId());
        oldAgrDetail.setPurScopeList(null);
        oldAgrDetail.setViewScopeList(null);
        DycProAgrMainDTO createdAgrDetail = this.createAgrMain(oldAgrDetail, reqBO);
        this.copyItem(oldAgrDetail, createdAgrDetail);
        DycProAgrCopyRspBO rspBO = (DycProAgrCopyRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)createdAgrDetail), DycProAgrCopyRspBO.class));
        return rspBO;
    }

    private DycProAgrMainDTO getAgrDetail(Long agrObjPrimaryId) {
        DycProAgrMainQryDTO qryDTO = new DycProAgrMainQryDTO();
        qryDTO.setAgrObjPrimaryId(agrObjPrimaryId);
        return this.agrMainRepository.getAgrDetail(qryDTO);
    }

    private void copyItem(DycProAgrMainDTO oldAgrDetail, DycProAgrMainDTO createdAgrDetail) {
        if (DycProAgrConstants.AgrBooleanFlag.YES.equals(oldAgrDetail.getWhetherHaveItem())) {
            DycProAgrItemListQryDTO dycProAgrItemDTO = new DycProAgrItemListQryDTO();
            dycProAgrItemDTO.setAgrObjPrimaryId(oldAgrDetail.getAgrObjPrimaryId());
            List agrItemList = this.agrMainRepository.selectAgrItemList(dycProAgrItemDTO);
            if (!CollectionUtils.isEmpty((Collection)agrItemList)) {
                agrItemList.forEach(each -> {
                    each.setAgrItemId(null);
                    each.setAgrItemPrimaryId(null);
                    each.setAgrObjPrimaryId(createdAgrDetail.getAgrObjPrimaryId());
                    each.setAgrId(createdAgrDetail.getAgrId());
                });
                this.agrMainRepository.saveAgrItems(agrItemList);
            }
        }
    }

    private DycProAgrMainDTO createAgrMain(DycProAgrMainDTO agrDetail, DycProAgrCopyReqBO reqBO) {
        if (agrDetail == null) {
            throw new ZTBusinessException("\u534f\u8bae\u8be6\u60c5\u67e5\u8be2\u4e3a\u7a7a");
        }
        DycProAgrMainDTO createDTO = (DycProAgrMainDTO)JSON.parseObject((String)JSON.toJSONString((Object)agrDetail), DycProAgrMainDTO.class);
        createDTO.setAgrCode(null);
        createDTO.setAgrVersion(null);
        createDTO.setAgrStatus(null);
        createDTO.setAgrVersionFormWay(null);
        createDTO.setDelFlag(null);
        createDTO.setChngApplyId(null);
        createDTO.setChngApplyNo(null);
        createDTO.setChngApplyTime(null);
        createDTO.setAgrSrc(Integer.valueOf(Integer.parseInt(DmcAgrMainAgrSrc.SDCJ.getCode())));
        createDTO.setAgrStatus(Integer.valueOf(Integer.parseInt(DmcAgrMainAgrStatus.DRAFT.getCode())));
        createDTO.setCreateUserId(reqBO.getUserId());
        createDTO.setCreateUserName(reqBO.getName());
        createDTO.setCreateUserAccount(reqBO.getUserName());
        createDTO.setCreateCompanyId(reqBO.getCompanyId());
        createDTO.setCreateOrgId(reqBO.getOrgId());
        createDTO.setCreateOrgPath(reqBO.getOrgPath());
        createDTO.setCreateCompanyName(reqBO.getCompanyName());
        createDTO.setCreateOrgName(reqBO.getOrgName());
        createDTO.setCreateTime(new Date(System.currentTimeMillis()));
        createDTO.setUpdateUserId(null);
        createDTO.setUpdateUserName(null);
        createDTO.setUpdateUserAccount(null);
        createDTO.setUpdateCompanyId(null);
        createDTO.setUpdateOrgId(null);
        createDTO.setUpdateOrgPath(null);
        createDTO.setUpdateCompanyName(null);
        createDTO.setUpdateOrgName(null);
        createDTO.setUpdateTime(null);
        return this.agrMainRepository.createAgrMain(createDTO);
    }

    private void judge(DycProAgrCopyReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrObjPrimaryId())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u5bf9\u8c61\u552f\u4e00ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

