/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.skumanage.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.pro.base.bo.DycProBaseManagePageRspBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingBansRuleBO;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDetailsInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuQryDTO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommSkuListPageQryEsApiService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuDetailsInfoApiBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuListPageQryEsApiBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuListPageQryEsApiReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuListPageQryEsApiRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommSkuListPageQryEsApiService"})
public class DycProCommSkuListPageQryEsApiServiceImpl
implements DycProCommSkuListPageQryEsApiService {
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;

    @PostMapping(value={"qryEsSkuListPage"})
    public DycProCommSkuListPageQryEsApiRspBO qryEsSkuListPage(@RequestBody DycProCommSkuListPageQryEsApiReqBO reqBO) {
        DycProCommSkuQryDTO reqDto = (DycProCommSkuQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycProCommSkuQryDTO.class);
        DycProBaseManagePageRspBO baseManagePageRspBO = this.dycProCommSkuRepository.qryEsSkuListPage(reqDto);
        DycProCommSkuListPageQryEsApiRspBO dycProCommSkuListPageQryEsRspBO = (DycProCommSkuListPageQryEsApiRspBO)JSON.parseObject((String)JSON.toJSONString((Object)baseManagePageRspBO), DycProCommSkuListPageQryEsApiRspBO.class);
        if (!CollectionUtils.isEmpty((Collection)dycProCommSkuListPageQryEsRspBO.getRows())) {
            Map<Object, Object> skuDetailMap = new HashMap();
            DycProCommSkuQryDTO dycProCommSkuQryDTO = new DycProCommSkuQryDTO();
            dycProCommSkuQryDTO.setSkuIds(dycProCommSkuListPageQryEsRspBO.getRows().stream().map(DycProCommSkuListPageQryEsApiBO::getSkuId).collect(Collectors.toList()));
            List detailList = this.dycProCommSkuRepository.getDetailList(dycProCommSkuQryDTO);
            if (!CollectionUtils.isEmpty((Collection)detailList)) {
                skuDetailMap = detailList.stream().collect(Collectors.toMap(DycProCommSkuDetailsInfoDTO::getSkuId, o -> o, (o1, o2) -> o1));
            }
            for (DycProCommSkuListPageQryEsApiBO bo : dycProCommSkuListPageQryEsRspBO.getRows()) {
                DycProCommSkuDetailsInfoDTO dycProCommSkuDetailsInfoDTO;
                if (null != bo.getPurchaseType()) {
                    bo.setPurchaseTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommManageCatalogInfoPurchaseType", (String)bo.getPurchaseType().toString()));
                }
                if (null != bo.getMaterialType()) {
                    bo.setMaterialTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommManageCatalogInfoMaterialType", (String)bo.getMaterialType().toString()));
                }
                if (null != bo.getSkuStatus()) {
                    bo.setSkuStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommSkuInfoSkuStatus", (String)bo.getSkuStatus().toString()));
                }
                if (null != bo.getApprovalStatus()) {
                    bo.setApprovalStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommSkuInfoApprovalStatus", (String)bo.getApprovalStatus().toString()));
                }
                if (null != bo.getExamineStatus()) {
                    bo.setExamineStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommSkuInfoExamineStatus", (String)bo.getExamineStatus().toString()));
                }
                if (DycProCommConstants.PriceRiseType.RATE.equals(bo.getPriceRiseType())) {
                    bo.setPriceRiseRate(bo.getPriceRiseRate());
                } else {
                    bo.setPriceRiseValue(bo.getPriceRiseRate());
                    bo.setPriceRiseRate(null);
                }
                if (!CollectionUtils.isEmpty((Collection)bo.getBansRuleList())) {
                    List<DycProEsIndexMappingBansRuleBO> usefulBansRuleList = bo.getBansRuleList().stream().filter(rule -> rule.getBansStartDate().before(new Date()) && rule.getBansEndDate().after(new Date())).collect(Collectors.toList());
                    bo.setBansRuleList(usefulBansRuleList);
                    if (!CollectionUtils.isEmpty(usefulBansRuleList)) {
                        StringJoiner bansReasonStr = new StringJoiner(",");
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        usefulBansRuleList.forEach(bansRule -> {
                            if (DycProCommConstants.BansType.BANS_RULE.equals(bansRule.getBansType())) {
                                bansReasonStr.add(bansRule.getBansReason() + " " + formatter.format(bansRule.getBansStartDate()) + "\uff5e" + formatter.format(bansRule.getBansEndDate()));
                            } else {
                                bansReasonStr.add(bansRule.getBansReason() + " " + formatter.format(bansRule.getBansStartDate()));
                            }
                        });
                        bo.setBansReason(bansReasonStr.toString());
                        bo.setBansFlag(DycProCommConstants.BansFlag.YES);
                        bo.setBansFlagStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommSkuInfoBansFlag", (String)bo.getBansFlag().toString()));
                    } else {
                        bo.setBansFlag(DycProCommConstants.BansFlag.NO);
                        bo.setBansFlagStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommSkuInfoBansFlag", (String)bo.getBansFlag().toString()));
                    }
                } else {
                    bo.setBansFlag(DycProCommConstants.BansFlag.NO);
                    bo.setBansFlagStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommSkuInfoBansFlag", (String)bo.getBansFlag().toString()));
                }
                if (skuDetailMap.containsKey(bo.getSkuId()) && null != (dycProCommSkuDetailsInfoDTO = (DycProCommSkuDetailsInfoDTO)skuDetailMap.get(bo.getSkuId()))) {
                    bo.setDetailInfo((DycProCommSkuDetailsInfoApiBO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommSkuDetailsInfoDTO), DycProCommSkuDetailsInfoApiBO.class));
                }
                if (null != bo.getSalePrice()) {
                    bo.setSalePrice(bo.getSalePrice().setScale(2, RoundingMode.DOWN));
                }
                if (null != bo.getSupplierPrice()) {
                    bo.setSupplierPrice(bo.getSupplierPrice().setScale(2, RoundingMode.DOWN));
                }
                if (null != bo.getMarketPrice()) {
                    bo.setMarketPrice(bo.getMarketPrice().setScale(2, RoundingMode.DOWN));
                }
                if (null != bo.getDiscountRate()) {
                    bo.setDiscountRate(bo.getDiscountRate().setScale(2, RoundingMode.DOWN));
                }
                if (null != bo.getGuidedPrice()) {
                    bo.setGuidedPrice(bo.getGuidedPrice().setScale(2, RoundingMode.DOWN));
                }
                if (null != bo.getThirdReferPrice()) {
                    bo.setThirdReferPrice(bo.getThirdReferPrice().setScale(2, RoundingMode.DOWN));
                }
                if (null == bo.getUpcInfo()) continue;
                bo.setUpcCode(bo.getUpcInfo().getUpcCode());
                bo.setUpcName(bo.getUpcInfo().getUpcName());
                bo.setMCode(bo.getUpcInfo().getMCode());
                bo.setMName(bo.getUpcInfo().getMName());
                if (bo.getUpcInfo().getReferencePrice() == null || bo.getUpcInfo().getReferencePrice().compareTo(new BigDecimal(0)) == 0) continue;
                BigDecimal referencePrice = bo.getUpcInfo().getReferencePrice();
                BigDecimal salePrice = bo.getSalePrice();
                if (referencePrice == null || salePrice == null) continue;
                BigDecimal differencePrice = salePrice.subtract(referencePrice);
                BigDecimal differencePriceRate = differencePrice.divide(referencePrice, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
                bo.setDifferencePrice(differencePrice);
                bo.setReferencePrice(referencePrice);
                bo.setReferencePriceRate(differencePriceRate);
                bo.setReferencePriceRateExport(differencePrice + "(" + differencePriceRate.toString().replace("-", "") + "%)");
            }
            dycProCommSkuListPageQryEsRspBO.setSalePriceRange("\u00a5" + dycProCommSkuListPageQryEsRspBO.getRows().stream().map(DycProCommSkuListPageQryEsApiBO::getSalePrice).filter(Objects::nonNull).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO) + "\uff5e" + dycProCommSkuListPageQryEsRspBO.getRows().stream().map(DycProCommSkuListPageQryEsApiBO::getSalePrice).filter(Objects::nonNull).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO));
            dycProCommSkuListPageQryEsRspBO.setSupplierPriceRange("\u00a5" + dycProCommSkuListPageQryEsRspBO.getRows().stream().map(DycProCommSkuListPageQryEsApiBO::getSupplierPrice).filter(Objects::nonNull).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO) + "\uff5e" + dycProCommSkuListPageQryEsRspBO.getRows().stream().map(DycProCommSkuListPageQryEsApiBO::getSupplierPrice).filter(Objects::nonNull).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO));
        }
        return dycProCommSkuListPageQryEsRspBO;
    }
}

