/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.mcode.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.constant.DycProCommApiConstant;
import com.tydic.dyc.pro.dmc.repository.mcode.api.DycProCommMcodeRepository;
import com.tydic.dyc.pro.dmc.repository.mcode.dto.DycProCommMCodingLogInfoDTO;
import com.tydic.dyc.pro.dmc.repository.mcode.dto.DycProCommMcodeUnitSkuUnitMapDTO;
import com.tydic.dyc.pro.dmc.repository.mcode.dto.DycProCommMdmMaterielInfoDTO;
import com.tydic.dyc.pro.dmc.repository.mroManageCatalogMapping.api.DycProCommMroManageCatalogMappingRepository;
import com.tydic.dyc.pro.dmc.repository.mroManageCatalogMapping.dto.DycProCommMroManageCategoryMappingItemDTO;
import com.tydic.dyc.pro.dmc.service.mcode.api.DycProCommCreateMcodeApiService;
import com.tydic.dyc.pro.dmc.service.mcode.bo.DycProCommCreateMcodeApiReqBO;
import com.tydic.dyc.pro.dmc.service.mcode.bo.DycProCommCreateMcodeApiRspBO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.mcode.api.DycProCommCreateMcodeApiService"})
public class DycProCommCreateMcodeApiServiceImpl
implements DycProCommCreateMcodeApiService {
    @Value(value="${mdm.sysId}")
    private String mdmSysId;
    @Autowired
    private DycProCommMcodeRepository dycProCommMcodeRepository;
    @Autowired
    private DycProCommMroManageCatalogMappingRepository dycProCommMroManageCatalogMappingRepository;

    @PostMapping(value={"createMcode"})
    public DycProCommCreateMcodeApiRspBO createMcode(@RequestBody DycProCommCreateMcodeApiReqBO reqBO) {
        this.verifyParam(reqBO);
        if ("1".equals(reqBO.getProCompanyType()) || "2".equals(reqBO.getProCompanyType())) {
            String mName = this.getMName(reqBO);
            DycProCommMdmMaterielInfoDTO queryMcodeDto = new DycProCommMdmMaterielInfoDTO();
            queryMcodeDto.setMName(mName);
            DycProCommMdmMaterielInfoDTO mCodeInfoDto = this.dycProCommMcodeRepository.queryMcodeByCondition(queryMcodeDto);
            if (null == mCodeInfoDto) {
                DycProCommMdmMaterielInfoDTO createMcodeDto = new DycProCommMdmMaterielInfoDTO();
                createMcodeDto.setMName(mName);
                createMcodeDto.setLanguage("ZH");
                createMcodeDto.setSysId(this.mdmSysId);
                createMcodeDto.setMInd("T");
                createMcodeDto.setMType("Z004");
                createMcodeDto.setMGroup("97010101");
                createMcodeDto.setUnit(this.transferUnit(reqBO.getUnit()));
                createMcodeDto.setProdGroup("10");
                createMcodeDto.setCreateProCompanyCode(DictionaryFrameworkUtils.getDicDataByCode((String)"ZLDmcProCompanyCode", (String)reqBO.getProCompanyType()));
                createMcodeDto.setCreateProCompanyName(DictionaryFrameworkUtils.getDicDataByCode((String)"ZLDmcProCompanyName", (String)reqBO.getProCompanyType()));
                createMcodeDto.setProdareaCountry(reqBO.getProdareaCountry());
                createMcodeDto.setManageCatalogId(reqBO.getManageCatalogId());
                createMcodeDto.setManageCatalogPath(reqBO.getManageCatalogPath());
                createMcodeDto.setManageCatalogPathName(reqBO.getManageCatalogPathName());
                createMcodeDto.setApplicant("E\u91c7\u5546\u57ce2.0");
                createMcodeDto.setCreateUserId(reqBO.getUserId());
                createMcodeDto.setCreateUserName(reqBO.getName());
                createMcodeDto.setCreateOrgId(reqBO.getOrgId());
                createMcodeDto.setCreateOrgName(reqBO.getOrgName());
                createMcodeDto.setCreateOrgPath(reqBO.getOrgPath());
                createMcodeDto.setCreateCompanyId(reqBO.getCompanyId());
                createMcodeDto.setCreateCompanyName(reqBO.getCompanyName());
                DycProCommMdmMaterielInfoDTO mCodeCreateResultDto = this.dycProCommMcodeRepository.createMcode(createMcodeDto);
                DycProCommCreateMcodeApiRspBO rspBO = new DycProCommCreateMcodeApiRspBO();
                rspBO.setMId(mCodeCreateResultDto.getMId());
                rspBO.setMCode(mCodeCreateResultDto.getMCode());
                rspBO.setMName(mCodeCreateResultDto.getMName());
                this.createCodingRecord(mCodeCreateResultDto, reqBO);
                return rspBO;
            }
            throw new ZTBusinessException("\u8be5\u540d\u79f0\u7269\u6599\u5df2\u5b58\u5728\uff1a" + mName);
        }
        throw new ZTBusinessException("\u8be5\u4e13\u4e1a\u516c\u53f8\u6682\u4e0d\u652f\u6301\u7533\u8bf7\u8d4b\u7801");
    }

    private void createCodingRecord(DycProCommMdmMaterielInfoDTO dto, DycProCommCreateMcodeApiReqBO reqBO) {
        DycProCommMCodingLogInfoDTO queryMCodingLogInfoDto = new DycProCommMCodingLogInfoDTO();
        queryMCodingLogInfoDto.setMId(dto.getMId());
        queryMCodingLogInfoDto.setProfessionalCompanyType(reqBO.getProCompanyType());
        DycProCommMCodingLogInfoDTO mCodingLogInfoDto = this.dycProCommMcodeRepository.queryMcodeCodingLogByCondition(queryMCodingLogInfoDto);
        if (null == mCodingLogInfoDto) {
            DycProCommMroManageCategoryMappingItemDTO queryMappingItemDto = new DycProCommMroManageCategoryMappingItemDTO();
            queryMappingItemDto.setProfessionalCompanyType(reqBO.getProCompanyType());
            queryMappingItemDto.setManageCatalogId(dto.getManageCatalogId());
            DycProCommMroManageCategoryMappingItemDTO mappingItemDTO = this.dycProCommMroManageCatalogMappingRepository.qryMroManageCategoryMappingItemByCondition(queryMappingItemDto);
            if (null != mappingItemDTO) {
                DycProCommMCodingLogInfoDTO addMCodingLogInfoDto = new DycProCommMCodingLogInfoDTO();
                addMCodingLogInfoDto.setMId(dto.getMId());
                addMCodingLogInfoDto.setManageCatalogId(dto.getManageCatalogId());
                addMCodingLogInfoDto.setManageCatalogPath(mappingItemDTO.getManageCatalogPath());
                addMCodingLogInfoDto.setManageCatalogPathName(mappingItemDTO.getManageCatalogPathName());
                addMCodingLogInfoDto.setProfessionalCompanyType(reqBO.getProCompanyType());
                addMCodingLogInfoDto.setProfessionalCompanyName(DictionaryFrameworkUtils.getDicDataByCode((String)"ZLDmcProCompanyName", (String)reqBO.getProCompanyType()));
                addMCodingLogInfoDto.setProfessionalCompanyCatalogGroupCode(mappingItemDTO.getProfessionalCompanyCatalogGroupCode());
                addMCodingLogInfoDto.setProfessionalCompanyCatalogGroupName(mappingItemDTO.getProfessionalCompanyCatalogGroupName());
                addMCodingLogInfoDto.setMCode(dto.getMCode());
                addMCodingLogInfoDto.setMName(dto.getMName());
                addMCodingLogInfoDto.setSendStatus(DycProCommApiConstant.McodeSendStatus.SEND_PENDING);
                this.dycProCommMcodeRepository.createMcodeCodingLog(addMCodingLogInfoDto);
            } else {
                throw new ZTBusinessException("\u4e0b\u53d1M\u7801\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5546\u57ce\u7ba1\u7406\u76ee\u5f55\u4e0e\u4e13\u4e1a\u516c\u53f8\u7269\u6599\u7ec4\u6620\u5c04\u5173\u7cfb");
            }
        }
    }

    private String transferUnit(String skuUnit) {
        DycProCommMcodeUnitSkuUnitMapDTO queryMapDto = new DycProCommMcodeUnitSkuUnitMapDTO();
        queryMapDto.setSkuUnitName(skuUnit);
        DycProCommMcodeUnitSkuUnitMapDTO dycProCommMcodeUnitSkuUnitMapDTO = this.dycProCommMcodeRepository.queryMcodeSkuUnitMapByCondition(queryMapDto);
        if (null != dycProCommMcodeUnitSkuUnitMapDTO) {
            return dycProCommMcodeUnitSkuUnitMapDTO.getMCodeUnitCode();
        }
        throw new ZTBusinessException("\u672a\u627e\u5230\u5546\u54c1\u8ba1\u91cf\u5355\u4f4d\u4e0eMDM\u8ba1\u91cf\u5355\u4f4d\u6620\u5c04\u5173\u7cfb");
    }

    private String getMName(DycProCommCreateMcodeApiReqBO reqBO) {
        String mName = "";
        mName = mName + reqBO.getSkuShortName();
        mName = reqBO.getSpec().equals(reqBO.getModel()) ? mName + " " + reqBO.getSpec() : mName + " " + reqBO.getSpec() + " " + reqBO.getModel();
        return mName;
    }

    private void verifyParam(DycProCommCreateMcodeApiReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSkuShortName())) {
            throw new ZTBusinessException("\u5546\u54c1\u77ed\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSpec())) {
            throw new ZTBusinessException("\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getModel())) {
            throw new ZTBusinessException("\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getUnit())) {
            throw new ZTBusinessException("\u5546\u54c1\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getProCompanyType())) {
            throw new ZTBusinessException("\u4e13\u4e1a\u516c\u53f8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getManageCatalogId() == null) {
            throw new ZTBusinessException("\u7ba1\u7406\u76ee\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

