/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.checkrule.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleStatusEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.service.checkrule.api.DycProCommOperateCheckRuleInfoService;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommOperateCheckRuleInfoReqBO;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommOperateCheckRuleInfoRspBO;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.checkrule.api.DycProCommOperateCheckRuleInfoService"})
public class DycProCommOperateCheckRuleInfoServiceImpl
implements DycProCommOperateCheckRuleInfoService {
    @Autowired
    private DycProCommCheckRuleInfoRepository dycProCommCheckRuleInfoRepository;
    @Autowired
    DycProCommOperateRecordRepository dycProCommOperateRecordRepository;

    @Override
    @PostMapping(value={"operateCheckRuleInfo"})
    public DycProCommOperateCheckRuleInfoRspBO operateCheckRuleInfo(@RequestBody DycProCommOperateCheckRuleInfoReqBO reqBO) {
        this.validParam(reqBO);
        DycProCommCheckRuleInfoDTO updateDTO = new DycProCommCheckRuleInfoDTO();
        updateDTO.setCheckRuleId(reqBO.getCheckRuleId());
        updateDTO.setUpdateUserId(reqBO.getUserId());
        updateDTO.setUpdateUserName(reqBO.getName());
        updateDTO.setUpdateUserAccount(reqBO.getUserName());
        updateDTO.setUpdateOrgId(reqBO.getOrgId());
        updateDTO.setUpdateOrgName(reqBO.getOrgName());
        updateDTO.setUpdateCompanyId(reqBO.getCompanyId());
        updateDTO.setUpdateCompanyName(reqBO.getCompanyName());
        updateDTO.setUpdateOrgPath(reqBO.getOrgPath());
        updateDTO.setUpdateTime(new Date());
        DycProCommCheckRuleInfoQryDTO queryDTO = new DycProCommCheckRuleInfoQryDTO();
        queryDTO.setCheckRuleId(reqBO.getCheckRuleId());
        DycProCommCheckRuleInfoDTO detailDto = this.dycProCommCheckRuleInfoRepository.queryCheckRuleInfoDetail(queryDTO);
        if (detailDto == null) {
            throw new ZTBusinessException("\u89c4\u5219ID" + reqBO.getCheckRuleId() + "\u4e0d\u5b58\u5728!");
        }
        if ("disable".equals(reqBO.getOperateType())) {
            updateDTO.setCheckRuleStatus(Integer.valueOf(Integer.parseInt(DmcCommCheckRuleStatusEnum.DIS_ENABLE.getCode())));
            this.dycProCommCheckRuleInfoRepository.updateCheckRuleInfoStatus(updateDTO);
            this.addOperateRecord(reqBO, detailDto, DmcCommOperateRecordActionTypeEnum.DISABLE.getCode(), DmcCommOperateRecordActionTypeEnum.DISABLE.getValue());
        }
        if ("enable".equals(reqBO.getOperateType())) {
            updateDTO.setCheckRuleStatus(Integer.valueOf(Integer.parseInt(DmcCommCheckRuleStatusEnum.ENABLE.getCode())));
            this.dycProCommCheckRuleInfoRepository.updateCheckRuleInfoStatus(updateDTO);
            this.addOperateRecord(reqBO, detailDto, DmcCommOperateRecordActionTypeEnum.ENABLE.getCode(), DmcCommOperateRecordActionTypeEnum.ENABLE.getValue());
        }
        if ("delete".equals(reqBO.getOperateType())) {
            if (detailDto.getCheckRuleStatus().equals(Integer.parseInt(DmcCommCheckRuleStatusEnum.DRAFT.getCode()))) {
                this.dycProCommCheckRuleInfoRepository.deleteCheckRuleInfoByReal(updateDTO);
            } else {
                this.dycProCommCheckRuleInfoRepository.deleteCheckRuleInfo(updateDTO);
                this.addOperateRecord(reqBO, detailDto, DmcCommOperateRecordActionTypeEnum.DELETE.getCode(), DmcCommOperateRecordActionTypeEnum.DELETE.getValue());
            }
        }
        return new DycProCommOperateCheckRuleInfoRspBO();
    }

    private void addOperateRecord(DycProCommOperateCheckRuleInfoReqBO reqBO, DycProCommCheckRuleInfoDTO detailDtoo, String actionType, String actionName) {
        DycProCommOperateRecordDTO dycProCommOperateRecordDTO = new DycProCommOperateRecordDTO();
        dycProCommOperateRecordDTO.setOperateRecordId(Long.valueOf(Sequence.getInstance().nextId()));
        dycProCommOperateRecordDTO.setObjId(reqBO.getCheckRuleId());
        dycProCommOperateRecordDTO.setObjCode(detailDtoo.getCheckRuleCode());
        dycProCommOperateRecordDTO.setObjType(DycProCommConstants.OperateRecordObjType.CHECK_RULE);
        dycProCommOperateRecordDTO.setOperateUserId(reqBO.getUserId());
        dycProCommOperateRecordDTO.setOperateUserName(reqBO.getName());
        dycProCommOperateRecordDTO.setOperateUserAccount(reqBO.getUserName());
        dycProCommOperateRecordDTO.setOperateTime(new Date());
        dycProCommOperateRecordDTO.setActionName(actionName);
        dycProCommOperateRecordDTO.setActionType(Integer.valueOf(Integer.parseInt(actionType)));
        this.dycProCommOperateRecordRepository.addOperateRecord(dycProCommOperateRecordDTO);
    }

    private void validParam(DycProCommOperateCheckRuleInfoReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOperateType() == null) {
            throw new ZTBusinessException("\u64cd\u4f5c\u7c7b\u578b\u3010operateType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getCheckRuleId() == null) {
            throw new ZTBusinessException("\u89c4\u5219ID\u3010checkRuleId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

