/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.pricerule.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommPriceRuleSkuRangeTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommPriceRuleStatusEnum;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleChngRecordRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleChngRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleSkuRangeChngRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleSkuRangeInfoDTO;
import com.tydic.dyc.pro.dmc.service.pricerule.api.DycProCommAddPriceRuleInfoService;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommAddPriceRuleInfoReqBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommAddPriceRuleInfoRspBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommPriceRuleAgrBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommPriceRuleSupplierBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.pricerule.api.DycProCommAddPriceRuleInfoService"})
public class DycProCommAddPriceRuleInfoServiceImpl
implements DycProCommAddPriceRuleInfoService {
    @Autowired
    private DycProEncodeSerialService encodeSerialService;
    @Autowired
    private DycProCommPriceRuleInfoRepository dycProCommPriceRuleInfoRepository;
    @Autowired
    DycProCommOperateRecordRepository dycProCommOperateRecordRepository;
    @Autowired
    private DycProCommPriceRuleChngRecordRepository dycProCommPriceRuleChngRecordRepository;

    @Override
    @PostMapping(value={"addPriceRuleInfo"})
    public DycProCommAddPriceRuleInfoRspBO addPriceRuleInfo(@RequestBody DycProCommAddPriceRuleInfoReqBO reqBO) {
        this.validParam(reqBO);
        DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO = this.buildPriceRuleInfo(reqBO);
        List<DycProCommPriceRuleSkuRangeInfoDTO> priceRuleSkuRangeInfoDTOList = this.buildSkuRang(reqBO, dycProCommPriceRuleInfoDTO);
        dycProCommPriceRuleInfoDTO.setPriceRuleSkuRangeInfoDTOList(priceRuleSkuRangeInfoDTOList);
        this.dycProCommPriceRuleInfoRepository.addPriceRuleInfo(dycProCommPriceRuleInfoDTO);
        DycProCommPriceRuleChngRecordDTO dycProCommPriceRuleChngRecordDTO = this.buildRuleChngRecord(dycProCommPriceRuleInfoDTO);
        List<DycProCommPriceRuleSkuRangeChngRecordDTO> skuRangeChngRecordDTOSResult = this.buildSkuChngRecord(dycProCommPriceRuleInfoDTO);
        dycProCommPriceRuleChngRecordDTO.setSkuRangeChngRecordDTOs(skuRangeChngRecordDTOSResult);
        this.dycProCommPriceRuleChngRecordRepository.addPriceRuleChngRecord(dycProCommPriceRuleChngRecordDTO);
        this.addOperateRecord(reqBO, dycProCommPriceRuleInfoDTO);
        DycProCommAddPriceRuleInfoRspBO rspBO = new DycProCommAddPriceRuleInfoRspBO();
        rspBO.setPriceRuleId(dycProCommPriceRuleInfoDTO.getPriceRuleId());
        return rspBO;
    }

    private DycProCommPriceRuleChngRecordDTO buildRuleChngRecord(DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO) {
        DycProCommPriceRuleChngRecordDTO dycProCommPriceRuleChngRecordDTO = (DycProCommPriceRuleChngRecordDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleInfoDTO), DycProCommPriceRuleChngRecordDTO.class);
        dycProCommPriceRuleChngRecordDTO.setPriceRuleStatusOld(dycProCommPriceRuleInfoDTO.getPriceRuleStatus());
        dycProCommPriceRuleChngRecordDTO.setEnableHigherMarketPriceFlagOld(dycProCommPriceRuleInfoDTO.getEnableHigherMarketPriceFlag());
        dycProCommPriceRuleChngRecordDTO.setRoundRuleOld(dycProCommPriceRuleInfoDTO.getRoundRule());
        dycProCommPriceRuleChngRecordDTO.setExecStatus(DycProCommConstants.PriceRuleExecStatus.PENDING);
        return dycProCommPriceRuleChngRecordDTO;
    }

    private List<DycProCommPriceRuleSkuRangeChngRecordDTO> buildSkuChngRecord(DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO) {
        ArrayList<DycProCommPriceRuleSkuRangeChngRecordDTO> skuRangeChngRecordDTOSResult = new ArrayList<DycProCommPriceRuleSkuRangeChngRecordDTO>();
        dycProCommPriceRuleInfoDTO.getPriceRuleSkuRangeInfoDTOList().forEach(dycProCommPriceRuleSkuRangeInfoDTO -> {
            DycProCommPriceRuleSkuRangeChngRecordDTO skuRangeChngRecordDTO = this.buildSkuRangeChngRecordDTO((DycProCommPriceRuleSkuRangeInfoDTO)dycProCommPriceRuleSkuRangeInfoDTO, dycProCommPriceRuleInfoDTO);
            skuRangeChngRecordDTO.setChngType(DycProCommConstants.PriceRuleChngType.ADD);
            skuRangeChngRecordDTO.setPriceRiseTypeOld(skuRangeChngRecordDTO.getPriceRiseType());
            skuRangeChngRecordDTO.setPriceRiseRateOld(skuRangeChngRecordDTO.getPriceRiseRate());
            skuRangeChngRecordDTO.setLadderPriceRuleOld(skuRangeChngRecordDTO.getLadderPriceRule());
            skuRangeChngRecordDTO.setPriceRuleId(dycProCommPriceRuleInfoDTO.getPriceRuleId());
            skuRangeChngRecordDTOSResult.add(skuRangeChngRecordDTO);
        });
        return skuRangeChngRecordDTOSResult;
    }

    private DycProCommPriceRuleSkuRangeChngRecordDTO buildSkuRangeChngRecordDTO(DycProCommPriceRuleSkuRangeInfoDTO dto, DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO) {
        DycProCommPriceRuleSkuRangeChngRecordDTO skuRangeChngRecordDTO = new DycProCommPriceRuleSkuRangeChngRecordDTO();
        if (dycProCommPriceRuleInfoDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
            skuRangeChngRecordDTO.setAgrId(dto.getAgrId());
            skuRangeChngRecordDTO.setAgrName(dto.getAgrName());
            skuRangeChngRecordDTO.setAgrCode(dto.getAgrCode());
        }
        if (dycProCommPriceRuleInfoDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR_CATALOG.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
            skuRangeChngRecordDTO.setAgrId(dto.getAgrId());
            skuRangeChngRecordDTO.setAgrName(dto.getAgrName());
            skuRangeChngRecordDTO.setAgrCode(dto.getAgrCode());
            skuRangeChngRecordDTO.setCatalogId(dto.getCatalogId());
            skuRangeChngRecordDTO.setCatalogName(dto.getCatalogName());
        }
        if (dycProCommPriceRuleInfoDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
            skuRangeChngRecordDTO.setSupplierId(dto.getSupplierId());
            skuRangeChngRecordDTO.setSupplierName(dto.getSupplierName());
        }
        if (dycProCommPriceRuleInfoDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER_CATALOG.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
            skuRangeChngRecordDTO.setSupplierId(dto.getSupplierId());
            skuRangeChngRecordDTO.setSupplierName(dto.getSupplierName());
            skuRangeChngRecordDTO.setCatalogId(dto.getCatalogId());
            skuRangeChngRecordDTO.setCatalogName(dto.getCatalogName());
        }
        if (dycProCommPriceRuleInfoDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.DEFAULT.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
        }
        if (dycProCommPriceRuleInfoDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.CATALOG.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
            skuRangeChngRecordDTO.setCatalogId(dto.getCatalogId());
            skuRangeChngRecordDTO.setCatalogName(dto.getCatalogName());
        }
        if (dycProCommPriceRuleInfoDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SKU.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
            skuRangeChngRecordDTO.setSkuId(dto.getSkuId());
            skuRangeChngRecordDTO.setSkuCode(dto.getSkuCode());
            skuRangeChngRecordDTO.setSkuName(dto.getSkuName());
        }
        skuRangeChngRecordDTO.setPriceRiseRate(dto.getPriceRiseRate());
        skuRangeChngRecordDTO.setPriceRiseType(dto.getPriceRiseType());
        skuRangeChngRecordDTO.setLadderPriceRule(dto.getLadderPriceRule());
        return skuRangeChngRecordDTO;
    }

    private List<DycProCommPriceRuleSkuRangeInfoDTO> buildSkuRang(DycProCommAddPriceRuleInfoReqBO reqBO, DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO) {
        DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO;
        ArrayList<DycProCommPriceRuleSkuRangeInfoDTO> priceRuleSkuRangeInfoDTOList = new ArrayList<DycProCommPriceRuleSkuRangeInfoDTO>();
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR.getCode()))) {
            dycProCommPriceRuleInfoDTO.setPriority(DycProCommConstants.PriceRulePriority.AGR);
            DycProCommPriceRuleAgrBO priceRuleAgrBO = reqBO.getPriceRuleAgrBO();
            dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)priceRuleAgrBO), DycProCommPriceRuleSkuRangeInfoDTO.class);
            dycProCommPriceRuleSkuRangeInfoDTO.setLadderPriceRule(reqBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
            dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseRate(reqBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
            dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseType(reqBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
            priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO);
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR_CATALOG.getCode()))) {
            dycProCommPriceRuleInfoDTO.setPriority(DycProCommConstants.PriceRulePriority.AGR_CATALOG);
            reqBO.getPriceRuleCataLogBOs().forEach(dycProCommPriceRuleCatalogBO -> {
                DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleCatalogBO), DycProCommPriceRuleSkuRangeInfoDTO.class);
                dycProCommPriceRuleSkuRangeInfoDTO.setLadderPriceRule(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseRate(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseType(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
                dycProCommPriceRuleSkuRangeInfoDTO.setAgrId(reqBO.getPriceRuleAgrBO().getAgrId());
                dycProCommPriceRuleSkuRangeInfoDTO.setAgrCode(reqBO.getPriceRuleAgrBO().getAgrCode());
                dycProCommPriceRuleSkuRangeInfoDTO.setAgrName(reqBO.getPriceRuleAgrBO().getAgrName());
                dycProCommPriceRuleSkuRangeInfoDTO.setValueShiwFlag(Integer.valueOf(1));
                priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO);
            });
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER.getCode()))) {
            dycProCommPriceRuleInfoDTO.setPriority(DycProCommConstants.PriceRulePriority.SUPPLIER);
            DycProCommPriceRuleSupplierBO priceRuleSupplierBO = reqBO.getPriceRuleSupplierBO();
            dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)priceRuleSupplierBO), DycProCommPriceRuleSkuRangeInfoDTO.class);
            dycProCommPriceRuleSkuRangeInfoDTO.setLadderPriceRule(reqBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
            dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseRate(reqBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
            dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseType(reqBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
            priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO);
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER_CATALOG.getCode()))) {
            dycProCommPriceRuleInfoDTO.setPriority(DycProCommConstants.PriceRulePriority.SUPPLIER_CATALOG);
            reqBO.getPriceRuleCataLogBOs().forEach(dycProCommPriceRuleCatalogBO -> {
                DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleCatalogBO), DycProCommPriceRuleSkuRangeInfoDTO.class);
                dycProCommPriceRuleSkuRangeInfoDTO.setLadderPriceRule(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseRate(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseType(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
                dycProCommPriceRuleSkuRangeInfoDTO.setSupplierId(reqBO.getPriceRuleSupplierBO().getSupplierId());
                dycProCommPriceRuleSkuRangeInfoDTO.setSupplierName(reqBO.getPriceRuleSupplierBO().getSupplierName());
                dycProCommPriceRuleSkuRangeInfoDTO.setValueShiwFlag(Integer.valueOf(1));
                priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO);
            });
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.DEFAULT.getCode()))) {
            dycProCommPriceRuleInfoDTO.setPriority(DycProCommConstants.PriceRulePriority.DEFAULT);
            DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO2 = new DycProCommPriceRuleSkuRangeInfoDTO();
            dycProCommPriceRuleSkuRangeInfoDTO2.setLadderPriceRule(reqBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
            dycProCommPriceRuleSkuRangeInfoDTO2.setPriceRiseRate(reqBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
            dycProCommPriceRuleSkuRangeInfoDTO2.setPriceRiseType(reqBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
            priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO2);
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.CATALOG.getCode()))) {
            dycProCommPriceRuleInfoDTO.setPriority(DycProCommConstants.PriceRulePriority.CATALOG);
            reqBO.getPriceRuleCataLogBOs().forEach(dycProCommPriceRuleCatalogBO -> {
                DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleCatalogBO), DycProCommPriceRuleSkuRangeInfoDTO.class);
                dycProCommPriceRuleSkuRangeInfoDTO.setLadderPriceRule(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseRate(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseType(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
                dycProCommPriceRuleSkuRangeInfoDTO.setValueShiwFlag(Integer.valueOf(1));
                priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO);
            });
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SKU.getCode()))) {
            dycProCommPriceRuleInfoDTO.setPriority(DycProCommConstants.PriceRulePriority.SKU);
            reqBO.getPriceRuleSkuBOs().forEach(dycProCommPriceRuleSkuBO -> {
                DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleSkuBO), DycProCommPriceRuleSkuRangeInfoDTO.class);
                dycProCommPriceRuleSkuRangeInfoDTO.setLadderPriceRule(dycProCommPriceRuleSkuBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseRate(dycProCommPriceRuleSkuBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseType(dycProCommPriceRuleSkuBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
                priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO);
            });
        }
        return priceRuleSkuRangeInfoDTOList;
    }

    private void addOperateRecord(DycProCommAddPriceRuleInfoReqBO reqBO, DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO) {
        DycProCommOperateRecordDTO dycProCommOperateRecordDTO = new DycProCommOperateRecordDTO();
        dycProCommOperateRecordDTO.setOperateRecordId(Long.valueOf(Sequence.getInstance().nextId()));
        dycProCommOperateRecordDTO.setObjId(dycProCommPriceRuleInfoDTO.getPriceRuleId());
        dycProCommOperateRecordDTO.setObjType(DycProCommConstants.OperateRecordObjType.PRICE_RULE);
        dycProCommOperateRecordDTO.setOperateUserId(reqBO.getUserId());
        dycProCommOperateRecordDTO.setOperateUserName(reqBO.getName());
        dycProCommOperateRecordDTO.setOperateUserAccount(reqBO.getUserName());
        dycProCommOperateRecordDTO.setOperateTime(new Date());
        dycProCommOperateRecordDTO.setActionName(DmcCommOperateRecordActionTypeEnum.ADD.getValue());
        dycProCommOperateRecordDTO.setObjCode(dycProCommPriceRuleInfoDTO.getPriceRuleCode());
        dycProCommOperateRecordDTO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.ADD.getCode())));
        this.dycProCommOperateRecordRepository.addOperateRecord(dycProCommOperateRecordDTO);
    }

    private DycProCommPriceRuleInfoDTO buildPriceRuleInfo(DycProCommAddPriceRuleInfoReqBO reqBO) {
        DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO = (DycProCommPriceRuleInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getPriceRuleInfoBO()), DycProCommPriceRuleInfoDTO.class);
        dycProCommPriceRuleInfoDTO.setPriceRuleStatus(Integer.valueOf(Integer.parseInt(DmcCommPriceRuleStatusEnum.DRAFT.getCode())));
        dycProCommPriceRuleInfoDTO.setCreateUserId(reqBO.getUserId());
        dycProCommPriceRuleInfoDTO.setCreateUserName(reqBO.getName());
        dycProCommPriceRuleInfoDTO.setCreateUserAccount(reqBO.getUserName());
        dycProCommPriceRuleInfoDTO.setCreateOrgId(reqBO.getOrgId());
        dycProCommPriceRuleInfoDTO.setCreateOrgName(reqBO.getOrgName());
        dycProCommPriceRuleInfoDTO.setCreateCompanyId(reqBO.getCompanyId());
        dycProCommPriceRuleInfoDTO.setCreateCompanyName(reqBO.getCompanyName());
        dycProCommPriceRuleInfoDTO.setCreateOrgPath(reqBO.getOrgPath());
        dycProCommPriceRuleInfoDTO.setPriceRuleSrc(DycProCommConstants.CheckRuleSource.CHECK_RULE_SOURCE_MANUAL);
        dycProCommPriceRuleInfoDTO.setCreateTime(new Date());
        dycProCommPriceRuleInfoDTO.setUpdateUserId(reqBO.getUserId());
        dycProCommPriceRuleInfoDTO.setUpdateUserName(reqBO.getName());
        dycProCommPriceRuleInfoDTO.setUpdateUserAccount(reqBO.getUserName());
        dycProCommPriceRuleInfoDTO.setDelFlag(DycProCommConstants.DelFlag.NO);
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("UCC");
        encodeSerialReqBO.setEncodeRuleCode("PRICE_RULE_ENCODED");
        DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        dycProCommPriceRuleInfoDTO.setPriceRuleCode((String)encode.getSerialNoList().get(0));
        return dycProCommPriceRuleInfoDTO;
    }

    private void validParam(DycProCommAddPriceRuleInfoReqBO reqBO) {
        if (reqBO == null || reqBO.getPriceRuleInfoBO() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u3010skuRangeType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

