/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.pricerule.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommPriceRuleStatusEnum;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleChngRecordRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleChngQryDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleChngRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleInfoQryDTO;
import com.tydic.dyc.pro.dmc.service.pricerule.api.DycProCommOperatePriceRuleInfoService;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommOperatePriceRuleInfoReqBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommOperatePriceRuleInfoRspBO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.pricerule.api.DycProCommOperatePriceRuleInfoService"})
public class DycProCommOperatePriceRuleInfoServiceImpl
implements DycProCommOperatePriceRuleInfoService {
    @Autowired
    private DycProCommPriceRuleInfoRepository dycProCommPriceRuleInfoRepository;
    @Autowired
    DycProCommOperateRecordRepository dycProCommOperateRecordRepository;
    @Autowired
    private DycProCommPriceRuleChngRecordRepository dycProCommPriceRuleChngRecordRepository;

    @Override
    @PostMapping(value={"operatePriceRuleInfo"})
    public DycProCommOperatePriceRuleInfoRspBO operatePriceRuleInfo(@RequestBody DycProCommOperatePriceRuleInfoReqBO reqBO) {
        this.validParam(reqBO);
        DycProCommPriceRuleChngRecordDTO existRuleChngRecordDTO = this.queryExistChngRecord(reqBO);
        DycProCommPriceRuleInfoQryDTO queryDTO = new DycProCommPriceRuleInfoQryDTO();
        queryDTO.setPriceRuleId(reqBO.getPriceRuleId());
        DycProCommPriceRuleInfoDTO detailDto = this.dycProCommPriceRuleInfoRepository.queryPriceRuleInfoDetail(queryDTO);
        if (detailDto == null) {
            throw new ZTBusinessException("\u89c4\u5219ID" + reqBO.getPriceRuleId() + "\u4e0d\u5b58\u5728!");
        }
        DycProCommPriceRuleInfoDTO updateDTO = new DycProCommPriceRuleInfoDTO();
        updateDTO.setPriceRuleId(reqBO.getPriceRuleId());
        updateDTO.setUpdateUserId(reqBO.getUserId());
        updateDTO.setUpdateUserName(reqBO.getName());
        updateDTO.setUpdateUserAccount(reqBO.getUserName());
        updateDTO.setUpdateOrgId(reqBO.getOrgId());
        updateDTO.setUpdateOrgName(reqBO.getOrgName());
        updateDTO.setUpdateCompanyId(reqBO.getCompanyId());
        updateDTO.setUpdateCompanyName(reqBO.getCompanyName());
        updateDTO.setUpdateOrgPath(reqBO.getOrgPath());
        updateDTO.setUpdateTime(new Date());
        if ("disable".equals(reqBO.getOperateType())) {
            updateDTO.setPriceRuleStatus(Integer.valueOf(Integer.parseInt(DmcCommPriceRuleStatusEnum.DIS_ENABLE.getCode())));
            this.dycProCommPriceRuleInfoRepository.updatePriceRuleInfoStatus(updateDTO);
            this.addOperateRecord(reqBO, detailDto, DmcCommOperateRecordActionTypeEnum.DISABLE.getCode(), DmcCommOperateRecordActionTypeEnum.DISABLE.getValue());
        }
        if ("enable".equals(reqBO.getOperateType())) {
            updateDTO.setPriceRuleStatus(Integer.valueOf(Integer.parseInt(DmcCommPriceRuleStatusEnum.ENABLE.getCode())));
            this.dycProCommPriceRuleInfoRepository.updatePriceRuleInfoStatus(updateDTO);
            this.addOperateRecord(reqBO, detailDto, DmcCommOperateRecordActionTypeEnum.ENABLE.getCode(), DmcCommOperateRecordActionTypeEnum.ENABLE.getValue());
        }
        if ("delete".equals(reqBO.getOperateType())) {
            DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO = new DycProCommPriceRuleInfoDTO();
            dycProCommPriceRuleInfoDTO.setPriceRuleId(reqBO.getPriceRuleId());
            this.dycProCommPriceRuleInfoRepository.deletePriceRuleInfo(dycProCommPriceRuleInfoDTO);
            DycProCommPriceRuleChngRecordDTO dycProCommPriceRuleChngRecordDTO = new DycProCommPriceRuleChngRecordDTO();
            dycProCommPriceRuleChngRecordDTO.setPriceRuleId(reqBO.getPriceRuleId());
            this.dycProCommPriceRuleChngRecordRepository.deletePriceRuleChngRecord(dycProCommPriceRuleChngRecordDTO);
            return new DycProCommOperatePriceRuleInfoRspBO();
        }
        DycProCommPriceRuleChngRecordDTO dycProCommPriceRuleChngRecordDTO = this.buildRuleChngRecord(existRuleChngRecordDTO, detailDto, updateDTO);
        this.dycProCommPriceRuleChngRecordRepository.addPriceRuleChngRecord(dycProCommPriceRuleChngRecordDTO);
        return new DycProCommOperatePriceRuleInfoRspBO();
    }

    private DycProCommPriceRuleChngRecordDTO queryExistChngRecord(DycProCommOperatePriceRuleInfoReqBO reqBO) {
        DycProCommPriceRuleChngQryDTO ruleChngQryDTO = new DycProCommPriceRuleChngQryDTO();
        ruleChngQryDTO.setPriceRuleId(reqBO.getPriceRuleId());
        ruleChngQryDTO.setExecStatus(DycProCommConstants.PriceRuleExecStatus.PROGRESS);
        List ruleChngRecordDTOs = this.dycProCommPriceRuleChngRecordRepository.queryPriceRuleChngRecordList(ruleChngQryDTO);
        if (!CollectionUtils.isEmpty((Collection)ruleChngRecordDTOs)) {
            throw new ZTBusinessException("\u89c4\u5219\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        ruleChngQryDTO.setExecStatus(DycProCommConstants.PriceRuleExecStatus.PENDING);
        List ruleChngRecordDTOs1 = this.dycProCommPriceRuleChngRecordRepository.queryPriceRuleChngRecordList(ruleChngQryDTO);
        if (!CollectionUtils.isEmpty((Collection)ruleChngRecordDTOs1)) {
            return (DycProCommPriceRuleChngRecordDTO)ruleChngRecordDTOs1.get(0);
        }
        return null;
    }

    private DycProCommPriceRuleChngRecordDTO buildRuleChngRecord(DycProCommPriceRuleChngRecordDTO existRuleChngRecordDTO, DycProCommPriceRuleInfoDTO detailDto, DycProCommPriceRuleInfoDTO updateDTO) {
        DycProCommPriceRuleChngRecordDTO dycProCommPriceRuleChngRecordDTO = (DycProCommPriceRuleChngRecordDTO)JSON.parseObject((String)JSON.toJSONString((Object)detailDto), DycProCommPriceRuleChngRecordDTO.class);
        if (existRuleChngRecordDTO == null) {
            dycProCommPriceRuleChngRecordDTO.setPriceRuleStatusOld(detailDto.getPriceRuleStatus());
            dycProCommPriceRuleChngRecordDTO.setEnableHigherMarketPriceFlagOld(detailDto.getEnableHigherMarketPriceFlag());
            dycProCommPriceRuleChngRecordDTO.setRoundRuleOld(detailDto.getRoundRule());
        } else {
            dycProCommPriceRuleChngRecordDTO.setPriceRuleChngRecordId(existRuleChngRecordDTO.getPriceRuleChngRecordId());
        }
        dycProCommPriceRuleChngRecordDTO.setPriceRuleStatus(updateDTO.getPriceRuleStatus());
        dycProCommPriceRuleChngRecordDTO.setExecStatus(DycProCommConstants.PriceRuleExecStatus.PENDING);
        return dycProCommPriceRuleChngRecordDTO;
    }

    private void addOperateRecord(DycProCommOperatePriceRuleInfoReqBO reqBO, DycProCommPriceRuleInfoDTO detailDto, String actionType, String actionName) {
        DycProCommOperateRecordDTO dycProCommOperateRecordDTO = new DycProCommOperateRecordDTO();
        dycProCommOperateRecordDTO.setOperateRecordId(Long.valueOf(Sequence.getInstance().nextId()));
        dycProCommOperateRecordDTO.setObjId(reqBO.getPriceRuleId());
        dycProCommOperateRecordDTO.setObjCode(detailDto.getPriceRuleCode());
        dycProCommOperateRecordDTO.setObjType(DycProCommConstants.OperateRecordObjType.PRICE_RULE);
        dycProCommOperateRecordDTO.setOperateUserId(reqBO.getUserId());
        dycProCommOperateRecordDTO.setOperateUserName(reqBO.getName());
        dycProCommOperateRecordDTO.setOperateUserAccount(reqBO.getUserName());
        dycProCommOperateRecordDTO.setOperateTime(new Date());
        dycProCommOperateRecordDTO.setActionName(actionName);
        dycProCommOperateRecordDTO.setActionType(Integer.valueOf(Integer.parseInt(actionType)));
        this.dycProCommOperateRecordRepository.addOperateRecord(dycProCommOperateRecordDTO);
    }

    private void validParam(DycProCommOperatePriceRuleInfoReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOperateType() == null) {
            throw new ZTBusinessException("\u64cd\u4f5c\u7c7b\u578b\u3010operateType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPriceRuleId() == null) {
            throw new ZTBusinessException("\u89c4\u5219ID\u3010priceRuleId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

