/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.skumanage.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.api.DycProCommExtSkuMessageRecordsRepository;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.dto.DycProCommExtSkuMessageRecordsQueryDTO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommSkuMsgCheckService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuMsgCheckBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuMsgCheckReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuMsgCheckRspBO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommSkuMsgCheckService"})
public class DycProCommSkuMsgCheckServiceImpl
implements DycProCommSkuMsgCheckService {
    @Autowired
    private Environment environment;
    @Autowired
    private DycProCommExtSkuMessageRecordsRepository dycProCommExtSkuMessageRecordsRepository;

    @Override
    @PostMapping(value={"checkSkuMsg"})
    public DycProCommSkuMsgCheckRspBO checkSkuMsg(@RequestBody DycProCommSkuMsgCheckReqBO reqBO) {
        this.val(reqBO);
        DycProCommSkuMsgCheckRspBO rspBO = new DycProCommSkuMsgCheckRspBO();
        Map<Long, List<DycProCommSkuMsgCheckBO>> supplierMap = reqBO.getSkuList().stream().collect(Collectors.groupingBy(DycProCommSkuMsgCheckBO::getSupplierId));
        supplierMap.forEach((supplierId, dycProCommSkuMsgCheckBOS) -> {
            DycProCommExtSkuMessageRecordsQueryDTO qryRecordsDto = new DycProCommExtSkuMessageRecordsQueryDTO();
            qryRecordsDto.setSupplierHsn(this.environment.getProperty("SUPPLIER_ID_" + supplierId));
            qryRecordsDto.setMessageStatus(DycProCommConstants.MessageStatus.WAITING);
            qryRecordsDto.setExtSkuIdList(dycProCommSkuMsgCheckBOS.stream().map(DycProCommSkuMsgCheckBO::getExtSkuId).collect(Collectors.toList()));
            List waitRecordsDtoList = this.dycProCommExtSkuMessageRecordsRepository.selectMessageRecordsByCondition(qryRecordsDto);
            if (!CollectionUtils.isEmpty((Collection)waitRecordsDtoList)) {
                rspBO.setCheckResult(DycProCommConstants.YesOrNo.YES);
            }
        });
        return rspBO;
    }

    private void val(DycProCommSkuMsgCheckReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getSkuList())) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProCommSkuMsgCheckBO dycProCommSkuMsgCheckBO : reqBO.getSkuList()) {
            if (StringUtils.isBlank((CharSequence)dycProCommSkuMsgCheckBO.getExtSkuId())) {
                throw new ZTBusinessException("\u5165\u53c2\u5916\u90e8\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != dycProCommSkuMsgCheckBO.getSupplierId()) continue;
            throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

