/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.skumanage.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.userTaskProcess.api.DycProCommUserTaskProcessInfoRepository;
import com.tydic.dyc.pro.dmc.repository.userTaskProcess.dto.DycProCommUserTaskProcessInfoDTO;
import com.tydic.dyc.pro.dmc.repository.userTaskProcess.dto.DycProCommUserTaskProcessInfoQryDTO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommSkuMsgFlushedService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuMsgFlushedBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuMsgFlushedReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuMsgFlushedRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommSkuMsgFlushedService"})
public class DycProCommSkuMsgFlushedServiceImpl
implements DycProCommSkuMsgFlushedService {
    private static final Logger log = LoggerFactory.getLogger(DycProCommSkuMsgFlushedServiceImpl.class);
    @Autowired
    private Environment environment;
    @Autowired
    private DycProCommUserTaskProcessInfoRepository dycProCommUserTaskProcessInfoRepository;
    @Value(value="${comm.user.task.process.topic}")
    private String commUserTaskProcessTopic;
    @Value(value="${comm.user.task.process.tag}")
    private String commUserTaskProcessTag;
    @Value(value="${comm.user.task.process.pid}")
    private String commUserTaskProcessPid;
    @Resource(name="MqDycProCommUserTaskProcessProvider")
    private ProxyMessageProducer dycProCommUserTaskProcessProvider;

    @Override
    @PostMapping(value={"dealSkuMsgFlushed"})
    public DycProCommSkuMsgFlushedRspBO dealSkuMsgFlushed(@RequestBody DycProCommSkuMsgFlushedReqBO reqBO) {
        this.val(reqBO);
        Long id = this.dealSkuMsgFlushedSubmit(reqBO);
        reqBO.setId(id);
        ArrayList<DycProCommSkuMsgFlushedBO> pushSkuList = new ArrayList<DycProCommSkuMsgFlushedBO>();
        for (int i = 1; i <= reqBO.getSkuList().size(); ++i) {
            DycProCommSkuMsgFlushedBO dycProCommSkuMsgFlushedBO = reqBO.getSkuList().get(i - 1);
            dycProCommSkuMsgFlushedBO.setSupplierHsn(this.environment.getProperty("SUPPLIER_ID_" + dycProCommSkuMsgFlushedBO.getSupplierId()));
            String agrId = this.environment.getProperty("AGR_SUPPLIER_ID_" + dycProCommSkuMsgFlushedBO.getSupplierId());
            if (!StringUtils.isBlank((CharSequence)agrId)) {
                dycProCommSkuMsgFlushedBO.setAgrId(Long.parseLong(agrId));
            }
            pushSkuList.add(dycProCommSkuMsgFlushedBO);
            if (i % 100 != 0 && i != reqBO.getSkuList().size()) continue;
            DycProCommSkuMsgFlushedReqBO pushReqBO = new DycProCommSkuMsgFlushedReqBO();
            pushReqBO.setId(reqBO.getId());
            pushReqBO.setUserId(reqBO.getUserId());
            pushReqBO.setSkuList(pushSkuList);
            String mqJson = JSON.toJSONString((Object)pushReqBO);
            log.debug("\u53d1\u9001MQ\u5904\u7406\u6d88\u606f\u53c2\u6570:{}", (Object)mqJson);
            this.dycProCommUserTaskProcessProvider.send(new ProxyMessage(this.commUserTaskProcessTopic, this.commUserTaskProcessTag, mqJson));
            pushSkuList = new ArrayList();
        }
        return new DycProCommSkuMsgFlushedRspBO();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Long dealSkuMsgFlushedSubmit(DycProCommSkuMsgFlushedReqBO reqBO) {
        DycProCommUserTaskProcessInfoQryDTO qryUserTaskProcessDto = new DycProCommUserTaskProcessInfoQryDTO();
        ArrayList<Integer> processStatusList = new ArrayList<Integer>();
        processStatusList.add(DycProCommConstants.UserTaskProcessStatus.TODO);
        processStatusList.add(DycProCommConstants.UserTaskProcessStatus.DOING);
        qryUserTaskProcessDto.setProcStatusList(processStatusList);
        List dycProCommUserTaskProcessInfoDTOS = this.dycProCommUserTaskProcessInfoRepository.qryUserTaskProcessList(qryUserTaskProcessDto);
        if (!CollectionUtils.isEmpty((Collection)dycProCommUserTaskProcessInfoDTOS)) {
            if (dycProCommUserTaskProcessInfoDTOS.size() >= 5) {
                throw new ZTBusinessException("\u7b49\u5f85\u5904\u7406\u7684\u4efb\u52a1\u5df2\u67095\u4e2a\uff0c\u8bf7\u7a0d\u540e\u518d\u53d1\u8d77\u5237\u65b0\u4fe1\u606f");
            }
            for (DycProCommUserTaskProcessInfoDTO dycProCommUserTaskProcessInfoDTO : dycProCommUserTaskProcessInfoDTOS) {
                if (!reqBO.getUserId().equals(dycProCommUserTaskProcessInfoDTO.getUserId())) continue;
                throw new ZTBusinessException("\u4f60\u4e4b\u524d\u5df2\u63d0\u4ea4\u8fc7\u5237\u65b0\u4fe1\u606f\u7684\u8bf7\u6c42\uff0c\u8bf7\u7b49\u5f85\u5904\u7406\u5b8c\u6210\u540e\u518d\u53d1\u8d77");
            }
        }
        DycProCommUserTaskProcessInfoDTO dycProCommUserTaskProcessInfoDTO = new DycProCommUserTaskProcessInfoDTO();
        dycProCommUserTaskProcessInfoDTO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        dycProCommUserTaskProcessInfoDTO.setUserId(reqBO.getUserId());
        dycProCommUserTaskProcessInfoDTO.setProcStatus(DycProCommConstants.UserTaskProcessStatus.TODO);
        dycProCommUserTaskProcessInfoDTO.setTotalNum(Integer.valueOf(reqBO.getSkuList().size()));
        this.dycProCommUserTaskProcessInfoRepository.addUserTaskProcess(dycProCommUserTaskProcessInfoDTO);
        return dycProCommUserTaskProcessInfoDTO.getId();
    }

    private void val(DycProCommSkuMsgFlushedReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getSkuList())) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProCommSkuMsgFlushedBO dycProCommSkuMsgFlushedBO : reqBO.getSkuList()) {
            if (null == dycProCommSkuMsgFlushedBO.getSkuId()) {
                throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dycProCommSkuMsgFlushedBO.getExtSkuId())) {
                throw new ZTBusinessException("\u5165\u53c2\u5916\u90e8\u5546\u54c1ID\u4e3a\u7a7a");
            }
            if (null == dycProCommSkuMsgFlushedBO.getSupplierId()) {
                throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dycProCommSkuMsgFlushedBO.getSupplierName())) {
                throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != dycProCommSkuMsgFlushedBO.getTradeMode()) continue;
            throw new ZTBusinessException("\u5165\u53c2\u4ea4\u6613\u6a21\u5f0f\u4e3a\u7a7a");
        }
    }
}

