/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.spu.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommPropertyTemplateInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sensitiveword.api.DycProCommSensitiveWordInfoRepository;
import com.tydic.dyc.pro.dmc.repository.sensitiveword.dto.DycProCommSensitiveWordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommAgrDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuAfterSaleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDetailsInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuPicInfoDTO;
import com.tydic.dyc.pro.dmc.repository.spu.api.DycProCommSpuRepository;
import com.tydic.dyc.pro.dmc.repository.spu.dto.DycProCommSpuInfoDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import com.tydic.dyc.pro.dmc.service.spu.api.DycProCommSaveSpuService;
import com.tydic.dyc.pro.dmc.service.spu.bo.DycProCommSaveSpuReqBO;
import com.tydic.dyc.pro.dmc.service.spu.bo.DycProCommSaveSpuRspBO;
import com.tydic.dyc.pro.dmc.service.spu.bo.DycProCommSpuSkuInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.spu.api.DycProCommSaveSpuService"})
public class DycProCommSaveSpuServiceImpl
implements DycProCommSaveSpuService {
    @Autowired
    private DycProCommSpuRepository dycProCommSpuRepository;
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommSensitiveWordInfoRepository dycProCommSensitiveWordInfoRepository;

    @Override
    @PostMapping(value={"saveSpu"})
    public DycProCommSaveSpuRspBO saveSpu(@RequestBody DycProCommSaveSpuReqBO reqBO) {
        DycProCommPropertyTemplateInfoDTO queryPropertyTemplateResultDto;
        DycProCommSaveSpuRspBO rspBO = new DycProCommSaveSpuRspBO();
        Long propertyTemplateId = null;
        if (null != reqBO.getManageCatalogId()) {
            DycProCommPropertyTemplateInfoDTO queryPropertyTemplateDto = new DycProCommPropertyTemplateInfoDTO();
            queryPropertyTemplateDto.setManageCatalogId(reqBO.getManageCatalogId());
            queryPropertyTemplateResultDto = this.dycProCommManageCatalogRepository.queryPropertyTemplateOneByCondition(queryPropertyTemplateDto);
            if (null == queryPropertyTemplateResultDto || queryPropertyTemplateResultDto.getPropertyTemplateId() == null) {
                throw new ZTBusinessException("\u8be5\u7ba1\u7406\u76ee\u5f55\u672a\u67e5\u8be2\u5230\u5c5e\u6027\u6a21\u7248");
            }
        } else {
            throw new ZTBusinessException("\u8be5\u7ba1\u7406\u76ee\u5f55\u4e0d\u5b58\u5728\u5c5e\u6027\u6a21\u7248");
        }
        propertyTemplateId = queryPropertyTemplateResultDto.getPropertyTemplateId();
        if (null == reqBO.getSpuId()) {
            DycProCommSpuInfoDTO spuInfoDto = this.addSpuInfo(reqBO, propertyTemplateId);
            rspBO.setSpuId(spuInfoDto.getSpuId());
            this.addSkuInfo(reqBO, propertyTemplateId, spuInfoDto.getSpuId());
        } else {
            this.updateSpuInfo(reqBO, propertyTemplateId);
            rspBO.setSpuId(reqBO.getSpuId());
            DycProCommSkuDTO deleteSkuDto = new DycProCommSkuDTO();
            deleteSkuDto.setSpuId(reqBO.getSpuId());
            deleteSkuDto.setSkuStatus(DycProCommConstants.SkuStatus.DRAFT);
            this.dycProCommSkuRepository.realDeleteSkuAllInfoByCondition(deleteSkuDto);
            if (!CollectionUtils.isEmpty(reqBO.getSkuList())) {
                this.addSkuInfo(reqBO, propertyTemplateId, reqBO.getSpuId());
            }
        }
        return rspBO;
    }

    private void addSkuInfo(DycProCommSaveSpuReqBO reqBO, Long propertyTemplateId, Long spuId) {
        ArrayList<DycProCommSkuDTO> skuDTOList = new ArrayList<DycProCommSkuDTO>();
        List skuNames = reqBO.getSkuList().stream().map(DycProCommSpuSkuInfoBO::getSkuName).collect(Collectors.toList());
        String skuNameStr = String.join((CharSequence)",", skuNames);
        List sensitiveWordInfoDTOS = this.dycProCommSensitiveWordInfoRepository.verifySensitiveWord(skuNameStr);
        if (!CollectionUtils.isEmpty((Collection)sensitiveWordInfoDTOS)) {
            StringBuilder sensitiveWords = new StringBuilder();
            for (DycProCommSensitiveWordInfoDTO sensitiveWordDto : sensitiveWordInfoDTOS) {
                sensitiveWords.append("[").append(sensitiveWordDto.getSensitiveWordName()).append("],");
            }
            throw new ZTBusinessException("sku\u540d\u79f0\u5b58\u5728\u654f\u611f\u8bcd\uff1a" + sensitiveWords.toString());
        }
        for (DycProCommSpuSkuInfoBO spuSkuInfoBo : reqBO.getSkuList()) {
            DycProCommSkuDTO addSkuDto = new DycProCommSkuDTO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)addSkuDto);
            BeanUtils.copyProperties((Object)spuSkuInfoBo, (Object)addSkuDto);
            addSkuDto.setSkuStatus(DycProCommConstants.SkuStatus.DRAFT);
            addSkuDto.setSpuId(spuId);
            addSkuDto.setSkuSource(DycProCommConstants.SkuSource.AGR_SKU);
            addSkuDto.setPropertyTemplateId(propertyTemplateId);
            addSkuDto.setIsHaveGift(DycProCommConstants.IsHaveGift.NO);
            addSkuDto.setCreateUserId(reqBO.getUserId());
            addSkuDto.setCreateUserName(reqBO.getName());
            addSkuDto.setCreateUserAccount(reqBO.getUserName());
            addSkuDto.setCreateCompanyId(reqBO.getCompanyId());
            addSkuDto.setCreateCompanyName(reqBO.getCompanyName());
            addSkuDto.setCreateOrgId(reqBO.getOrgId());
            addSkuDto.setCreateOrgName(reqBO.getOrgName());
            addSkuDto.setCreateOrgPath(reqBO.getOrgPath());
            addSkuDto.setSaleMeasureRate(new BigDecimal(1));
            addSkuDto.setSettleMeasureId(spuSkuInfoBo.getSaleMeasureId());
            addSkuDto.setSettleMeasureName(spuSkuInfoBo.getSaleMeasureName());
            DycProCommAgrDTO skuAgrInfo = new DycProCommAgrDTO();
            BeanUtils.copyProperties((Object)reqBO.getSpuAgrInfo(), (Object)skuAgrInfo);
            addSkuDto.setSkuAgrInfo(skuAgrInfo);
            DycProCommSkuDetailsInfoDTO skuDetails = new DycProCommSkuDetailsInfoDTO();
            skuDetails.setPropertyInstInfo(spuSkuInfoBo.getSkuDetails().getPropertyInstInfo());
            skuDetails.setAfterSaleRemark(reqBO.getSpuDetails().getAfterSaleRemark());
            skuDetails.setPackageRemark(reqBO.getSpuDetails().getPackageRemark());
            skuDetails.setSkuPcDetailUrl(reqBO.getSpuDetails().getSpuPcDetailUrl());
            addSkuDto.setSkuDetails(skuDetails);
            if (null != reqBO.getSpuDetails()) {
                DycProCommSkuAfterSaleInfoDTO addSkuAfterSaleInfoDto = new DycProCommSkuAfterSaleInfoDTO();
                BeanUtils.copyProperties((Object)reqBO.getSpuAfterSaleInfo(), (Object)addSkuAfterSaleInfoDto);
                addSkuDto.setSkuAfterSaleInfo(addSkuAfterSaleInfoDto);
            }
            if (!CollectionUtils.isEmpty(spuSkuInfoBo.getSkuPicInfoList())) {
                List addSkuPicInfoList = JSONArray.parseArray((String)JSON.toJSONString(spuSkuInfoBo.getSkuPicInfoList())).toJavaList(DycProCommSkuPicInfoDTO.class);
                addSkuDto.setSkuPicInfoList(addSkuPicInfoList);
            }
            if (null != spuSkuInfoBo.getPriceInfo()) {
                DycProCommSkuPriceInfoDTO addSkuPriceInfoDto = new DycProCommSkuPriceInfoDTO();
                addSkuPriceInfoDto.setSupplierPrice(spuSkuInfoBo.getPriceInfo().getSupplierPrice());
                addSkuPriceInfoDto.setMarketPrice(spuSkuInfoBo.getPriceInfo().getMarketPrice());
                addSkuPriceInfoDto.setSalePrice(spuSkuInfoBo.getPriceInfo().getSupplierPrice());
                addSkuPriceInfoDto.setPriority(Integer.valueOf(0));
                addSkuDto.setPriceInfo(addSkuPriceInfoDto);
            }
            if (null != spuSkuInfoBo.getStockInfo()) {
                DycProCommSkuStockInfoDTO addSkuStockInfo = new DycProCommSkuStockInfoDTO();
                addSkuStockInfo.setSkuName(spuSkuInfoBo.getSkuName());
                addSkuStockInfo.setOriginNum(spuSkuInfoBo.getStockInfo().getOriginNum());
                addSkuStockInfo.setTotalNum(spuSkuInfoBo.getStockInfo().getOriginNum());
                addSkuStockInfo.setUnsaleNum(spuSkuInfoBo.getStockInfo().getOriginNum());
                addSkuStockInfo.setSaledNum(new BigDecimal(0));
                addSkuStockInfo.setSupplierId(reqBO.getSupplierId());
                addSkuStockInfo.setSupplierName(reqBO.getSupplierName());
                addSkuStockInfo.setSaleMeasureId(spuSkuInfoBo.getSaleMeasureId());
                addSkuStockInfo.setSaleMeasureName(spuSkuInfoBo.getSaleMeasureName());
                addSkuStockInfo.setCreateUserId(reqBO.getUserId());
                addSkuStockInfo.setCreateUserName(reqBO.getName());
                addSkuStockInfo.setCreateUserAccount(reqBO.getUserName());
                addSkuStockInfo.setCreateCompanyId(reqBO.getCompanyId());
                addSkuStockInfo.setCreateCompanyName(reqBO.getCompanyName());
                addSkuStockInfo.setCreateOrgId(reqBO.getOrgId());
                addSkuStockInfo.setCreateOrgName(reqBO.getOrgName());
                addSkuDto.setStockInfo(addSkuStockInfo);
            }
            skuDTOList.add(addSkuDto);
        }
        this.dycProCommSkuRepository.addSkuCompleteInfoBatchAndSyncNosql(skuDTOList, false);
    }

    private void updateSpuInfo(DycProCommSaveSpuReqBO reqBO, Long propertyTemplateId) {
        DycProCommSpuInfoDTO updateSpuInfoDto = (DycProCommSpuInfoDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProCommSpuInfoDTO.class);
        updateSpuInfoDto.setPropertyTemplateId(propertyTemplateId);
        updateSpuInfoDto.setUpdateUserId(reqBO.getUserId());
        updateSpuInfoDto.setUpdateUserName(reqBO.getName());
        updateSpuInfoDto.setUpdateUserAccount(reqBO.getUserName());
        updateSpuInfoDto.setUpdateCompanyId(reqBO.getCompanyId());
        updateSpuInfoDto.setUpdateCompanyName(reqBO.getCompanyName());
        updateSpuInfoDto.setUpdateOrgId(reqBO.getOrgId());
        updateSpuInfoDto.setUpdateOrgName(reqBO.getOrgName());
        updateSpuInfoDto.setUpdateOrgPath(reqBO.getOrgPath());
        this.dycProCommSpuRepository.updateSpuAllInfoAndSyncNosql(updateSpuInfoDto);
    }

    private DycProCommSpuInfoDTO addSpuInfo(DycProCommSaveSpuReqBO reqBO, Long propertyTemplateId) {
        List sensitiveWordInfoDTOS = this.dycProCommSensitiveWordInfoRepository.verifySensitiveWord(reqBO.getSpuName());
        if (!CollectionUtils.isEmpty((Collection)sensitiveWordInfoDTOS)) {
            StringBuilder sensitiveWords = new StringBuilder();
            for (DycProCommSensitiveWordInfoDTO sensitiveWordDto : sensitiveWordInfoDTOS) {
                sensitiveWords.append("[").append(sensitiveWordDto.getSensitiveWordName()).append("],");
            }
            throw new ZTBusinessException("spu\u540d\u79f0\u5b58\u5728\u654f\u611f\u8bcd\uff1a" + sensitiveWords.toString());
        }
        DycProCommSpuInfoDTO addSpuInfoDto = (DycProCommSpuInfoDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProCommSpuInfoDTO.class);
        addSpuInfoDto.setPropertyTemplateId(propertyTemplateId);
        addSpuInfoDto.setSpuSource(DycProCommConstants.SpuSource.AGR_SPU);
        addSpuInfoDto.setSpuStatus(DycProCommConstants.SpuStatus.DRAFT);
        addSpuInfoDto.setCreateUserId(reqBO.getUserId());
        addSpuInfoDto.setCreateUserName(reqBO.getName());
        addSpuInfoDto.setCreateUserAccount(reqBO.getUserName());
        addSpuInfoDto.setCreateCompanyId(reqBO.getCompanyId());
        addSpuInfoDto.setCreateCompanyName(reqBO.getCompanyName());
        addSpuInfoDto.setCreateOrgId(reqBO.getOrgId());
        addSpuInfoDto.setCreateOrgName(reqBO.getOrgName());
        addSpuInfoDto.setCreateOrgPath(reqBO.getOrgPath());
        DycProCommSpuInfoDTO dycProCommSpuInfoDTO = this.dycProCommSpuRepository.addSpuAllInfoAndSyncNosql(addSpuInfoDto);
        return dycProCommSpuInfoDTO;
    }
}

