/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.catalogban.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.dao.CommBansRuleChngRecordMapper;
import com.tydic.dyc.pro.dmc.dao.CommBansRuleInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommBansRuleSkuRangeChngRecordMapper;
import com.tydic.dyc.pro.dmc.dao.CommBansRuleSkuRangeInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommFileInfoMapper;
import com.tydic.dyc.pro.dmc.po.CommBansRuleChngRecordPO;
import com.tydic.dyc.pro.dmc.po.CommBansRuleInfoPO;
import com.tydic.dyc.pro.dmc.po.CommBansRuleSkuRangeChngRecordPO;
import com.tydic.dyc.pro.dmc.po.CommBansRuleSkuRangeInfoPO;
import com.tydic.dyc.pro.dmc.po.CommFileInfoPO;
import com.tydic.dyc.pro.dmc.po.SelectBansRuleInfoListPagePO;
import com.tydic.dyc.pro.dmc.repository.catalogban.api.DycProCommCatalogBanRepository;
import com.tydic.dyc.pro.dmc.repository.catalogban.dto.DycProCommCatalogBanChangeInfoDTO;
import com.tydic.dyc.pro.dmc.repository.catalogban.dto.DycProCommCatalogBanInfoChangeDTO;
import com.tydic.dyc.pro.dmc.repository.catalogban.dto.DycProCommCatalogBanInfoChangeItemDTO;
import com.tydic.dyc.pro.dmc.repository.catalogban.dto.DycProCommCatalogBanInfoDTO;
import com.tydic.dyc.pro.dmc.repository.catalogban.dto.DycProCommCatalogBanQryDTO;
import com.tydic.dyc.pro.dmc.repository.catalogban.dto.DycProCommFileInfoDTO;
import com.tydic.dyc.pro.dmc.repository.catalogban.dto.DycProCommodityCatalogBansDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycProCommCatalogBanRepositoryImpl
implements DycProCommCatalogBanRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProCommCatalogBanRepositoryImpl.class);
    @Autowired
    private CommBansRuleInfoMapper commBansRuleInfoMapper;
    @Autowired
    private CommBansRuleSkuRangeInfoMapper commBansRuleSkuRangeInfoMapper;
    @Autowired
    private CommFileInfoMapper commFileInfoMapper;
    @Autowired
    private DycProEncodeSerialService encodeSerialService;
    @Autowired
    private CommBansRuleChngRecordMapper commBansRuleChngRecordMapper;
    @Autowired
    private CommBansRuleSkuRangeChngRecordMapper commBansRuleSkuRangeChngRecordMapper;

    @Override
    public RspPage<DycProCommCatalogBanInfoDTO> catalogBanQryList(DycProCommCatalogBanQryDTO reqBO) {
        Page page = new Page((long)reqBO.getPageNo().intValue(), (long)reqBO.getPageSize().intValue());
        page.setOptimizeCountSql(false);
        SelectBansRuleInfoListPagePO selectBansRuleInfoListPagePO = (SelectBansRuleInfoListPagePO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), SelectBansRuleInfoListPagePO.class);
        if (StringUtils.isEmpty((CharSequence)reqBO.getSupplierName()) && null == reqBO.getCatalogId()) {
            Page page2 = new Page((long)reqBO.getPageNo().intValue(), (long)reqBO.getPageSize().intValue());
            page2.setOptimizeCountSql(false);
            LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
            queryWrapper.likeIfPresent(CommBansRuleInfoPO::getBansReason, reqBO.getBansReason());
            queryWrapper.eqIfPresent(CommBansRuleInfoPO::getBansRuleStatus, (Object)reqBO.getBansRuleStatus());
            queryWrapper.orderByDesc(CommBansRuleInfoPO::getUpdateTime);
            page2 = (Page)this.commBansRuleInfoMapper.selectPage((IPage)page2, (Wrapper)queryWrapper);
            List selectBansRuleInfoListPagePOS = new ArrayList();
            selectBansRuleInfoListPagePOS = page2.getRecords();
            RspPage rspPage = new RspPage();
            if (!ObjectUtils.isEmpty(selectBansRuleInfoListPagePOS)) {
                List dycProCommCatalogBanInfoDTOS = JSON.parseArray((String)JSON.toJSONString(selectBansRuleInfoListPagePOS), DycProCommCatalogBanInfoDTO.class);
                for (DycProCommCatalogBanInfoDTO ruleInfoConnectPO : dycProCommCatalogBanInfoDTOS) {
                    List skuRangeInfoPOS = this.commBansRuleSkuRangeInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleSkuRangeInfoPO::getBansRuleId, (Object)ruleInfoConnectPO.getBansRuleId()));
                    ArrayList<DycProCommodityCatalogBansDTO> catalogBansList = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)skuRangeInfoPOS)) {
                        catalogBansList = JSON.parseArray((String)JSON.toJSONString((Object)skuRangeInfoPOS), DycProCommodityCatalogBansDTO.class);
                        ruleInfoConnectPO.setCatalogBansList(catalogBansList);
                    }
                    LambdaQueryWrapperX queryWrapper2 = new LambdaQueryWrapperX();
                    queryWrapper2.eq(CommBansRuleChngRecordPO::getBansRuleId, (Object)ruleInfoConnectPO.getBansRuleId());
                    queryWrapper2.eq(CommBansRuleChngRecordPO::getExecStatus, (Object)DycProCommConstants.BansRuleExecStatus.PROGRESS);
                    List commBansRuleSkuRangeChngRecordPOS = this.commBansRuleChngRecordMapper.selectList((Wrapper)queryWrapper2);
                    if (CollectionUtils.isEmpty((Collection)commBansRuleSkuRangeChngRecordPOS)) {
                        ruleInfoConnectPO.setAllowEditFlag(true);
                        continue;
                    }
                    ruleInfoConnectPO.setAllowEditFlag(false);
                }
                rspPage.setRows(dycProCommCatalogBanInfoDTOS);
            }
            rspPage.setPageNo((int)page2.getCurrent());
            rspPage.setTotal((int)page2.getPages());
            rspPage.setRecordsTotal((int)page2.getTotal());
            return rspPage;
        }
        page = this.commBansRuleInfoMapper.selectBansRuleInfoListPage(selectBansRuleInfoListPagePO, page);
        List selectBansRuleInfoListPagePOS = new ArrayList();
        selectBansRuleInfoListPagePOS = page.getRecords();
        RspPage rspPage = new RspPage();
        if (!ObjectUtils.isEmpty(selectBansRuleInfoListPagePOS)) {
            List dycProCommCatalogBanInfoDTOS = JSON.parseArray((String)JSON.toJSONString(selectBansRuleInfoListPagePOS), DycProCommCatalogBanInfoDTO.class);
            for (DycProCommCatalogBanInfoDTO ruleInfoConnectPO : dycProCommCatalogBanInfoDTOS) {
                List skuRangeInfoPOS = this.commBansRuleSkuRangeInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleSkuRangeInfoPO::getBansRuleId, (Object)ruleInfoConnectPO.getBansRuleId()));
                ArrayList<DycProCommodityCatalogBansDTO> catalogBansList = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)skuRangeInfoPOS)) {
                    catalogBansList = JSON.parseArray((String)JSON.toJSONString((Object)skuRangeInfoPOS), DycProCommodityCatalogBansDTO.class);
                    ruleInfoConnectPO.setCatalogBansList(catalogBansList);
                }
                LambdaQueryWrapperX queryWrapper2 = new LambdaQueryWrapperX();
                queryWrapper2.eq(CommBansRuleChngRecordPO::getBansRuleId, (Object)ruleInfoConnectPO.getBansRuleId());
                queryWrapper2.eq(CommBansRuleChngRecordPO::getExecStatus, (Object)DycProCommConstants.BansRuleExecStatus.PROGRESS);
                List commBansRuleSkuRangeChngRecordPOS = this.commBansRuleChngRecordMapper.selectList((Wrapper)queryWrapper2);
                if (CollectionUtils.isEmpty((Collection)commBansRuleSkuRangeChngRecordPOS)) {
                    ruleInfoConnectPO.setAllowEditFlag(true);
                    continue;
                }
                ruleInfoConnectPO.setAllowEditFlag(false);
            }
            rspPage.setRows(dycProCommCatalogBanInfoDTOS);
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public void createBanRuleInfo(DycProCommCatalogBanInfoDTO dycProCommCatalogBanInfoDTO) {
        if (StringUtils.isBlank((CharSequence)dycProCommCatalogBanInfoDTO.getBansReason())) {
            throw new ZTBusinessException("\u5165\u53c2\u7981\u552e\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(dycProCommCatalogBanInfoDTO.getCatalogBansList())) {
            throw new ZTBusinessException("\u5165\u53c2\u7981\u552e\u7c7b\u76ee\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProCommodityCatalogBansDTO dycProCommodityCatalogBansDTO : dycProCommCatalogBanInfoDTO.getCatalogBansList()) {
            if (StringUtils.isBlank((CharSequence)dycProCommodityCatalogBansDTO.getSupplierName())) {
                throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == dycProCommodityCatalogBansDTO.getSupplierId()) {
                throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dycProCommodityCatalogBansDTO.getCatalogName())) {
                throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == dycProCommodityCatalogBansDTO.getCatalogId()) {
                throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((CharSequence)dycProCommodityCatalogBansDTO.getCatalogPath())) continue;
            throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76ee\u6811\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == dycProCommCatalogBanInfoDTO.getBansStartDate()) {
            throw new ZTBusinessException("\u5165\u53c2\u7981\u552e\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == dycProCommCatalogBanInfoDTO.getBansEndDate()) {
            throw new ZTBusinessException("\u5165\u53c2\u7981\u552e\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("UCC");
        encodeSerialReqBO.setEncodeRuleCode("BAN_RULE_ENCODED");
        DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        Long id = Sequence.getInstance().nextId();
        CommBansRuleInfoPO commBansRuleInfoPO = (CommBansRuleInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommCatalogBanInfoDTO), CommBansRuleInfoPO.class);
        commBansRuleInfoPO.setBansRuleCode((String)encode.getSerialNoList().get(0));
        commBansRuleInfoPO.setBansRuleStatus(DycProCommConstants.BansRuleStatus.EFFECTIVE);
        commBansRuleInfoPO.setBansRuleId(id);
        this.commBansRuleInfoMapper.insert((Object)commBansRuleInfoPO);
        List commBansRuleSkuRangeInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProCommCatalogBanInfoDTO.getCatalogBansList()), CommBansRuleSkuRangeInfoPO.class);
        for (Object commBansRuleSkuRangeInfoPO : commBansRuleSkuRangeInfoPOS) {
            Long skuRangeId = Sequence.getInstance().nextId();
            commBansRuleSkuRangeInfoPO.setBansRuleId(id);
            commBansRuleSkuRangeInfoPO.setSkuRangeId(skuRangeId);
        }
        this.commBansRuleSkuRangeInfoMapper.insertBatch((Collection)commBansRuleSkuRangeInfoPOS);
        if (!CollectionUtils.isEmpty(dycProCommCatalogBanInfoDTO.getFileInfoBOS())) {
            List fileInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProCommCatalogBanInfoDTO.getFileInfoBOS()), CommFileInfoPO.class);
            for (CommFileInfoPO fileInfoPO : fileInfoPOS) {
                fileInfoPO.setObjId(id);
                fileInfoPO.setObjType(DycProCommConstants.FileInfoType.BANS_RULE_FILE_TYPE);
            }
            this.commFileInfoMapper.insertBatch((Collection)fileInfoPOS);
        }
        CommBansRuleChngRecordPO commBansRuleChngRecordPO = (CommBansRuleChngRecordPO)JSON.parseObject((String)JSON.toJSONString((Object)commBansRuleInfoPO), CommBansRuleChngRecordPO.class);
        Long chngId = Sequence.getInstance().nextId();
        commBansRuleChngRecordPO.setBansRuleChngRecordId(chngId);
        commBansRuleChngRecordPO.setChngType(DycProCommConstants.BansRuleChngType.ADD);
        commBansRuleChngRecordPO.setExecStatus(DycProCommConstants.BansRuleExecStatus.PENDING);
        this.commBansRuleChngRecordMapper.insert((Object)commBansRuleChngRecordPO);
        List commBansRuleSkuRangeChngRecordPOS = JSON.parseArray((String)JSON.toJSONString((Object)commBansRuleSkuRangeInfoPOS), CommBansRuleSkuRangeChngRecordPO.class);
        for (CommBansRuleSkuRangeChngRecordPO commBansRuleSkuRangeChngRecordPO : commBansRuleSkuRangeChngRecordPOS) {
            Long chngItemId = Sequence.getInstance().nextId();
            commBansRuleSkuRangeChngRecordPO.setSkuRangeChngRecordId(chngItemId);
            commBansRuleSkuRangeChngRecordPO.setBansRuleChngRecordId(chngId);
            commBansRuleSkuRangeChngRecordPO.setChngType(DycProCommConstants.BansRuleChngType.ADD);
            commBansRuleSkuRangeChngRecordPO.setExecStatus(DycProCommConstants.BansRuleExecStatus.PENDING);
        }
        this.commBansRuleSkuRangeChngRecordMapper.insertBatch((Collection)commBansRuleSkuRangeChngRecordPOS);
    }

    @Override
    public DycProCommCatalogBanInfoDTO qryBansRuleInfoDetail(DycProCommCatalogBanInfoDTO reqBO) {
        CommBansRuleInfoPO commBansRuleInfoPO = (CommBansRuleInfoPO)this.commBansRuleInfoMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleInfoPO::getBansRuleId, (Object)reqBO.getBansRuleId()));
        if (null == commBansRuleInfoPO) {
            throw new ZTBusinessException("\u8be5\u7981\u552e\u89c4\u5219\u4e0d\u5b58\u5728");
        }
        DycProCommCatalogBanInfoDTO dycProCommCatalogBanInfoDTO = (DycProCommCatalogBanInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)commBansRuleInfoPO), DycProCommCatalogBanInfoDTO.class);
        List skuRangeInfoPOS = this.commBansRuleSkuRangeInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleSkuRangeInfoPO::getBansRuleId, (Object)reqBO.getBansRuleId()));
        List catalogBansList = JSON.parseArray((String)JSON.toJSONString((Object)skuRangeInfoPOS), DycProCommodityCatalogBansDTO.class);
        dycProCommCatalogBanInfoDTO.setCatalogBansList(catalogBansList);
        List fileInfoPOS = this.commFileInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommFileInfoPO::getObjId, (Object)reqBO.getBansRuleId()));
        if (!CollectionUtils.isEmpty((Collection)fileInfoPOS)) {
            List dycProCommFileInfoDTOS = JSON.parseArray((String)JSON.toJSONString((Object)fileInfoPOS), DycProCommFileInfoDTO.class);
            dycProCommCatalogBanInfoDTO.setFileInfoBOS(dycProCommFileInfoDTOS);
        }
        return dycProCommCatalogBanInfoDTO;
    }

    @Override
    public void deleteBansRuleInfo(DycProCommCatalogBanInfoDTO dycProCommCatalogBanInfoDTO) {
        CommBansRuleInfoPO commBansRuleInfoPO = (CommBansRuleInfoPO)this.commBansRuleInfoMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleInfoPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId()));
        if (null == commBansRuleInfoPO) {
            throw new ZTBusinessException("\u8be5\u7981\u552e\u89c4\u5219\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        CommBansRuleChngRecordPO commBansRuleChngRecordPO = (CommBansRuleChngRecordPO)JSON.parseObject((String)JSON.toJSONString((Object)commBansRuleInfoPO), CommBansRuleChngRecordPO.class);
        Long chngId = Sequence.getInstance().nextId();
        commBansRuleChngRecordPO.setBansRuleChngRecordId(chngId);
        commBansRuleChngRecordPO.setChngType(DycProCommConstants.BansRuleChngType.DELETE);
        commBansRuleChngRecordPO.setCreateTime(dycProCommCatalogBanInfoDTO.getCreateTime());
        commBansRuleChngRecordPO.setCreateUserId(dycProCommCatalogBanInfoDTO.getCreateUserId());
        commBansRuleChngRecordPO.setCreateUserName(dycProCommCatalogBanInfoDTO.getCreateUserName());
        commBansRuleChngRecordPO.setCreateUserAccount(dycProCommCatalogBanInfoDTO.getCreateUserAccount());
        commBansRuleChngRecordPO.setCreateOrgId(dycProCommCatalogBanInfoDTO.getCreateOrgId());
        commBansRuleChngRecordPO.setCreateOrgName(dycProCommCatalogBanInfoDTO.getCreateOrgName());
        commBansRuleChngRecordPO.setCreateOrgPath(dycProCommCatalogBanInfoDTO.getCreateOrgPath());
        commBansRuleChngRecordPO.setCreateCompanyId(dycProCommCatalogBanInfoDTO.getCreateCompanyId());
        commBansRuleChngRecordPO.setCreateCompanyName(dycProCommCatalogBanInfoDTO.getCreateCompanyName());
        commBansRuleChngRecordPO.setExecStatus(DycProCommConstants.BansRuleExecStatus.PENDING);
        this.commBansRuleChngRecordMapper.insert((Object)commBansRuleChngRecordPO);
        List skuRangeInfoPOS = this.commBansRuleSkuRangeInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleSkuRangeInfoPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId()));
        List commBansRuleSkuRangeChngRecordPOS = JSON.parseArray((String)JSON.toJSONString((Object)skuRangeInfoPOS), CommBansRuleSkuRangeChngRecordPO.class);
        for (CommBansRuleSkuRangeChngRecordPO commBansRuleSkuRangeChngRecordPO : commBansRuleSkuRangeChngRecordPOS) {
            Long chngItemId = Sequence.getInstance().nextId();
            commBansRuleSkuRangeChngRecordPO.setSkuRangeChngRecordId(chngItemId);
            commBansRuleSkuRangeChngRecordPO.setBansRuleChngRecordId(chngId);
            commBansRuleSkuRangeChngRecordPO.setChngType(DycProCommConstants.BansRuleChngType.DELETE);
            commBansRuleSkuRangeChngRecordPO.setExecStatus(DycProCommConstants.BansRuleExecStatus.PENDING);
        }
        this.commBansRuleSkuRangeChngRecordMapper.insertBatch((Collection)commBansRuleSkuRangeChngRecordPOS);
        this.commBansRuleInfoMapper.delete((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleInfoPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId()));
        this.commBansRuleSkuRangeInfoMapper.delete((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleSkuRangeInfoPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId()));
        this.commFileInfoMapper.delete((Wrapper)new LambdaQueryWrapperX().eq(CommFileInfoPO::getObjId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId()));
    }

    @Override
    public void editBanRuleInfo(DycProCommCatalogBanInfoDTO dycProCommCatalogBanInfoDTO) {
        CommBansRuleChngRecordPO chngRecordPO;
        if (null == dycProCommCatalogBanInfoDTO.getBansRuleId()) {
            throw new ZTBusinessException("\u5165\u53c2\u7981\u552e\u89c4\u5219id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)dycProCommCatalogBanInfoDTO.getBansReason())) {
            throw new ZTBusinessException("\u5165\u53c2\u7981\u552e\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(dycProCommCatalogBanInfoDTO.getCatalogBansList())) {
            throw new ZTBusinessException("\u5165\u53c2\u7981\u552e\u7c7b\u76ee\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProCommodityCatalogBansDTO dycProCommodityCatalogBansDTO : dycProCommCatalogBanInfoDTO.getCatalogBansList()) {
            if (StringUtils.isBlank((CharSequence)dycProCommodityCatalogBansDTO.getSupplierName())) {
                throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dycProCommodityCatalogBansDTO.getCatalogPath())) {
                throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76ee\u6811\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == dycProCommodityCatalogBansDTO.getSupplierId()) {
                throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dycProCommodityCatalogBansDTO.getCatalogName())) {
                throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != dycProCommodityCatalogBansDTO.getCatalogId()) continue;
            throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == dycProCommCatalogBanInfoDTO.getBansStartDate()) {
            throw new ZTBusinessException("\u5165\u53c2\u7981\u552e\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == dycProCommCatalogBanInfoDTO.getBansEndDate()) {
            throw new ZTBusinessException("\u5165\u53c2\u7981\u552e\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CommBansRuleInfoPO commBansRuleInfoPOOld = (CommBansRuleInfoPO)this.commBansRuleInfoMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleInfoPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId()));
        CommBansRuleInfoPO commBansRuleInfoPO = (CommBansRuleInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommCatalogBanInfoDTO), CommBansRuleInfoPO.class);
        commBansRuleInfoPO.setBansRuleStatus(DycProCommConstants.BansRuleStatus.EFFECTIVE);
        this.commBansRuleInfoMapper.updateById((Object)commBansRuleInfoPO);
        LambdaQueryWrapperX queryWrapperFile = new LambdaQueryWrapperX();
        queryWrapperFile.eq(CommFileInfoPO::getObjId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId());
        this.commFileInfoMapper.delete((Wrapper)queryWrapperFile);
        if (!CollectionUtils.isEmpty(dycProCommCatalogBanInfoDTO.getFileInfoBOS())) {
            List fileInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProCommCatalogBanInfoDTO.getFileInfoBOS()), CommFileInfoPO.class);
            for (CommFileInfoPO fileInfoPO : fileInfoPOS) {
                fileInfoPO.setObjId(dycProCommCatalogBanInfoDTO.getBansRuleId());
                fileInfoPO.setObjType(DycProCommConstants.FileInfoType.BANS_RULE_FILE_TYPE);
            }
            this.commFileInfoMapper.insertBatch((Collection)fileInfoPOS);
        }
        LambdaQueryWrapperX queryWrapperChngRedord = new LambdaQueryWrapperX();
        queryWrapperChngRedord.eq(CommBansRuleChngRecordPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId());
        queryWrapperChngRedord.eq(CommBansRuleChngRecordPO::getExecStatus, (Object)DycProCommConstants.BansRuleExecStatus.PENDING);
        List chngRecordPOSOld = this.commBansRuleChngRecordMapper.selectList((Wrapper)queryWrapperChngRedord);
        if (!CollectionUtils.isEmpty((Collection)chngRecordPOSOld)) {
            chngRecordPO = (CommBansRuleChngRecordPO)JSON.parseObject((String)JSON.toJSONString((Object)commBansRuleInfoPO), CommBansRuleChngRecordPO.class);
            chngRecordPO.setBansRuleChngRecordId(((CommBansRuleChngRecordPO)chngRecordPOSOld.get(0)).getBansRuleChngRecordId());
            chngRecordPO.setExecStatus(DycProCommConstants.BansRuleExecStatus.PENDING);
            chngRecordPO.setChngType(DycProCommConstants.BansRuleChngType.EDIT);
            chngRecordPO.setCreateTime(new Date());
            this.commBansRuleChngRecordMapper.updateById((Object)chngRecordPO);
            HashMap<Long, Long> skuRangIdMap = new HashMap<Long, Long>();
            List skuRangeInfoPOS = this.commBansRuleSkuRangeInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleSkuRangeInfoPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId()));
            List catalogIds = dycProCommCatalogBanInfoDTO.getCatalogBansList().stream().map(a -> a.getCatalogId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)skuRangeInfoPOS)) {
                CommBansRuleSkuRangeChngRecordPO recordPO;
                this.commBansRuleSkuRangeInfoMapper.delete((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleSkuRangeInfoPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId()));
                List commBansRuleSkuRangeInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProCommCatalogBanInfoDTO.getCatalogBansList()), CommBansRuleSkuRangeInfoPO.class);
                for (CommBansRuleSkuRangeInfoPO commBansRuleSkuRangeInfoPO : commBansRuleSkuRangeInfoPOS) {
                    Long chngItemId = Sequence.getInstance().nextId();
                    commBansRuleSkuRangeInfoPO.setSkuRangeId(chngItemId);
                    commBansRuleSkuRangeInfoPO.setBansRuleId(dycProCommCatalogBanInfoDTO.getBansRuleId());
                    skuRangIdMap.put(commBansRuleSkuRangeInfoPO.getCatalogId(), chngItemId);
                }
                this.commBansRuleSkuRangeInfoMapper.insertBatch((Collection)commBansRuleSkuRangeInfoPOS);
                for (Object skuRangeInfoPO : skuRangeInfoPOS) {
                    if (catalogIds.contains(skuRangeInfoPO.getCatalogId())) continue;
                    LambdaQueryWrapperX qryUpdate = new LambdaQueryWrapperX();
                    qryUpdate.eq(CommBansRuleSkuRangeChngRecordPO::getBansRuleChngRecordId, (Object)((CommBansRuleChngRecordPO)chngRecordPOSOld.get(0)).getBansRuleChngRecordId());
                    qryUpdate.eq(CommBansRuleSkuRangeChngRecordPO::getExecStatus, (Object)DycProCommConstants.BansRuleExecStatus.PENDING);
                    qryUpdate.eq(CommBansRuleSkuRangeChngRecordPO::getCatalogId, (Object)skuRangeInfoPO.getCatalogId());
                    recordPO = new CommBansRuleSkuRangeChngRecordPO();
                    recordPO.setChngType(DycProCommConstants.BansRuleChngType.DELETE);
                    this.commBansRuleSkuRangeChngRecordMapper.update((Object)recordPO, (Wrapper)qryUpdate);
                }
                List skuItemCatalogIds = skuRangeInfoPOS.stream().map(a -> a.getCatalogId()).collect(Collectors.toList());
                for (DycProCommodityCatalogBansDTO dycProCommodityCatalogBansDTO : dycProCommCatalogBanInfoDTO.getCatalogBansList()) {
                    if (skuItemCatalogIds.contains(dycProCommodityCatalogBansDTO.getCatalogId())) continue;
                    recordPO = (CommBansRuleSkuRangeChngRecordPO)JSON.parseObject((String)JSONObject.toJSONString((Object)dycProCommodityCatalogBansDTO), CommBansRuleSkuRangeChngRecordPO.class);
                    Long chngItemId = Sequence.getInstance().nextId();
                    recordPO.setSkuRangeChngRecordId(chngItemId);
                    recordPO.setSkuRangeId((Long)skuRangIdMap.get(dycProCommodityCatalogBansDTO.getCatalogId()));
                    recordPO.setBansRuleId(dycProCommCatalogBanInfoDTO.getBansRuleId());
                    recordPO.setBansRuleChngRecordId(((CommBansRuleChngRecordPO)chngRecordPOSOld.get(0)).getBansRuleChngRecordId());
                    recordPO.setChngType(DycProCommConstants.BansRuleChngType.ADD);
                    recordPO.setExecStatus(DycProCommConstants.BansRuleExecStatus.PENDING);
                    this.commBansRuleSkuRangeChngRecordMapper.insert((Object)recordPO);
                }
            }
        } else {
            chngRecordPO = (CommBansRuleChngRecordPO)JSON.parseObject((String)JSON.toJSONString((Object)commBansRuleInfoPO), CommBansRuleChngRecordPO.class);
            Long chngId = Sequence.getInstance().nextId();
            chngRecordPO.setBansRuleChngRecordId(chngId);
            chngRecordPO.setChngType(DycProCommConstants.BansRuleChngType.EDIT);
            chngRecordPO.setExecStatus(DycProCommConstants.BansRuleExecStatus.PENDING);
            chngRecordPO.setCreateTime(new Date());
            this.commBansRuleChngRecordMapper.insert((Object)chngRecordPO);
            ArrayList<Object> skuRangeChngRecordOlds = new ArrayList<Object>();
            List skuRangeInfoPOS = this.commBansRuleSkuRangeInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleSkuRangeInfoPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId()));
            List catalogIds = dycProCommCatalogBanInfoDTO.getCatalogBansList().stream().map(a -> a.getCatalogId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)skuRangeInfoPOS)) {
                for (CommBansRuleSkuRangeInfoPO skuRangeInfoPO : skuRangeInfoPOS) {
                    if (catalogIds.contains(skuRangeInfoPO.getCatalogId())) continue;
                    CommBansRuleSkuRangeChngRecordPO recordPO = (CommBansRuleSkuRangeChngRecordPO)JSON.parseObject((String)JSONObject.toJSONString((Object)skuRangeInfoPO), CommBansRuleSkuRangeChngRecordPO.class);
                    Long chngItemId = Sequence.getInstance().nextId();
                    recordPO.setSkuRangeChngRecordId(chngItemId);
                    recordPO.setBansRuleId(dycProCommCatalogBanInfoDTO.getBansRuleId());
                    recordPO.setBansRuleChngRecordId(chngId);
                    recordPO.setChngType(DycProCommConstants.BansRuleChngType.DELETE);
                    recordPO.setExecStatus(DycProCommConstants.BansRuleExecStatus.PENDING);
                    skuRangeChngRecordOlds.add(recordPO);
                }
            }
            this.commBansRuleSkuRangeInfoMapper.delete((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleSkuRangeInfoPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId()));
            List commBansRuleSkuRangeInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProCommCatalogBanInfoDTO.getCatalogBansList()), CommBansRuleSkuRangeInfoPO.class);
            HashMap<String, Long> itemIdMap = new HashMap<String, Long>();
            for (CommBansRuleSkuRangeInfoPO commBansRuleSkuRangeInfoPO : commBansRuleSkuRangeInfoPOS) {
                Long chngItemId = Sequence.getInstance().nextId();
                commBansRuleSkuRangeInfoPO.setSkuRangeId(chngItemId);
                commBansRuleSkuRangeInfoPO.setBansRuleId(dycProCommCatalogBanInfoDTO.getBansRuleId());
                itemIdMap.put(commBansRuleSkuRangeInfoPO.getSupplierId().toString() + commBansRuleSkuRangeInfoPO.getCatalogId().toString(), chngItemId);
            }
            this.commBansRuleSkuRangeInfoMapper.insertBatch((Collection)commBansRuleSkuRangeInfoPOS);
            List skuRangeChngRecordPOS = JSON.parseArray((String)JSON.toJSONString((Object)commBansRuleSkuRangeInfoPOS), CommBansRuleSkuRangeChngRecordPO.class);
            for (CommBansRuleSkuRangeChngRecordPO commBansRuleSkuRangeInfoPO : skuRangeChngRecordPOS) {
                Long chngItemId = Sequence.getInstance().nextId();
                commBansRuleSkuRangeInfoPO.setSkuRangeChngRecordId(chngItemId);
                commBansRuleSkuRangeInfoPO.setBansRuleId(dycProCommCatalogBanInfoDTO.getBansRuleId());
                commBansRuleSkuRangeInfoPO.setBansRuleChngRecordId(chngId);
                commBansRuleSkuRangeInfoPO.setChngType(DycProCommConstants.BansRuleChngType.ADD);
                commBansRuleSkuRangeInfoPO.setExecStatus(DycProCommConstants.BansRuleExecStatus.PENDING);
            }
            this.commBansRuleSkuRangeChngRecordMapper.insertBatch((Collection)skuRangeChngRecordPOS);
            if (!CollectionUtils.isEmpty(skuRangeChngRecordOlds)) {
                this.commBansRuleSkuRangeChngRecordMapper.insertBatch(skuRangeChngRecordOlds);
            }
        }
    }

    public static <T, U> boolean compareIds(List<T> list1, List<U> list2, Function<T, ?> idExtractor1, Function<U, ?> idExtractor2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        Set ids1 = list1.stream().map(idExtractor1).collect(Collectors.toSet());
        Set ids2 = list2.stream().map(idExtractor2).collect(Collectors.toSet());
        return ids1.equals(ids2);
    }

    @Override
    public void operBanRuleInfo(DycProCommCatalogBanInfoDTO dycProCommCatalogBanInfoDTO) {
        CommBansRuleInfoPO po = new CommBansRuleInfoPO();
        po.setBansRuleId(dycProCommCatalogBanInfoDTO.getBansRuleId());
        po.setBansRuleStatus(DycProCommConstants.BansRuleStatus.INVALID);
        this.commBansRuleInfoMapper.updateById((Object)po);
        LambdaQueryWrapperX queryWrapperChngRedord = new LambdaQueryWrapperX();
        queryWrapperChngRedord.eq(CommBansRuleChngRecordPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId());
        queryWrapperChngRedord.eq(CommBansRuleChngRecordPO::getExecStatus, (Object)DycProCommConstants.BansRuleExecStatus.PENDING);
        List chngRecordPOSOld = this.commBansRuleChngRecordMapper.selectList((Wrapper)queryWrapperChngRedord);
        if (!CollectionUtils.isEmpty((Collection)chngRecordPOSOld)) {
            LambdaQueryWrapperX queryWrapperChngRedord2 = new LambdaQueryWrapperX();
            queryWrapperChngRedord2.eq(CommBansRuleChngRecordPO::getBansRuleChngRecordId, (Object)((CommBansRuleChngRecordPO)chngRecordPOSOld.get(0)).getBansRuleChngRecordId());
            CommBansRuleChngRecordPO chngRecordPO = new CommBansRuleChngRecordPO();
            chngRecordPO.setChngType(DycProCommConstants.BansRuleChngType.DELETE);
            this.commBansRuleChngRecordMapper.update((Object)chngRecordPO, (Wrapper)queryWrapperChngRedord2);
            LambdaQueryWrapperX queryWrapperChngRedord3 = new LambdaQueryWrapperX();
            queryWrapperChngRedord2.eq(CommBansRuleChngRecordPO::getBansRuleChngRecordId, (Object)((CommBansRuleChngRecordPO)chngRecordPOSOld.get(0)).getBansRuleChngRecordId());
            CommBansRuleSkuRangeChngRecordPO chngRecordPO2 = new CommBansRuleSkuRangeChngRecordPO();
            chngRecordPO2.setChngType(DycProCommConstants.BansRuleChngType.DELETE);
            this.commBansRuleSkuRangeChngRecordMapper.update((Object)chngRecordPO2, (Wrapper)queryWrapperChngRedord3);
        } else {
            CommBansRuleInfoPO commBansRuleInfoPO = (CommBansRuleInfoPO)this.commBansRuleInfoMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleInfoPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId()));
            CommBansRuleChngRecordPO commBansRuleChngRecordPO = (CommBansRuleChngRecordPO)JSON.parseObject((String)JSON.toJSONString((Object)commBansRuleInfoPO), CommBansRuleChngRecordPO.class);
            Long chngId = Sequence.getInstance().nextId();
            commBansRuleChngRecordPO.setBansRuleChngRecordId(chngId);
            commBansRuleChngRecordPO.setChngType(DycProCommConstants.BansRuleChngType.DELETE);
            commBansRuleChngRecordPO.setCreateTime(new Date());
            commBansRuleChngRecordPO.setExecStatus(DycProCommConstants.BansRuleExecStatus.PENDING);
            this.commBansRuleChngRecordMapper.insert((Object)commBansRuleChngRecordPO);
            List skuRangeInfoPOS = this.commBansRuleSkuRangeInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommBansRuleSkuRangeInfoPO::getBansRuleId, (Object)dycProCommCatalogBanInfoDTO.getBansRuleId()));
            List commBansRuleSkuRangeChngRecordPOS = JSON.parseArray((String)JSON.toJSONString((Object)skuRangeInfoPOS), CommBansRuleSkuRangeChngRecordPO.class);
            for (CommBansRuleSkuRangeChngRecordPO commBansRuleSkuRangeChngRecordPO : commBansRuleSkuRangeChngRecordPOS) {
                Long chngItemId = Sequence.getInstance().nextId();
                commBansRuleSkuRangeChngRecordPO.setSkuRangeChngRecordId(chngItemId);
                commBansRuleSkuRangeChngRecordPO.setBansRuleChngRecordId(chngId);
                commBansRuleSkuRangeChngRecordPO.setChngType(DycProCommConstants.BansRuleChngType.DELETE);
                commBansRuleSkuRangeChngRecordPO.setExecStatus(DycProCommConstants.BansRuleExecStatus.PENDING);
            }
            this.commBansRuleSkuRangeChngRecordMapper.insertBatch((Collection)commBansRuleSkuRangeChngRecordPOS);
        }
    }

    @Override
    public List<DycProCommCatalogBanInfoChangeDTO> qryPendingBansRule() {
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
        List commBansRuleInfoPOS = this.commBansRuleInfoMapper.selectList((Wrapper)queryWrapperX);
        if (!CollectionUtils.isEmpty((Collection)commBansRuleInfoPOS)) {
            List bansRuleIds = commBansRuleInfoPOS.stream().map(a -> a.getBansRuleId()).collect(Collectors.toList());
            Map<Long, List<CommBansRuleInfoPO>> collect = commBansRuleInfoPOS.stream().collect(Collectors.groupingBy(a -> a.getBansRuleId()));
            LambdaQueryWrapperX queryWrapperChangeX = new LambdaQueryWrapperX();
            queryWrapperChangeX.eq(CommBansRuleChngRecordPO::getExecStatus, (Object)DycProCommConstants.BansRuleExecStatus.PENDING);
            queryWrapperChangeX.in(CommBansRuleChngRecordPO::getBansRuleId, bansRuleIds);
            List chngRecordPOS = this.commBansRuleChngRecordMapper.selectList((Wrapper)queryWrapperChangeX);
            if (!CollectionUtils.isEmpty((Collection)chngRecordPOS)) {
                List commBansRuleSkuRangeInfoPOS = JSON.parseArray((String)JSON.toJSONString((Object)chngRecordPOS), DycProCommCatalogBanInfoChangeDTO.class);
                for (DycProCommCatalogBanInfoChangeDTO commBansRuleSkuRangeInfoPO : commBansRuleSkuRangeInfoPOS) {
                    commBansRuleSkuRangeInfoPO.setBansRuleCode(collect.get(commBansRuleSkuRangeInfoPO.getBansRuleId()).get(0).getBansRuleCode());
                }
                return commBansRuleSkuRangeInfoPOS;
            }
        }
        return null;
    }

    @Override
    public List<DycProCommCatalogBanInfoChangeItemDTO> qryChangeCatalogItemByRuleId(Long changeRecordId) {
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
        queryWrapperX.eq(CommBansRuleSkuRangeChngRecordPO::getBansRuleChngRecordId, (Object)changeRecordId);
        queryWrapperX.eq(CommBansRuleSkuRangeChngRecordPO::getExecStatus, (Object)DycProCommConstants.BansRuleExecStatus.PENDING);
        queryWrapperX.orderByDesc(CommBansRuleSkuRangeChngRecordPO::getChngType);
        List commBansRuleSkuRangeChngRecordPOS = this.commBansRuleSkuRangeChngRecordMapper.selectList((Wrapper)queryWrapperX);
        List commBansRuleSkuRangeInfoPOS = JSON.parseArray((String)JSON.toJSONString((Object)commBansRuleSkuRangeChngRecordPOS), DycProCommCatalogBanInfoChangeItemDTO.class);
        return commBansRuleSkuRangeInfoPOS;
    }

    @Override
    public void operBanRuleChangeInfo(DycProCommCatalogBanChangeInfoDTO changeInfoDTO) {
        CommBansRuleChngRecordPO chngRecordPO = new CommBansRuleChngRecordPO();
        chngRecordPO.setExecStatus(changeInfoDTO.getExecStatus());
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
        queryWrapperX.eq(CommBansRuleChngRecordPO::getBansRuleChngRecordId, (Object)changeInfoDTO.getBansRuleChngRecordId());
        this.commBansRuleChngRecordMapper.update((Object)chngRecordPO, (Wrapper)queryWrapperX);
    }

    @Override
    public void operBanRuleChangeItemInfo(DycProCommCatalogBanInfoChangeItemDTO changeItemDTO) {
        CommBansRuleSkuRangeChngRecordPO skuRangeChngRecordPO = new CommBansRuleSkuRangeChngRecordPO();
        skuRangeChngRecordPO.setExecStatus(changeItemDTO.getExecStatus());
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
        queryWrapperX.eq(CommBansRuleSkuRangeChngRecordPO::getSkuRangeChngRecordId, (Object)changeItemDTO.getSkuRangeChngRecordId());
        this.commBansRuleSkuRangeChngRecordMapper.update((Object)skuRangeChngRecordPO, (Wrapper)queryWrapperX);
    }

    @Override
    public List<DycProCommCatalogBanInfoDTO> qryBansInfoByCatalogId(Long catalogId, Long supplierId) {
        log.debug("\u7c7b\u76ee\u7981\u552e\u67e5\u8be2\u5165\u53c2\uff1a" + catalogId, (Object)supplierId);
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
        ArrayList<Long> catalogIds = new ArrayList<Long>();
        catalogIds.add(catalogId);
        catalogIds.add(1L);
        ArrayList<Long> supplierIds = new ArrayList<Long>();
        supplierIds.add(supplierId);
        supplierIds.add(-1L);
        queryWrapperX.in(CommBansRuleSkuRangeInfoPO::getCatalogId, catalogIds);
        queryWrapperX.in(CommBansRuleSkuRangeInfoPO::getSupplierId, supplierIds);
        List skuRangeInfoPOS = this.commBansRuleSkuRangeInfoMapper.selectList((Wrapper)queryWrapperX);
        if (CollectionUtils.isEmpty((Collection)skuRangeInfoPOS)) {
            return null;
        }
        List bansRuleIds = skuRangeInfoPOS.stream().map(a -> a.getBansRuleId()).collect(Collectors.toList());
        LambdaQueryWrapperX queryWrapperXByInfo = new LambdaQueryWrapperX();
        queryWrapperXByInfo.in(CommBansRuleInfoPO::getBansRuleId, bansRuleIds);
        queryWrapperXByInfo.eq(CommBansRuleInfoPO::getBansRuleStatus, (Object)DycProCommConstants.BansRuleStatus.EFFECTIVE);
        List commBansRuleInfoPOS = this.commBansRuleInfoMapper.selectList((Wrapper)queryWrapperXByInfo);
        if (CollectionUtils.isEmpty((Collection)commBansRuleInfoPOS)) {
            return null;
        }
        List dycProCommCatalogBanInfoDTOS = JSON.parseArray((String)JSONObject.toJSONString((Object)commBansRuleInfoPOS), DycProCommCatalogBanInfoDTO.class);
        log.debug("\u7c7b\u76ee\u7981\u552e\u67e5\u8be2\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)dycProCommCatalogBanInfoDTOS));
        return dycProCommCatalogBanInfoDTOS;
    }
}

