/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.pool.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.bo.NosqlQueryBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryGroupBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateArrayFieldReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateArrayFieldRsqBO;
import com.ohaotian.plugin.nosql.constant.NosqlConnetType;
import com.ohaotian.plugin.nosql.constant.NosqlQueryValueType;
import com.ohaotian.plugin.nosql.impl.NosqlBuilder;
import com.tydic.dyc.pro.base.bo.DycProBaseManagePageRspBO;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.dictionary.enums.DelFlag;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommPoolInfoPoolRelated;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.dao.CommManageCatalogInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommPoolCommodityRelMapper;
import com.tydic.dyc.pro.dmc.dao.CommPoolInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommPoolManageCatalogRelMapper;
import com.tydic.dyc.pro.dmc.dao.CommPropertyTemplateInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuInfoMapper;
import com.tydic.dyc.pro.dmc.po.CommManageCatalogInfoPO;
import com.tydic.dyc.pro.dmc.po.CommPoolCommodityRelExtPO;
import com.tydic.dyc.pro.dmc.po.CommPoolCommodityRelPO;
import com.tydic.dyc.pro.dmc.po.CommPoolInfoPO;
import com.tydic.dyc.pro.dmc.po.CommPoolManageCatalogRelExtPO;
import com.tydic.dyc.pro.dmc.po.CommPoolManageCatalogRelPO;
import com.tydic.dyc.pro.dmc.po.CommPropertyTemplateInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuInfoAggPO;
import com.tydic.dyc.pro.dmc.po.CommSkuInfoPO;
import com.tydic.dyc.pro.dmc.repository.pool.api.DycProCommPoolInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pool.dto.DycProCommPoolCommodityRelDTO;
import com.tydic.dyc.pro.dmc.repository.pool.dto.DycProCommPoolInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pool.dto.DycProCommPoolManageCatalogRelDTO;
import com.tydic.dyc.pro.dmc.repository.pool.dto.DycProCommPoolQryDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProCommPoolInfoRepositoryImpl
implements DycProCommPoolInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProCommPoolInfoRepositoryImpl.class);
    @Autowired
    private CommPoolInfoMapper commPoolInfoMapper;
    @Autowired
    private CommPoolCommodityRelMapper commPoolCommodityRelMapper;
    @Autowired
    private CommPoolManageCatalogRelMapper commPoolManageCatalogRelMapper;
    @Autowired
    private CommPropertyTemplateInfoMapper commPropertyTemplateInfoMapper;
    @Autowired
    private CommSkuInfoMapper commSkuInfoMapper;
    @Autowired
    private CommManageCatalogInfoMapper commManageCatalogInfoMapper;
    @Autowired
    private DycProEncodeSerialService encodeSerialService;
    @Autowired
    private NosqlClient nosqlClient;
    @Value(value="${ucc.es.index}")
    private String skuIndexName;

    @Override
    public RspPage<DycProCommPoolInfoDTO> getCommodityPoolListPage(DycProCommPoolQryDTO reqBO) {
        Page pg = new Page((long)reqBO.getPageNo().intValue(), (long)reqBO.getPageSize().intValue());
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.likeIfPresent(CommPoolInfoPO::getPoolName, reqBO.getPoolName());
        queryWrapper.likeIfPresent(CommPoolInfoPO::getPoolCode, reqBO.getPoolCode());
        queryWrapper.eqIfPresent(CommPoolInfoPO::getEnableFlag, (Object)reqBO.getEnableFlag());
        queryWrapper.eqIfPresent(CommPoolInfoPO::getPoolRelated, (Object)reqBO.getPoolRelated());
        queryWrapper.likeIfPresent(CommPoolInfoPO::getCreateUserName, reqBO.getCreateUserName());
        queryWrapper.betweenIfPresent(CommPoolInfoPO::getCreateTime, (Object)reqBO.getCreateTimeStart(), (Object)reqBO.getCreateTimeEnd());
        queryWrapper.likeIfPresent(CommPoolInfoPO::getUpdateUserName, reqBO.getUpdateUserName());
        queryWrapper.betweenIfPresent(CommPoolInfoPO::getUpdateTime, (Object)reqBO.getUpdateTimeStart(), (Object)reqBO.getUpdateTimeEnd());
        queryWrapper.eq(CommPoolInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
        queryWrapper.orderByDesc(CommPoolInfoPO::getUpdateTime);
        Page result = (Page)this.commPoolInfoMapper.selectPage((IPage)pg, (Wrapper)queryWrapper);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProCommPoolInfoDTO.class));
        }
        rspPage.setPageNo((int)result.getCurrent());
        rspPage.setTotal((int)result.getPages());
        rspPage.setRecordsTotal((int)result.getTotal());
        return rspPage;
    }

    @Override
    public void operCommodityPoolEnable(DycProCommPoolInfoDTO dycProCommPoolInfoDTO) {
        if (null == dycProCommPoolInfoDTO.getPoolId()) {
            throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1\u6c60ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == dycProCommPoolInfoDTO.getEnableFlag()) {
            throw new ZTBusinessException("\u5165\u53c2\u662f\u5426\u542f\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CommPoolInfoPO commPoolInfoPO = new CommPoolInfoPO();
        commPoolInfoPO.setPoolId(dycProCommPoolInfoDTO.getPoolId());
        commPoolInfoPO.setEnableFlag(dycProCommPoolInfoDTO.getEnableFlag());
        this.commPoolInfoMapper.updateById((Object)commPoolInfoPO);
        NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
        nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
        nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(false));
        nosqlUpdateArrayFieldReqBO.setArrayFieldName("poolList");
        nosqlUpdateArrayFieldReqBO.setIdFieldName("poolId");
        nosqlUpdateArrayFieldReqBO.setIdValue(dycProCommPoolInfoDTO.getPoolId().toString());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("enableFlag", dycProCommPoolInfoDTO.getEnableFlag());
        nosqlUpdateArrayFieldReqBO.setMaps(map);
        ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
        List<NosqlQueryBO> nosqlQueryBOList = DycProCommPoolInfoRepositoryImpl.initNosqlQueryGroupList(nosqlQueryGroupBOList);
        NosqlQueryBO poolId = new NosqlQueryBO("poolList.poolId", dycProCommPoolInfoDTO.getPoolId().toString(), NosqlQueryValueType.ACCURATE);
        nosqlQueryBOList.add(poolId);
        NosqlBuilder nosqlBuilder = new NosqlBuilder();
        nosqlBuilder.setNosqlQueryGroupList(nosqlQueryGroupBOList);
        nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlBuilder);
        log.debug("\u5546\u54c1\u6c60\u505c\u542f\u7528\u540c\u6b65nosql\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
        NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
        log.debug("\u5546\u54c1\u6c60\u505c\u542f\u7528\u540c\u6b65nosql\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
    }

    @NotNull
    private static List<NosqlQueryBO> initNosqlQueryGroupList(List<NosqlQueryGroupBO> nosqlQueryGroupBOList) {
        ArrayList<NosqlQueryBO> nosqlQueryBOList = new ArrayList<NosqlQueryBO>();
        NosqlQueryGroupBO subQueryGroupBO = new NosqlQueryGroupBO();
        subQueryGroupBO.setNosqlQueryList(nosqlQueryBOList);
        subQueryGroupBO.setConnetType(NosqlConnetType.AND);
        ArrayList<NosqlQueryGroupBO> subnosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
        subnosqlQueryGroupBOList.add(subQueryGroupBO);
        NosqlQueryGroupBO queryGroupBO = new NosqlQueryGroupBO(subnosqlQueryGroupBOList, NosqlConnetType.AND);
        nosqlQueryGroupBOList.add(queryGroupBO);
        return nosqlQueryBOList;
    }

    @Override
    public void deleteCommodityPool(DycProCommPoolInfoDTO dycProCommPoolInfoDTO) {
        if (null == dycProCommPoolInfoDTO.getPoolId()) {
            throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1\u6c60ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CommPoolInfoPO poolInfoPO = (CommPoolInfoPO)this.commPoolInfoMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommPoolInfoPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()).eq(CommPoolInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO));
        if (null == poolInfoPO) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u4e0d\u5b58\u5728");
        }
        CommPoolInfoPO commPoolInfoPO = new CommPoolInfoPO();
        commPoolInfoPO.setPoolId(dycProCommPoolInfoDTO.getPoolId());
        commPoolInfoPO.setDelFlag(dycProCommPoolInfoDTO.getDelFlag());
        this.commPoolInfoMapper.updateById((Object)commPoolInfoPO);
        if (DycProCommConstants.CommPoolInfoPoolRelated.MANAGE_CATALOG.equals(commPoolInfoPO.getPoolRelated())) {
            this.commPoolManageCatalogRelMapper.delete((Wrapper)new LambdaQueryWrapperX().eq(CommPoolManageCatalogRelPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()));
        } else {
            this.commPoolCommodityRelMapper.delete((Wrapper)new LambdaQueryWrapperX().eq(CommPoolCommodityRelPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()));
        }
        NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
        nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
        nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(false));
        nosqlUpdateArrayFieldReqBO.setArrayFieldName("poolList");
        nosqlUpdateArrayFieldReqBO.setIdFieldName("poolId");
        nosqlUpdateArrayFieldReqBO.setIdValue(dycProCommPoolInfoDTO.getPoolId().toString());
        nosqlUpdateArrayFieldReqBO.setMaps(null);
        ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
        List<NosqlQueryBO> nosqlQueryBOList = DycProCommPoolInfoRepositoryImpl.initNosqlQueryGroupList(nosqlQueryGroupBOList);
        NosqlQueryBO poolId = new NosqlQueryBO("poolList.poolId", dycProCommPoolInfoDTO.getPoolId().toString(), NosqlQueryValueType.ACCURATE);
        nosqlQueryBOList.add(poolId);
        NosqlBuilder nosqlBuilder = new NosqlBuilder();
        nosqlBuilder.setNosqlQueryGroupList(nosqlQueryGroupBOList);
        nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlBuilder);
        log.debug("\u5546\u54c1\u6c60\u5220\u9664\u540c\u6b65nosql\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
        NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
        log.debug("\u5546\u54c1\u6c60\u5220\u9664\u540c\u6b65nosql\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
    }

    @Override
    public void editCommodityPool(DycProCommPoolInfoDTO dycProCommPoolInfoDTO) {
        if (null == dycProCommPoolInfoDTO.getPoolId()) {
            throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1\u6c60ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)dycProCommPoolInfoDTO.getPoolName())) {
            throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1\u6c60\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == dycProCommPoolInfoDTO.getPoolRelated()) {
            throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1\u6c60\u5173\u8054\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CommPoolInfoPO poolInfoPO = (CommPoolInfoPO)this.commPoolInfoMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommPoolInfoPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()).eq(CommPoolInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO));
        if (null == poolInfoPO) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u4e0d\u5b58\u5728");
        }
        CommPoolInfoPO checkPo = (CommPoolInfoPO)this.commPoolInfoMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapperX().eq(CommPoolInfoPO::getPoolName, (Object)dycProCommPoolInfoDTO.getPoolName()).ne(CommPoolInfoPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId())).eq(CommPoolInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO));
        if (null != checkPo) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!dycProCommPoolInfoDTO.getPoolRelated().equals(poolInfoPO.getPoolRelated())) {
            this.commPoolCommodityRelMapper.delete((Wrapper)new LambdaQueryWrapperX().eq(CommPoolCommodityRelPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()));
            this.commPoolManageCatalogRelMapper.delete((Wrapper)new LambdaQueryWrapperX().eq(CommPoolManageCatalogRelPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()));
        }
        CommPoolInfoPO commPoolInfoPO = (CommPoolInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPoolInfoDTO), CommPoolInfoPO.class);
        this.commPoolInfoMapper.updateById((Object)commPoolInfoPO);
        if (!dycProCommPoolInfoDTO.getPoolRelated().equals(poolInfoPO.getPoolRelated())) {
            NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
            nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
            nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(false));
            nosqlUpdateArrayFieldReqBO.setArrayFieldName("poolList");
            nosqlUpdateArrayFieldReqBO.setIdFieldName("poolId");
            nosqlUpdateArrayFieldReqBO.setIdValue(dycProCommPoolInfoDTO.getPoolId().toString());
            nosqlUpdateArrayFieldReqBO.setMaps(null);
            ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
            List<NosqlQueryBO> nosqlQueryBOList = DycProCommPoolInfoRepositoryImpl.initNosqlQueryGroupList(nosqlQueryGroupBOList);
            NosqlQueryBO poolId = new NosqlQueryBO("poolList.poolId", dycProCommPoolInfoDTO.getPoolId().toString(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(poolId);
            NosqlBuilder nosqlBuilder = new NosqlBuilder();
            nosqlBuilder.setNosqlQueryGroupList(nosqlQueryGroupBOList);
            nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlBuilder);
            log.debug("\u7f16\u8f91\u5546\u54c1\u6c60\u53d8\u66f4\u5173\u8054\u65b9\u5f0f\u540c\u6b65nosql\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
            NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
            log.debug("\u7f16\u8f91\u5546\u54c1\u6c60\u53d8\u66f4\u5173\u8054\u65b9\u5f0f\u540c\u6b65nosql\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
        } else {
            if (null == poolInfoPO.getPoolLabel()) {
                poolInfoPO.setPoolLabel("");
            }
            if (null == dycProCommPoolInfoDTO.getPoolLabel()) {
                dycProCommPoolInfoDTO.setPoolLabel("");
            }
            if (!poolInfoPO.getPoolLabel().equals(dycProCommPoolInfoDTO.getPoolLabel())) {
                NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
                nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
                nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(false));
                nosqlUpdateArrayFieldReqBO.setArrayFieldName("poolList");
                nosqlUpdateArrayFieldReqBO.setIdFieldName("poolId");
                nosqlUpdateArrayFieldReqBO.setIdValue(dycProCommPoolInfoDTO.getPoolId().toString());
                HashMap<String, Object> maps = new HashMap<String, Object>();
                maps.put("poolId", poolInfoPO.getPoolId().toString());
                maps.put("poolLabel", commPoolInfoPO.getPoolLabel());
                maps.put("enableFlag", commPoolInfoPO.getEnableFlag());
                maps.put("poolRelated", commPoolInfoPO.getPoolRelated());
                nosqlUpdateArrayFieldReqBO.setMaps(maps);
                ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
                List<NosqlQueryBO> nosqlQueryBOList = DycProCommPoolInfoRepositoryImpl.initNosqlQueryGroupList(nosqlQueryGroupBOList);
                NosqlQueryBO poolId = new NosqlQueryBO("poolList.poolId", dycProCommPoolInfoDTO.getPoolId().toString(), NosqlQueryValueType.ACCURATE);
                nosqlQueryBOList.add(poolId);
                NosqlBuilder nosqlBuilder = new NosqlBuilder();
                nosqlBuilder.setNosqlQueryGroupList(nosqlQueryGroupBOList);
                nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlBuilder);
                log.debug("\u7f16\u8f91\u5546\u54c1\u6c60\u53d8\u66f4\u5173\u8054\u65b9\u5f0f\u540c\u6b65nosql\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
                NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
                log.debug("\u7f16\u8f91\u5546\u54c1\u6c60\u53d8\u66f4\u5173\u8054\u65b9\u5f0f\u540c\u6b65nosql\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
            }
        }
    }

    @Override
    public void createCommodityPool(DycProCommPoolInfoDTO dycProCommPoolInfoDTO) {
        if (StringUtils.isBlank((CharSequence)dycProCommPoolInfoDTO.getPoolName())) {
            throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1\u6c60\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == dycProCommPoolInfoDTO.getPoolRelated()) {
            throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1\u6c60\u5173\u8054\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == dycProCommPoolInfoDTO.getEnableFlag()) {
            throw new ZTBusinessException("\u5165\u53c2\u662f\u5426\u542f\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CommPoolInfoPO checkPo = (CommPoolInfoPO)this.commPoolInfoMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommPoolInfoPO::getPoolName, (Object)dycProCommPoolInfoDTO.getPoolName()).eq(CommPoolInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO));
        if (null != checkPo) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u540d\u79f0\u5df2\u5b58\u5728");
        }
        CommPoolInfoPO commPoolInfoPO = (CommPoolInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPoolInfoDTO), CommPoolInfoPO.class);
        commPoolInfoPO.setDelFlag(Integer.valueOf(Integer.parseInt(DelFlag.UN_DELETE.getCode())));
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("UCC");
        encodeSerialReqBO.setEncodeRuleCode("COMM_POOL_POOL_CODE");
        DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        commPoolInfoPO.setPoolCode((String)encode.getSerialNoList().get(0));
        this.commPoolInfoMapper.insert((Object)commPoolInfoPO);
    }

    @Override
    public DycProCommPoolInfoDTO qryCommodityPoolDetail(DycProCommPoolInfoDTO dycProCommPoolInfoDTO) {
        List commPoolCommodityRelPOS;
        List commPoolManageCatalogRelPOS;
        CommPoolInfoPO commPoolInfoPO = (CommPoolInfoPO)this.commPoolInfoMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommPoolInfoPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()).eq(CommPoolInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO));
        if (null == commPoolInfoPO) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u4e0d\u5b58\u5728");
        }
        dycProCommPoolInfoDTO = (DycProCommPoolInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)commPoolInfoPO), DycProCommPoolInfoDTO.class);
        Long relObjNum = 0L;
        if (DmcCommPoolInfoPoolRelated.SKU.getCode().equals(dycProCommPoolInfoDTO.getPoolRelated().toString())) {
            relObjNum = this.commPoolCommodityRelMapper.selectCount((Wrapper)new LambdaQueryWrapperX().eq(CommPoolCommodityRelPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()).eq(CommPoolCommodityRelPO::getObjType, (Object)DycProCommConstants.CommPoolCommodityRelObjType.SKU));
        }
        if (DmcCommPoolInfoPoolRelated.MANAGE_CATALOG.getCode().equals(dycProCommPoolInfoDTO.getPoolRelated().toString()) && !CollectionUtils.isEmpty((Collection)(commPoolManageCatalogRelPOS = this.commPoolManageCatalogRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommPoolManageCatalogRelPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()).eq(CommPoolManageCatalogRelPO::getLastLevelFlag, (Object)DycProCommConstants.YesOrNo.YES))))) {
            relObjNum = commPoolManageCatalogRelPOS.size();
        }
        if (DmcCommPoolInfoPoolRelated.AGR.getCode().equals(dycProCommPoolInfoDTO.getPoolRelated().toString()) && !CollectionUtils.isEmpty((Collection)(commPoolCommodityRelPOS = this.commPoolCommodityRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommPoolCommodityRelPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()).eq(CommPoolCommodityRelPO::getObjType, (Object)DycProCommConstants.CommPoolCommodityRelObjType.AGR))))) {
            relObjNum = commPoolCommodityRelPOS.size();
        }
        if (DmcCommPoolInfoPoolRelated.SUPPLIER.getCode().equals(dycProCommPoolInfoDTO.getPoolRelated().toString()) && !CollectionUtils.isEmpty((Collection)(commPoolCommodityRelPOS = this.commPoolCommodityRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommPoolCommodityRelPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()).eq(CommPoolCommodityRelPO::getObjType, (Object)DycProCommConstants.CommPoolCommodityRelObjType.SUPPLIER))))) {
            relObjNum = commPoolCommodityRelPOS.size();
        }
        dycProCommPoolInfoDTO.setRelObjNum(relObjNum);
        return dycProCommPoolInfoDTO;
    }

    @Override
    public void dealCommodityPoolRelation(List<DycProCommPoolCommodityRelDTO> dycProCommPoolCommodityRelDTOList) {
        Long poolId = dycProCommPoolCommodityRelDTOList.get(0).getPoolId();
        CommPoolInfoPO commPoolInfoPO = (CommPoolInfoPO)this.commPoolInfoMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommPoolInfoPO::getPoolId, (Object)poolId).eq(CommPoolInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO));
        if (null == commPoolInfoPO) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u4e0d\u5b58\u5728");
        }
        List commPoolCommodityRelPOList = JSON.parseArray((String)JSON.toJSONString(dycProCommPoolCommodityRelDTOList), CommPoolCommodityRelPO.class);
        this.commPoolCommodityRelMapper.insertBatch((Collection)commPoolCommodityRelPOList);
        Integer objType = dycProCommPoolCommodityRelDTOList.get(0).getObjType();
        List objIdList = dycProCommPoolCommodityRelDTOList.stream().map(o -> o.getObjId().toString()).collect(Collectors.toList());
        NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
        nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
        nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(false));
        nosqlUpdateArrayFieldReqBO.setArrayFieldName("poolList");
        nosqlUpdateArrayFieldReqBO.setIdFieldName("poolId");
        nosqlUpdateArrayFieldReqBO.setIdValue(poolId.toString());
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("poolId", poolId.toString());
        maps.put("poolLabel", commPoolInfoPO.getPoolLabel());
        maps.put("enableFlag", commPoolInfoPO.getEnableFlag());
        maps.put("poolRelated", commPoolInfoPO.getPoolRelated());
        nosqlUpdateArrayFieldReqBO.setMaps(maps);
        ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
        List<NosqlQueryBO> nosqlQueryBOList = DycProCommPoolInfoRepositoryImpl.initNosqlQueryGroupList(nosqlQueryGroupBOList);
        if (DycProCommConstants.CommPoolCommodityRelObjType.AGR.equals(objType)) {
            NosqlQueryBO agrIdNosql = new NosqlQueryBO("agrId", objIdList, NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(agrIdNosql);
        }
        if (DycProCommConstants.CommPoolCommodityRelObjType.SKU.equals(objType)) {
            NosqlQueryBO skuIdNosql = new NosqlQueryBO("skuId", objIdList, NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(skuIdNosql);
        }
        if (DycProCommConstants.CommPoolCommodityRelObjType.SUPPLIER.equals(objType)) {
            NosqlQueryBO supplierIdNosql = new NosqlQueryBO("supplierId", objIdList, NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(supplierIdNosql);
        }
        NosqlBuilder nosqlBuilder = new NosqlBuilder();
        nosqlBuilder.setNosqlQueryGroupList(nosqlQueryGroupBOList);
        nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlBuilder);
        log.debug("\u5546\u54c1\u6c60\u6dfb\u52a0\u5173\u8054\u5173\u7cfb\u540c\u6b65nosql\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
        NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
        log.debug("\u5546\u54c1\u6c60\u6dfb\u52a0\u5173\u8054\u5173\u7cfb\u540c\u6b65nosql\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
    }

    @Override
    public void dealCommodityPoolRelationRelieve(DycProCommPoolCommodityRelDTO dycProCommPoolCommodityRelDTO) {
        NosqlQueryBO skuIds;
        ArrayList<NosqlQueryBO> nosqlQueryBOS;
        NosqlQueryGroupBO queryGroupBO2;
        ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOS;
        NosqlQueryGroupBO subQueryGroupBO2;
        List skuRelList;
        CommPoolCommodityRelPO qryRelSkuPo;
        if (null == dycProCommPoolCommodityRelDTO.getPoolId()) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == dycProCommPoolCommodityRelDTO.getObjId()) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u5173\u8054\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CommPoolInfoPO commPoolInfoPO = (CommPoolInfoPO)this.commPoolInfoMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommPoolInfoPO::getPoolId, (Object)dycProCommPoolCommodityRelDTO.getPoolId()).eq(CommPoolInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO));
        if (null == commPoolInfoPO) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u4e0d\u5b58\u5728");
        }
        CommPoolCommodityRelPO commPoolCommodityRelPO = (CommPoolCommodityRelPO)this.commPoolCommodityRelMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommPoolCommodityRelPO::getPoolId, (Object)dycProCommPoolCommodityRelDTO.getPoolId()).eq(CommPoolCommodityRelPO::getObjId, (Object)dycProCommPoolCommodityRelDTO.getObjId()).eq(CommPoolCommodityRelPO::getObjType, (Object)dycProCommPoolCommodityRelDTO.getObjType()));
        if (null == commPoolCommodityRelPO) {
            throw new ZTBusinessException("\u5173\u8054\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        this.commPoolCommodityRelMapper.deleteById((Serializable)commPoolCommodityRelPO.getRelId());
        Integer objType = commPoolCommodityRelPO.getObjType();
        Long poolId = commPoolCommodityRelPO.getPoolId();
        Long objId = commPoolCommodityRelPO.getObjId();
        NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
        nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
        nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(false));
        nosqlUpdateArrayFieldReqBO.setArrayFieldName("poolList");
        nosqlUpdateArrayFieldReqBO.setIdFieldName("poolId");
        nosqlUpdateArrayFieldReqBO.setIdValue(poolId.toString());
        nosqlUpdateArrayFieldReqBO.setMaps(null);
        ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
        List<NosqlQueryBO> nosqlQueryBOList = DycProCommPoolInfoRepositoryImpl.initNosqlQueryGroupList(nosqlQueryGroupBOList);
        if (DycProCommConstants.CommPoolCommodityRelObjType.AGR.equals(objType)) {
            NosqlQueryBO agrIdNosql = new NosqlQueryBO("agrId", objId.toString(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(agrIdNosql);
            qryRelSkuPo = new CommPoolCommodityRelPO();
            qryRelSkuPo.setObjId(objId);
            qryRelSkuPo.setObjType(objType);
            qryRelSkuPo.setPoolId(poolId);
            skuRelList = this.commPoolCommodityRelMapper.qryPoolRelSkuList(qryRelSkuPo);
            if (!CollectionUtils.isEmpty((Collection)skuRelList)) {
                subQueryGroupBO2 = new NosqlQueryGroupBO();
                subQueryGroupBO2.setConnetType(NosqlConnetType.NOT);
                nosqlQueryGroupBOS = new ArrayList<NosqlQueryGroupBO>();
                nosqlQueryGroupBOS.add(subQueryGroupBO2);
                queryGroupBO2 = new NosqlQueryGroupBO(nosqlQueryGroupBOS, NosqlConnetType.AND);
                nosqlQueryGroupBOList.add(queryGroupBO2);
                nosqlQueryBOS = new ArrayList<NosqlQueryBO>();
                skuIds = new NosqlQueryBO("skuId", skuRelList.stream().map(o -> o.getObjId().toString()).collect(Collectors.toList()), NosqlQueryValueType.ACCURATE, NosqlConnetType.NOT);
                nosqlQueryBOS.add(skuIds);
                subQueryGroupBO2.setNosqlQueryList(nosqlQueryBOS);
            }
        }
        if (DycProCommConstants.CommPoolCommodityRelObjType.SUPPLIER.equals(objType)) {
            NosqlQueryBO supplierIdNosql = new NosqlQueryBO("supplierId", objId.toString(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(supplierIdNosql);
            qryRelSkuPo = new CommPoolCommodityRelPO();
            qryRelSkuPo.setObjId(objId);
            qryRelSkuPo.setObjType(objType);
            qryRelSkuPo.setPoolId(poolId);
            skuRelList = this.commPoolCommodityRelMapper.qryPoolRelSkuList(qryRelSkuPo);
            if (!CollectionUtils.isEmpty((Collection)skuRelList)) {
                subQueryGroupBO2 = new NosqlQueryGroupBO();
                subQueryGroupBO2.setConnetType(NosqlConnetType.NOT);
                nosqlQueryGroupBOS = new ArrayList();
                nosqlQueryGroupBOS.add(subQueryGroupBO2);
                queryGroupBO2 = new NosqlQueryGroupBO(nosqlQueryGroupBOS, NosqlConnetType.AND);
                nosqlQueryGroupBOList.add(queryGroupBO2);
                nosqlQueryBOS = new ArrayList();
                skuIds = new NosqlQueryBO("skuId", skuRelList.stream().map(o -> o.getObjId().toString()).collect(Collectors.toList()), NosqlQueryValueType.ACCURATE, NosqlConnetType.NOT);
                nosqlQueryBOS.add(skuIds);
                subQueryGroupBO2.setNosqlQueryList(nosqlQueryBOS);
            }
        }
        if (DycProCommConstants.CommPoolCommodityRelObjType.SKU.equals(objType)) {
            CommSkuInfoPO commSkuInfoPO = (CommSkuInfoPO)this.commSkuInfoMapper.selectById((Serializable)objId);
            if (null != commSkuInfoPO) {
                CommPropertyTemplateInfoPO commPropertyTemplateInfoPO;
                List commPoolManageCatalogRelPOS;
                Integer relObjType = null;
                Long relObjId = null;
                if (DycProCommConstants.CommPoolInfoPoolRelated.SUPPLIER.equals(commPoolInfoPO.getPoolRelated()) || DycProCommConstants.CommPoolInfoPoolRelated.AGR.equals(commPoolInfoPO.getPoolRelated())) {
                    List objRelList;
                    if (DycProCommConstants.CommPoolInfoPoolRelated.SUPPLIER.equals(commPoolInfoPO.getPoolRelated())) {
                        relObjType = DycProCommConstants.CommPoolCommodityRelObjType.SUPPLIER;
                        relObjId = commSkuInfoPO.getSupplierId();
                    }
                    if (DycProCommConstants.CommPoolInfoPoolRelated.AGR.equals(commPoolInfoPO.getPoolRelated())) {
                        relObjType = DycProCommConstants.CommPoolCommodityRelObjType.AGR;
                        relObjId = commSkuInfoPO.getAgrId();
                    }
                    if (!CollectionUtils.isEmpty((Collection)(objRelList = this.commPoolCommodityRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommPoolCommodityRelPO::getPoolId, (Object)poolId).eq(CommPoolCommodityRelPO::getObjId, (Object)relObjId).eq(CommPoolCommodityRelPO::getObjType, (Object)relObjType))))) {
                        return;
                    }
                }
                if (DycProCommConstants.CommPoolInfoPoolRelated.MANAGE_CATALOG.equals(commPoolInfoPO.getPoolRelated()) && !CollectionUtils.isEmpty((Collection)(commPoolManageCatalogRelPOS = this.commPoolManageCatalogRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommPoolManageCatalogRelPO::getManageCatalogId, (Object)(commPropertyTemplateInfoPO = (CommPropertyTemplateInfoPO)this.commPropertyTemplateInfoMapper.selectById((Serializable)commSkuInfoPO.getPropertyTemplateId())).getManageCatalogId()).eq(CommPoolManageCatalogRelPO::getPoolId, (Object)poolId))))) {
                    return;
                }
            }
            NosqlQueryBO skuIdNosql = new NosqlQueryBO("skuId", objId.toString(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(skuIdNosql);
        }
        NosqlBuilder nosqlBuilder = new NosqlBuilder();
        nosqlBuilder.setNosqlQueryGroupList(nosqlQueryGroupBOList);
        nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlBuilder);
        log.debug("\u5546\u54c1\u6c60\u89e3\u9664\u5173\u8054\u5173\u7cfb\u540c\u6b65nosql\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
        NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
        log.debug("\u5546\u54c1\u6c60\u89e3\u9664\u5173\u8054\u5173\u7cfb\u540c\u6b65nosql\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
    }

    @Override
    public void dealCommodityPoolManageCatalogRel(DycProCommPoolInfoDTO dycProCommPoolInfoDTO) {
        CommPoolInfoPO commPoolInfoPO = (CommPoolInfoPO)this.commPoolInfoMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommPoolInfoPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()).eq(CommPoolInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO));
        if (null == commPoolInfoPO) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u4e0d\u5b58\u5728");
        }
        List<DycProCommPoolManageCatalogRelDTO> dycProCommPoolManageCatalogRelDTOList = dycProCommPoolInfoDTO.getDycProCommPoolManageCatalogRelDTOList();
        if (CollectionUtils.isEmpty(dycProCommPoolManageCatalogRelDTOList)) {
            this.commPoolManageCatalogRelMapper.delete((Wrapper)new LambdaQueryWrapperX().eq(CommPoolManageCatalogRelPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()));
            NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
            nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
            nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(false));
            nosqlUpdateArrayFieldReqBO.setArrayFieldName("poolList");
            nosqlUpdateArrayFieldReqBO.setIdFieldName("poolId");
            nosqlUpdateArrayFieldReqBO.setIdValue(dycProCommPoolInfoDTO.getPoolId().toString());
            nosqlUpdateArrayFieldReqBO.setMaps(null);
            ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
            List<NosqlQueryBO> nosqlQueryBOList = DycProCommPoolInfoRepositoryImpl.initNosqlQueryGroupList(nosqlQueryGroupBOList);
            List lastCatalogIdList = dycProCommPoolInfoDTO.getDycProCommPoolManageCatalogRelDTOList().stream().filter(o -> DycProCommConstants.YesOrNo.YES.equals(o.getLastLevelFlag())).map(o -> o.getManageCatalogId().toString()).collect(Collectors.toList());
            NosqlQueryBO agrIdNosql = new NosqlQueryBO("manageCatalogList.manageCatalogId", lastCatalogIdList, NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(agrIdNosql);
            List commPoolCommodityRelPOS = this.commPoolCommodityRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommPoolCommodityRelPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()).eq(CommPoolCommodityRelPO::getObjType, (Object)DycProCommConstants.CommPoolCommodityRelObjType.SKU));
            if (!CollectionUtils.isEmpty((Collection)commPoolCommodityRelPOS)) {
                NosqlQueryGroupBO subQueryGroupBO2 = new NosqlQueryGroupBO();
                subQueryGroupBO2.setConnetType(NosqlConnetType.NOT);
                ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOS = new ArrayList<NosqlQueryGroupBO>();
                nosqlQueryGroupBOS.add(subQueryGroupBO2);
                NosqlQueryGroupBO queryGroupBO2 = new NosqlQueryGroupBO(nosqlQueryGroupBOS, NosqlConnetType.AND);
                nosqlQueryGroupBOList.add(queryGroupBO2);
                ArrayList<NosqlQueryBO> nosqlQueryBOS = new ArrayList<NosqlQueryBO>();
                NosqlQueryBO skuIds = new NosqlQueryBO("skuId", commPoolCommodityRelPOS.stream().map(o -> o.getObjId().toString()).collect(Collectors.toList()), NosqlQueryValueType.ACCURATE, NosqlConnetType.NOT);
                nosqlQueryBOS.add(skuIds);
                subQueryGroupBO2.setNosqlQueryList(nosqlQueryBOS);
            }
            NosqlBuilder nosqlBuilder = new NosqlBuilder();
            nosqlBuilder.setNosqlQueryGroupList(nosqlQueryGroupBOList);
            nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlBuilder);
            log.debug("\u5546\u54c1\u6c60\u5220\u9664\u7c7b\u76ee\u5173\u8054\u5173\u7cfb\u540c\u6b65nosql\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
            NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
            log.debug("\u5546\u54c1\u6c60\u5220\u9664\u7c7b\u76ee\u5173\u8054\u5173\u7cfb\u540c\u6b65nosql\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
        } else {
            List commPoolManageCatalogRelPOS = this.commPoolManageCatalogRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommPoolManageCatalogRelPO::getPoolId, (Object)dycProCommPoolManageCatalogRelDTOList.get(0).getPoolId()));
            if (CollectionUtils.isEmpty((Collection)commPoolManageCatalogRelPOS)) {
                this.commPoolManageCatalogRelMapper.insertBatch((Collection)JSON.parseArray((String)JSON.toJSONString(dycProCommPoolManageCatalogRelDTOList), CommPoolManageCatalogRelPO.class));
                List lastManageCatalogIdList = dycProCommPoolManageCatalogRelDTOList.stream().filter(o -> DycProCommConstants.YesOrNo.YES.equals(o.getLastLevelFlag())).map(o -> o.getManageCatalogId().toString()).collect(Collectors.toList());
                NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
                nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
                nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(false));
                nosqlUpdateArrayFieldReqBO.setArrayFieldName("poolList");
                nosqlUpdateArrayFieldReqBO.setIdFieldName("poolId");
                nosqlUpdateArrayFieldReqBO.setIdValue(dycProCommPoolInfoDTO.getPoolId().toString());
                HashMap<String, Object> maps = new HashMap<String, Object>();
                maps.put("poolId", commPoolInfoPO.getPoolId().toString());
                maps.put("poolLabel", commPoolInfoPO.getPoolLabel());
                maps.put("enableFlag", commPoolInfoPO.getEnableFlag());
                maps.put("poolRelated", commPoolInfoPO.getPoolRelated());
                nosqlUpdateArrayFieldReqBO.setMaps(maps);
                ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
                List<NosqlQueryBO> nosqlQueryBOList = DycProCommPoolInfoRepositoryImpl.initNosqlQueryGroupList(nosqlQueryGroupBOList);
                NosqlQueryBO agrIdNosql = new NosqlQueryBO("manageCatalogList.manageCatalogId", lastManageCatalogIdList, NosqlQueryValueType.ACCURATE);
                nosqlQueryBOList.add(agrIdNosql);
                NosqlBuilder nosqlBuilder = new NosqlBuilder();
                nosqlBuilder.setNosqlQueryGroupList(nosqlQueryGroupBOList);
                nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlBuilder);
                log.debug("\u5546\u54c1\u6c60\u65b0\u589e\u7c7b\u76ee\u5173\u8054\u5173\u7cfb\u540c\u6b65nosql\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
                NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
                log.debug("\u5546\u54c1\u6c60\u65b0\u589e\u7c7b\u76ee\u5173\u8054\u5173\u7cfb\u540c\u6b65nosql\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
            } else {
                NosqlUpdateArrayFieldRsqBO nosqlUpdateArrayFieldRsqBO;
                NosqlBuilder nosqlBuilder;
                NosqlUpdateArrayFieldReqBO nosqlUpdateArrayFieldReqBO;
                List lastManageCatalogIdList;
                List moreRelIds;
                List moreQryManageCatalogLists;
                List reqManageCatalogIds = dycProCommPoolManageCatalogRelDTOList.stream().map(DycProCommPoolManageCatalogRelDTO::getManageCatalogId).collect(Collectors.toList());
                List qryManageCatalogIds = commPoolManageCatalogRelPOS.stream().map(CommPoolManageCatalogRelPO::getManageCatalogId).collect(Collectors.toList());
                List moreReqManageCatalogRelDtoList = dycProCommPoolManageCatalogRelDTOList.stream().filter(o -> !qryManageCatalogIds.contains(o.getManageCatalogId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(moreReqManageCatalogRelDtoList)) {
                    this.commPoolManageCatalogRelMapper.insertBatch((Collection)JSON.parseArray((String)JSON.toJSONString(moreReqManageCatalogRelDtoList), CommPoolManageCatalogRelPO.class));
                }
                if (!CollectionUtils.isEmpty(moreQryManageCatalogLists = commPoolManageCatalogRelPOS.stream().filter(o -> !reqManageCatalogIds.contains(o.getManageCatalogId())).collect(Collectors.toList())) && !CollectionUtils.isEmpty(moreRelIds = moreQryManageCatalogLists.stream().map(CommPoolManageCatalogRelPO::getRelId).collect(Collectors.toList()))) {
                    this.commPoolManageCatalogRelMapper.deleteBatchIds(moreRelIds);
                }
                if (!CollectionUtils.isEmpty(moreReqManageCatalogRelDtoList)) {
                    lastManageCatalogIdList = moreReqManageCatalogRelDtoList.stream().filter(o -> DycProCommConstants.YesOrNo.YES.equals(o.getLastLevelFlag())).map(o -> o.getManageCatalogId().toString()).collect(Collectors.toList());
                    nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
                    nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
                    nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(false));
                    nosqlUpdateArrayFieldReqBO.setArrayFieldName("poolList");
                    nosqlUpdateArrayFieldReqBO.setIdFieldName("poolId");
                    nosqlUpdateArrayFieldReqBO.setIdValue(dycProCommPoolInfoDTO.getPoolId().toString());
                    HashMap<String, Object> maps = new HashMap<String, Object>();
                    maps.put("poolId", commPoolInfoPO.getPoolId().toString());
                    maps.put("poolLabel", commPoolInfoPO.getPoolLabel());
                    maps.put("enableFlag", commPoolInfoPO.getEnableFlag());
                    maps.put("poolRelated", commPoolInfoPO.getPoolRelated());
                    nosqlUpdateArrayFieldReqBO.setMaps(maps);
                    ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
                    List<NosqlQueryBO> nosqlQueryBOList = DycProCommPoolInfoRepositoryImpl.initNosqlQueryGroupList(nosqlQueryGroupBOList);
                    NosqlQueryBO agrIdNosql = new NosqlQueryBO("manageCatalogList.manageCatalogId", lastManageCatalogIdList, NosqlQueryValueType.ACCURATE);
                    nosqlQueryBOList.add(agrIdNosql);
                    nosqlBuilder = new NosqlBuilder();
                    nosqlBuilder.setNosqlQueryGroupList(nosqlQueryGroupBOList);
                    nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlBuilder);
                    log.debug("\u5546\u54c1\u6c60\u65b0\u589e\u7c7b\u76ee\u5173\u8054\u5173\u7cfb\u540c\u6b65nosql\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
                    nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
                    log.debug("\u5546\u54c1\u6c60\u65b0\u589e\u7c7b\u76ee\u5173\u8054\u5173\u7cfb\u540c\u6b65nosql\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
                }
                if (!CollectionUtils.isEmpty(moreQryManageCatalogLists)) {
                    lastManageCatalogIdList = moreQryManageCatalogLists.stream().filter(o -> DycProCommConstants.YesOrNo.YES.equals(o.getLastLevelFlag())).map(o -> o.getManageCatalogId().toString()).collect(Collectors.toList());
                    nosqlUpdateArrayFieldReqBO = new NosqlUpdateArrayFieldReqBO();
                    nosqlUpdateArrayFieldReqBO.setIndex(this.skuIndexName);
                    nosqlUpdateArrayFieldReqBO.setIsSynch(Boolean.valueOf(false));
                    nosqlUpdateArrayFieldReqBO.setArrayFieldName("poolList");
                    nosqlUpdateArrayFieldReqBO.setIdFieldName("poolId");
                    nosqlUpdateArrayFieldReqBO.setIdValue(dycProCommPoolInfoDTO.getPoolId().toString());
                    nosqlUpdateArrayFieldReqBO.setMaps(null);
                    ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
                    List<NosqlQueryBO> nosqlQueryBOList = DycProCommPoolInfoRepositoryImpl.initNosqlQueryGroupList(nosqlQueryGroupBOList);
                    NosqlQueryBO agrIdNosql = new NosqlQueryBO("manageCatalogList.manageCatalogId", lastManageCatalogIdList, NosqlQueryValueType.ACCURATE);
                    nosqlQueryBOList.add(agrIdNosql);
                    List commPoolCommodityRelPOS = this.commPoolCommodityRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommPoolCommodityRelPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()).eq(CommPoolCommodityRelPO::getObjType, (Object)DycProCommConstants.CommPoolCommodityRelObjType.SKU));
                    if (!CollectionUtils.isEmpty((Collection)commPoolCommodityRelPOS)) {
                        NosqlQueryGroupBO subQueryGroupBO2 = new NosqlQueryGroupBO();
                        subQueryGroupBO2.setConnetType(NosqlConnetType.NOT);
                        ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOS = new ArrayList<NosqlQueryGroupBO>();
                        nosqlQueryGroupBOS.add(subQueryGroupBO2);
                        NosqlQueryGroupBO queryGroupBO2 = new NosqlQueryGroupBO(nosqlQueryGroupBOS, NosqlConnetType.AND);
                        nosqlQueryGroupBOList.add(queryGroupBO2);
                        ArrayList<NosqlQueryBO> nosqlQueryBOS = new ArrayList<NosqlQueryBO>();
                        NosqlQueryBO skuIds = new NosqlQueryBO("skuId", commPoolCommodityRelPOS.stream().map(o -> o.getObjId().toString()).collect(Collectors.toList()), NosqlQueryValueType.ACCURATE, NosqlConnetType.NOT);
                        nosqlQueryBOS.add(skuIds);
                        subQueryGroupBO2.setNosqlQueryList(nosqlQueryBOS);
                    }
                    nosqlBuilder = new NosqlBuilder();
                    nosqlBuilder.setNosqlQueryGroupList(nosqlQueryGroupBOList);
                    nosqlUpdateArrayFieldReqBO.setNosqlBuilder(nosqlBuilder);
                    log.debug("\u5546\u54c1\u6c60\u5220\u9664\u7c7b\u76ee\u5173\u8054\u5173\u7cfb\u540c\u6b65nosql\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldReqBO));
                    nosqlUpdateArrayFieldRsqBO = this.nosqlClient.updateArrayField(nosqlUpdateArrayFieldReqBO);
                    log.debug("\u5546\u54c1\u6c60\u5220\u9664\u7c7b\u76ee\u5173\u8054\u5173\u7cfb\u540c\u6b65nosql\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlUpdateArrayFieldRsqBO));
                }
            }
        }
    }

    @Override
    public List<DycProCommPoolManageCatalogRelDTO> qryCommodityPoolRelationCatalogTree(DycProCommPoolInfoDTO dycProCommPoolInfoDTO) {
        List commPoolManageCatalogRelPOS = this.commPoolManageCatalogRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommPoolManageCatalogRelPO::getPoolId, (Object)dycProCommPoolInfoDTO.getPoolId()));
        if (CollectionUtils.isEmpty((Collection)commPoolManageCatalogRelPOS)) {
            return new ArrayList<DycProCommPoolManageCatalogRelDTO>();
        }
        List dycProCommPoolManageCatalogRelDTOS = JSON.parseArray((String)JSON.toJSONString((Object)commPoolManageCatalogRelPOS), DycProCommPoolManageCatalogRelDTO.class);
        List manageCatalogIds = dycProCommPoolManageCatalogRelDTOS.stream().map(DycProCommPoolManageCatalogRelDTO::getManageCatalogId).collect(Collectors.toList());
        List commManageCatalogInfoPOS = this.commManageCatalogInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().in(CommManageCatalogInfoPO::getManageCatalogId, manageCatalogIds).eq(CommManageCatalogInfoPO::getEnableFlag, (Object)DycProCommConstants.YesOrNo.YES).eq(CommManageCatalogInfoPO::getDelFlag, (Object)Integer.parseInt(DelFlag.UN_DELETE.getCode())));
        if (CollectionUtils.isEmpty((Collection)commManageCatalogInfoPOS)) {
            return new ArrayList<DycProCommPoolManageCatalogRelDTO>();
        }
        Map<Long, String> manageCatalogNameMap = commManageCatalogInfoPOS.stream().collect(Collectors.toMap(CommManageCatalogInfoPO::getManageCatalogId, CommManageCatalogInfoPO::getManageCatalogName));
        return dycProCommPoolManageCatalogRelDTOS.stream().filter(o -> manageCatalogNameMap.containsKey(o.getManageCatalogId())).peek(o -> o.setManageCatalogName((String)manageCatalogNameMap.get(o.getManageCatalogId()))).collect(Collectors.toList());
    }

    @Override
    public DycProBaseManagePageRspBO<DycProCommPoolManageCatalogRelDTO> qryCommodityPoolRelationCatalogListPage(DycProCommPoolQryDTO dycProCommPoolQryDTO) {
        DycProBaseManagePageRspBO baseManagePageRspBO = new DycProBaseManagePageRspBO();
        Page page = new Page((long)dycProCommPoolQryDTO.getPageNo().intValue(), (long)dycProCommPoolQryDTO.getPageSize().intValue());
        page.setOptimizeCountSql(false);
        CommPoolManageCatalogRelExtPO commPoolManageCatalogRelExtPO = new CommPoolManageCatalogRelExtPO();
        commPoolManageCatalogRelExtPO.setPoolId(dycProCommPoolQryDTO.getPoolId());
        commPoolManageCatalogRelExtPO.setManageCatalogId(dycProCommPoolQryDTO.getManageCatalogId());
        page = this.commPoolManageCatalogRelMapper.qryRelPoolManageCatalogListPage(commPoolManageCatalogRelExtPO, page);
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return baseManagePageRspBO;
        }
        baseManagePageRspBO.setRows(JSON.parseArray((String)JSON.toJSONString((Object)page.getRecords()), DycProCommPoolManageCatalogRelDTO.class));
        baseManagePageRspBO.setPageNo((int)page.getCurrent());
        baseManagePageRspBO.setTotal((int)page.getPages());
        baseManagePageRspBO.setRecordsTotal((int)page.getTotal());
        if (!CollectionUtils.isEmpty((Collection)baseManagePageRspBO.getRows())) {
            List propertyTemplateIds;
            List skuCountList;
            List<Object> manageCatalogIds;
            List manageCatalogPaths = baseManagePageRspBO.getRows().stream().map(DycProCommPoolManageCatalogRelDTO::getManageCatalogPath).collect(Collectors.toList());
            Map<Object, Object> catalogNameMap = new HashMap();
            if (!CollectionUtils.isEmpty(manageCatalogPaths)) {
                manageCatalogIds = new ArrayList();
                for (String manageCatalogPath : manageCatalogPaths) {
                    for (String s : manageCatalogPath.split("-")) {
                        manageCatalogIds.add(Long.parseLong(s));
                    }
                }
                List commManageCatalogInfoPOS = this.commManageCatalogInfoMapper.selectBatchIds((Collection)manageCatalogIds.stream().distinct().collect(Collectors.toList()));
                if (!CollectionUtils.isEmpty((Collection)commManageCatalogInfoPOS)) {
                    catalogNameMap = commManageCatalogInfoPOS.stream().collect(Collectors.toMap(CommManageCatalogInfoPO::getManageCatalogId, CommManageCatalogInfoPO::getManageCatalogName));
                }
            }
            manageCatalogIds = baseManagePageRspBO.getRows().stream().map(DycProCommPoolManageCatalogRelDTO::getManageCatalogId).collect(Collectors.toList());
            List commPropertyTemplateInfoPOS = this.commPropertyTemplateInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().in(CommPropertyTemplateInfoPO::getManageCatalogId, manageCatalogIds));
            Map<Object, Object> skuCountMap = new HashMap();
            Map<Object, Object> templateCatalogMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)commPropertyTemplateInfoPOS) && !CollectionUtils.isEmpty((Collection)(skuCountList = this.commSkuInfoMapper.getSkuCountByManageCatalogIds(propertyTemplateIds = commPropertyTemplateInfoPOS.stream().map(CommPropertyTemplateInfoPO::getPropertyTemplateId).collect(Collectors.toList()))))) {
                skuCountMap = skuCountList.stream().collect(Collectors.toMap(CommSkuInfoPO::getPropertyTemplateId, CommSkuInfoAggPO::getSkuCount, (o1, o2) -> o1));
                templateCatalogMap = commPropertyTemplateInfoPOS.stream().collect(Collectors.toMap(CommPropertyTemplateInfoPO::getManageCatalogId, CommPropertyTemplateInfoPO::getPropertyTemplateId, (o1, o2) -> o1));
            }
            for (DycProCommPoolManageCatalogRelDTO row : baseManagePageRspBO.getRows()) {
                Long propertyTemplateId = (Long)templateCatalogMap.get(row.getManageCatalogId());
                if (null != propertyTemplateId) {
                    row.setRelSkuNum((Long)skuCountMap.get(propertyTemplateId));
                }
                if (StringUtils.isBlank((CharSequence)row.getManageCatalogPath())) continue;
                ArrayList<Object> pathNames = new ArrayList<Object>();
                for (String s : row.getManageCatalogPath().split("-")) {
                    pathNames.add(catalogNameMap.get(Long.parseLong(s)));
                }
                row.setManageCatalogPathName(String.join((CharSequence)"/", pathNames));
            }
        }
        return baseManagePageRspBO;
    }

    @Override
    public List<DycProCommPoolQryDTO> qryCommodityPoolRelationSupplier(DycProCommPoolCommodityRelDTO dto) {
        List commPoolCommodityRelPOS = this.commPoolCommodityRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommPoolCommodityRelPO::getPoolId, (Object)dto.getPoolId()).eq(CommPoolCommodityRelPO::getObjType, (Object)DycProCommConstants.CommPoolCommodityRelObjType.SUPPLIER));
        if (CollectionUtils.isEmpty((Collection)commPoolCommodityRelPOS)) {
            return new ArrayList<DycProCommPoolQryDTO>();
        }
        ArrayList<DycProCommPoolQryDTO> dycProCommPoolQryDTOS = new ArrayList<DycProCommPoolQryDTO>();
        Map<Object, Object> skuCountMap = new HashMap();
        List skuCountBySupplierIds = this.commSkuInfoMapper.getSkuCountBySupplierIds(commPoolCommodityRelPOS.stream().map(CommPoolCommodityRelPO::getObjId).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty((Collection)skuCountBySupplierIds)) {
            skuCountMap = skuCountBySupplierIds.stream().collect(Collectors.toMap(CommSkuInfoPO::getSupplierId, CommSkuInfoAggPO::getSkuCount));
        }
        for (CommPoolCommodityRelPO commPoolCommodityRelPO : commPoolCommodityRelPOS) {
            DycProCommPoolQryDTO dycProCommPoolQryDTO = new DycProCommPoolQryDTO();
            dycProCommPoolQryDTO.setSupplierId(commPoolCommodityRelPO.getObjId());
            dycProCommPoolQryDTO.setPoolId(commPoolCommodityRelPO.getPoolId());
            dycProCommPoolQryDTO.setRelSkuNum((Long)skuCountMap.get(commPoolCommodityRelPO.getObjId()));
            dycProCommPoolQryDTOS.add(dycProCommPoolQryDTO);
        }
        return dycProCommPoolQryDTOS;
    }

    @Override
    public DycProBaseManagePageRspBO<DycProCommPoolQryDTO> qryPoolRelationAgreementQryListPage(DycProCommPoolQryDTO reqDTO) {
        List skuCountByAgrIds;
        DycProBaseManagePageRspBO rspDTO = new DycProBaseManagePageRspBO();
        if (DycProCommConstants.CommPoolRelObjQryFlag.LINKED.equals(reqDTO.getQryFlag())) {
            Page page = new Page((long)reqDTO.getPageNo().intValue(), (long)reqDTO.getPageSize().intValue());
            page.setOptimizeCountSql(false);
            page = this.commPoolCommodityRelMapper.qryPoolRelationAgrListPage((CommPoolCommodityRelExtPO)JSON.parseObject((String)JSON.toJSONString((Object)reqDTO), CommPoolCommodityRelExtPO.class), page);
            if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
                rspDTO.setPageNo(1);
                rspDTO.setRecordsTotal(0);
                rspDTO.setTotal(0);
                return rspDTO;
            }
            rspDTO.setPageNo(reqDTO.getPageNo().intValue());
            rspDTO.setTotal((int)page.getPages());
            rspDTO.setRecordsTotal((int)page.getTotal());
            List dycProCommPoolQryDTOS = JSON.parseArray((String)JSON.toJSONString((Object)page.getRecords()), DycProCommPoolQryDTO.class);
            rspDTO.setRows(dycProCommPoolQryDTOS);
        }
        if (DycProCommConstants.CommPoolRelObjQryFlag.TO_LINKED.equals(reqDTO.getQryFlag())) {
            CommPoolCommodityRelExtPO commPoolCommodityRelExtPO = (CommPoolCommodityRelExtPO)JSON.parseObject((String)JSON.toJSONString((Object)reqDTO), CommPoolCommodityRelExtPO.class);
            List commPoolCommodityRelPOS = this.commPoolCommodityRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommPoolCommodityRelPO::getPoolId, (Object)reqDTO.getPoolId()).eq(CommPoolCommodityRelPO::getObjType, (Object)DycProCommConstants.CommPoolCommodityRelObjType.AGR));
            if (!CollectionUtils.isEmpty((Collection)commPoolCommodityRelPOS)) {
                commPoolCommodityRelExtPO.setAgrIds(commPoolCommodityRelPOS.stream().map(CommPoolCommodityRelPO::getObjId).collect(Collectors.toList()));
            }
            Page page = new Page((long)reqDTO.getPageNo().intValue(), (long)reqDTO.getPageSize().intValue());
            page.setOptimizeCountSql(false);
            page = this.commPoolCommodityRelMapper.qryPoolToRelationAgrListPage(commPoolCommodityRelExtPO, page);
            if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
                rspDTO.setPageNo(1);
                rspDTO.setRecordsTotal(0);
                rspDTO.setTotal(0);
                return rspDTO;
            }
            rspDTO.setPageNo(reqDTO.getPageNo().intValue());
            rspDTO.setTotal((int)page.getPages());
            rspDTO.setRecordsTotal((int)page.getTotal());
            List dycProCommPoolQryDTOS = JSON.parseArray((String)JSON.toJSONString((Object)page.getRecords()), DycProCommPoolQryDTO.class);
            rspDTO.setRows(dycProCommPoolQryDTOS);
        }
        if (!CollectionUtils.isEmpty((Collection)rspDTO.getRows()) && !CollectionUtils.isEmpty((Collection)(skuCountByAgrIds = this.commSkuInfoMapper.getSkuCountByAgrIds(rspDTO.getRows().stream().map(DycProCommPoolQryDTO::getAgrId).collect(Collectors.toList()))))) {
            Map<Long, Long> skuCountMap = skuCountByAgrIds.stream().collect(Collectors.toMap(CommSkuInfoPO::getAgrId, CommSkuInfoAggPO::getSkuCount));
            for (DycProCommPoolQryDTO row : rspDTO.getRows()) {
                row.setRelSkuNum(skuCountMap.get(row.getAgrId()));
            }
        }
        return rspDTO;
    }

    @Override
    public DycProBaseManagePageRspBO<DycProCommPoolQryDTO> qryListPoolRelationSku(DycProCommPoolQryDTO reqDTO) {
        List skuIds;
        List commPoolCommodityRelPOS;
        CommPoolInfoPO commPoolInfoPO = (CommPoolInfoPO)this.commPoolInfoMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommPoolInfoPO::getPoolId, (Object)reqDTO.getPoolId()).eq(CommPoolInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO));
        if (null == commPoolInfoPO) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u4e0d\u5b58\u5728");
        }
        DycProBaseManagePageRspBO rspDTO = new DycProBaseManagePageRspBO();
        CommPoolCommodityRelExtPO commPoolCommodityRelExtPO = (CommPoolCommodityRelExtPO)JSON.parseObject((String)JSON.toJSONString((Object)reqDTO), CommPoolCommodityRelExtPO.class);
        Page page = new Page((long)reqDTO.getPageNo().intValue(), (long)reqDTO.getPageSize().intValue());
        page.setOptimizeCountSql(false);
        if (DycProCommConstants.CommPoolInfoPoolRelated.MANAGE_CATALOG.equals(commPoolInfoPO.getPoolRelated())) {
            page = this.commPoolCommodityRelMapper.qryPoolRelationManageCatalogSkuListPage(commPoolCommodityRelExtPO, page);
        } else {
            if (DycProCommConstants.CommPoolInfoPoolRelated.AGR.equals(commPoolInfoPO.getPoolRelated())) {
                commPoolCommodityRelExtPO.setObjType(DycProCommConstants.CommPoolCommodityRelObjType.AGR);
            }
            if (DycProCommConstants.CommPoolInfoPoolRelated.SUPPLIER.equals(commPoolInfoPO.getPoolRelated())) {
                commPoolCommodityRelExtPO.setObjType(DycProCommConstants.CommPoolCommodityRelObjType.SUPPLIER);
            }
            if (DycProCommConstants.CommPoolRelObjQryFlag.TO_LINKED.equals(reqDTO.getQryFlag())) {
                page = this.commPoolCommodityRelMapper.qryPoolToRelationSkuListPage(commPoolCommodityRelExtPO, page);
            }
            if (DycProCommConstants.CommPoolRelObjQryFlag.LINKED.equals(reqDTO.getQryFlag())) {
                page = this.commPoolCommodityRelMapper.qryPoolRelationSkuListPage(commPoolCommodityRelExtPO, page);
            }
        }
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            rspDTO.setPageNo(1);
            rspDTO.setRecordsTotal(0);
            rspDTO.setTotal(0);
            return rspDTO;
        }
        rspDTO.setPageNo(reqDTO.getPageNo().intValue());
        rspDTO.setTotal((int)page.getPages());
        rspDTO.setRecordsTotal((int)page.getTotal());
        List dycProCommPoolQryDTOS = JSON.parseArray((String)JSON.toJSONString((Object)page.getRecords()), DycProCommPoolQryDTO.class);
        Map<Object, Object> catalogNameMap = new HashMap();
        List manageCatalogPathList = dycProCommPoolQryDTOS.stream().map(DycProCommPoolQryDTO::getManageCatalogPath).filter(s -> !StringUtils.isBlank((CharSequence)s)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(manageCatalogPathList)) {
            ArrayList<Long> manageCatalogIds = new ArrayList<Long>();
            for (String manageCatalogPath : manageCatalogPathList) {
                for (String s2 : manageCatalogPath.split("-")) {
                    manageCatalogIds.add(Long.parseLong(s2));
                }
            }
            List commManageCatalogInfoPOS = this.commManageCatalogInfoMapper.selectBatchIds((Collection)manageCatalogIds.stream().distinct().collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty((Collection)commManageCatalogInfoPOS)) {
                catalogNameMap = commManageCatalogInfoPOS.stream().collect(Collectors.toMap(CommManageCatalogInfoPO::getManageCatalogId, CommManageCatalogInfoPO::getManageCatalogName));
            }
        }
        if (DycProCommConstants.CommPoolRelObjQryFlag.LINKED.equals(reqDTO.getQryFlag()) && DycProCommConstants.CommPoolInfoPoolRelated.MANAGE_CATALOG.equals(commPoolInfoPO.getPoolRelated()) && !CollectionUtils.isEmpty((Collection)(commPoolCommodityRelPOS = this.commPoolCommodityRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().in(CommPoolCommodityRelPO::getObjId, skuIds = dycProCommPoolQryDTOS.stream().map(DycProCommPoolQryDTO::getSkuId).collect(Collectors.toList())).eq(CommPoolCommodityRelPO::getObjType, (Object)DycProCommConstants.CommPoolCommodityRelObjType.SKU))))) {
            Map<Long, Integer> objTypeMap = commPoolCommodityRelPOS.stream().collect(Collectors.toMap(CommPoolCommodityRelPO::getObjId, CommPoolCommodityRelPO::getObjType, (o1, o2) -> o1));
            for (DycProCommPoolQryDTO dycProCommPoolQryDTO : dycProCommPoolQryDTOS) {
                dycProCommPoolQryDTO.setObjType(objTypeMap.get(dycProCommPoolQryDTO.getSkuId()));
            }
        }
        for (DycProCommPoolQryDTO row : dycProCommPoolQryDTOS) {
            if (!StringUtils.isBlank((CharSequence)row.getManageCatalogPath())) {
                ArrayList<Object> pathNames = new ArrayList<Object>();
                for (String s2 : row.getManageCatalogPath().split("-")) {
                    pathNames.add(catalogNameMap.get(Long.parseLong(s2)));
                }
                row.setManageCatalogPathName(String.join((CharSequence)"/", pathNames));
            }
            if (!DycProCommConstants.CommPoolRelObjQryFlag.LINKED.equals(reqDTO.getQryFlag()) || !DycProCommConstants.CommPoolCommodityRelObjType.SKU.equals(row.getObjType())) continue;
            row.setPoolSkuRelated(DycProCommConstants.YesOrNo.YES);
        }
        rspDTO.setRows(dycProCommPoolQryDTOS);
        return rspDTO;
    }

    @Override
    public List<DycProCommPoolCommodityRelDTO> qryListRelSkuObj(DycProCommPoolQryDTO reqDTO) {
        List<DycProCommPoolCommodityRelDTO> poolCommodityRelList = new ArrayList<DycProCommPoolCommodityRelDTO>();
        List commPoolCommodityRelPOS = this.commPoolCommodityRelMapper.selectList((Wrapper)new LambdaQueryWrapperX().in(CommPoolCommodityRelPO::getObjId, reqDTO.getObjIdList()).eq(CommPoolCommodityRelPO::getPoolId, (Object)reqDTO.getPoolId()));
        if (!CollectionUtils.isEmpty((Collection)commPoolCommodityRelPOS)) {
            poolCommodityRelList = JSON.parseArray((String)JSON.toJSONString((Object)commPoolCommodityRelPOS), DycProCommPoolCommodityRelDTO.class);
        }
        return poolCommodityRelList;
    }
}

