/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.sync.banscatalog.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.bansrecord.api.DycProCommBansRecordRepository;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.catalogban.api.DycProCommCatalogBanRepository;
import com.tydic.dyc.pro.dmc.repository.catalogban.dto.DycProCommCatalogBanInfoChangeDTO;
import com.tydic.dyc.pro.dmc.repository.catalogban.dto.DycProCommCatalogBanInfoChangeItemDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommPropertyTemplateInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuHandleDTO;
import com.tydic.dyc.pro.dmc.service.api.DycProCommBansSyncProcessBatchService;
import com.tydic.dyc.pro.dmc.service.api.DycProCommUpdateBansExecStatusService;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommBansSyncProcessInsertBatchBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommBansSyncProcessInsertBatchReqBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommUpdateBansExecStatusReqBO;
import com.tydic.dyc.pro.dmc.sync.banscatalog.api.DycProCommBansCatalogSyncAbilityService;
import com.tydic.dyc.pro.dmc.sync.banscatalog.bo.DycProCommBansCatalogSyncAbilityReqBO;
import com.tydic.dyc.pro.dmc.sync.banscatalog.bo.DycProCommBansCatalogSyncAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.sync.banscatalog.api.DycProCommBansCatalogSyncAbilityService"})
public class DycProCommBansCatalogSyncAbilityServiceImpl
implements DycProCommBansCatalogSyncAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DycProCommBansCatalogSyncAbilityServiceImpl.class);
    @Autowired
    private DycProCommCatalogBanRepository dycProCommCatalogBanRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;
    private final int BATCH_SIZE = 200;
    @Autowired
    private DycProCommBansSyncProcessBatchService dycProCommBansSyncProcessBatchService;
    @Autowired
    private DycProCommUpdateBansExecStatusService dycProCommUpdateBansExecStatusService;
    @Autowired
    private DycProCommBansRecordRepository dycProCommBansRecordRepository;

    @Override
    @PostMapping(value={"syncBansCatalogInfo"})
    public DycProCommBansCatalogSyncAbilityRspBO syncBansCatalogInfo(@RequestBody DycProCommBansCatalogSyncAbilityReqBO reqBO) {
        List dycProCommCatalogBanInfoChangeDTOS = this.dycProCommCatalogBanRepository.qryPendingBansRule();
        if (null != dycProCommCatalogBanInfoChangeDTOS && dycProCommCatalogBanInfoChangeDTOS.size() > 0) {
            for (DycProCommCatalogBanInfoChangeDTO dycProCommCatalogBanInfoChangeDTO : dycProCommCatalogBanInfoChangeDTOS) {
                List dycProCommCatalogBanInfoChangeItemDTOS = this.dycProCommCatalogBanRepository.qryChangeCatalogItemByRuleId(dycProCommCatalogBanInfoChangeDTO.getBansRuleChngRecordId());
                if (CollectionUtils.isEmpty((Collection)dycProCommCatalogBanInfoChangeItemDTOS)) continue;
                DycProCommUpdateBansExecStatusReqBO changeInfoDTO = new DycProCommUpdateBansExecStatusReqBO();
                changeInfoDTO.setBansRuleChngRecordId(dycProCommCatalogBanInfoChangeDTO.getBansRuleChngRecordId());
                changeInfoDTO.setExecStatus(DycProCommConstants.BansRuleExecStatus.PROGRESS);
                this.dycProCommUpdateBansExecStatusService.updateBansExecStatus(changeInfoDTO);
                ArrayList<DycProCommBansRecordInfoDTO> recordAddInfoDTOS = new ArrayList<DycProCommBansRecordInfoDTO>();
                ArrayList<DycProCommBansRecordInfoDTO> recordUpdateInfoDTOS = new ArrayList<DycProCommBansRecordInfoDTO>();
                for (DycProCommCatalogBanInfoChangeItemDTO dycProCommCatalogBanInfoChangeItemDTO : dycProCommCatalogBanInfoChangeItemDTOS) {
                    if (1L == dycProCommCatalogBanInfoChangeItemDTO.getCatalogId()) {
                        DycProCommSkuHandleDTO skuDTO = new DycProCommSkuHandleDTO();
                        if (-1L != dycProCommCatalogBanInfoChangeItemDTO.getSupplierId()) {
                            skuDTO.setSupplierId(dycProCommCatalogBanInfoChangeItemDTO.getSupplierId());
                        }
                        skuDTO.setSkuSource(DycProCommConstants.SkuSource.E_SKU);
                        List skuMainListByCondition = this.dycProCommSkuRepository.getSkuMainListByCondition(skuDTO);
                        if (!CollectionUtils.isEmpty((Collection)skuMainListByCondition)) {
                            this.updateItemExecStatus(dycProCommCatalogBanInfoChangeItemDTO, DycProCommConstants.BansRuleExecStatus.PROGRESS);
                            for (DycProCommSkuDTO dycProCommSkuDTO : skuMainListByCondition) {
                                DycProCommBansRecordInfoDTO recordInfoDTO = this.buildBansRecord(dycProCommCatalogBanInfoChangeDTO, dycProCommSkuDTO, dycProCommCatalogBanInfoChangeItemDTO);
                                DycProCommBansRecordInfoQryDTO qryDTO = new DycProCommBansRecordInfoQryDTO();
                                qryDTO.setSkuId(dycProCommSkuDTO.getSkuId());
                                qryDTO.setBansRuleId(dycProCommCatalogBanInfoChangeDTO.getBansRuleId());
                                List recordInfoDTOS = this.dycProCommBansRecordRepository.queryBansRecordList(qryDTO);
                                if (CollectionUtils.isEmpty((Collection)recordInfoDTOS)) {
                                    recordAddInfoDTOS.add(recordInfoDTO);
                                    continue;
                                }
                                recordUpdateInfoDTOS.add(recordInfoDTO);
                            }
                            if (!CollectionUtils.isEmpty(recordAddInfoDTOS)) {
                                this.processInsertBatch(recordAddInfoDTOS, dycProCommCatalogBanInfoChangeItemDTO);
                            }
                            if (CollectionUtils.isEmpty(recordUpdateInfoDTOS)) continue;
                            this.processUpdateBatch(recordUpdateInfoDTOS, dycProCommCatalogBanInfoChangeItemDTO);
                            continue;
                        }
                        this.updateItemExecStatus(dycProCommCatalogBanInfoChangeItemDTO, DycProCommConstants.BansRuleExecStatus.SUCCESS);
                        continue;
                    }
                    DycProCommPropertyTemplateInfoDTO commManageCatalogDTO = new DycProCommPropertyTemplateInfoDTO();
                    commManageCatalogDTO.setManageCatalogId(dycProCommCatalogBanInfoChangeItemDTO.getCatalogId());
                    DycProCommPropertyTemplateInfoDTO dycProCommPropertyTemplateInfoDTO = this.dycProCommManageCatalogRepository.queryPropertyTemplateOneByCondition(commManageCatalogDTO);
                    if (null == dycProCommPropertyTemplateInfoDTO || null == dycProCommPropertyTemplateInfoDTO.getPropertyTemplateId()) continue;
                    DycProCommSkuHandleDTO skuDTO = new DycProCommSkuHandleDTO();
                    skuDTO.setPropertyTemplateId(dycProCommPropertyTemplateInfoDTO.getPropertyTemplateId());
                    if (-1L != dycProCommCatalogBanInfoChangeItemDTO.getSupplierId()) {
                        skuDTO.setSupplierId(dycProCommCatalogBanInfoChangeItemDTO.getSupplierId());
                    }
                    skuDTO.setSkuSource(DycProCommConstants.SkuSource.E_SKU);
                    List skuMainListByCondition = this.dycProCommSkuRepository.getSkuMainListByCondition(skuDTO);
                    if (!CollectionUtils.isEmpty((Collection)skuMainListByCondition)) {
                        this.updateItemExecStatus(dycProCommCatalogBanInfoChangeItemDTO, DycProCommConstants.BansRuleExecStatus.PROGRESS);
                        for (DycProCommSkuDTO dycProCommSkuDTO : skuMainListByCondition) {
                            DycProCommBansRecordInfoDTO recordInfoDTO = this.buildBansRecord(dycProCommCatalogBanInfoChangeDTO, dycProCommSkuDTO, dycProCommCatalogBanInfoChangeItemDTO);
                            DycProCommBansRecordInfoQryDTO qryDTO = new DycProCommBansRecordInfoQryDTO();
                            qryDTO.setSkuId(dycProCommSkuDTO.getSkuId());
                            qryDTO.setBansRuleId(dycProCommCatalogBanInfoChangeDTO.getBansRuleId());
                            List recordInfoDTOS = this.dycProCommBansRecordRepository.queryBansRecordList(qryDTO);
                            if (CollectionUtils.isEmpty((Collection)recordInfoDTOS)) {
                                recordAddInfoDTOS.add(recordInfoDTO);
                                continue;
                            }
                            recordUpdateInfoDTOS.add(recordInfoDTO);
                        }
                        if (!CollectionUtils.isEmpty(recordAddInfoDTOS)) {
                            this.processInsertBatch(recordAddInfoDTOS, dycProCommCatalogBanInfoChangeItemDTO);
                        }
                        if (CollectionUtils.isEmpty(recordUpdateInfoDTOS)) continue;
                        this.processUpdateBatch(recordUpdateInfoDTOS, dycProCommCatalogBanInfoChangeItemDTO);
                        continue;
                    }
                    this.updateItemExecStatus(dycProCommCatalogBanInfoChangeItemDTO, DycProCommConstants.BansRuleExecStatus.SUCCESS);
                }
                DycProCommUpdateBansExecStatusReqBO changeInfoDTO2 = new DycProCommUpdateBansExecStatusReqBO();
                changeInfoDTO2.setBansRuleChngRecordId(dycProCommCatalogBanInfoChangeDTO.getBansRuleChngRecordId());
                changeInfoDTO2.setExecStatus(DycProCommConstants.BansRuleExecStatus.SUCCESS);
                this.dycProCommUpdateBansExecStatusService.updateBansExecStatus(changeInfoDTO2);
            }
        }
        return new DycProCommBansCatalogSyncAbilityRspBO();
    }

    private DycProCommBansRecordInfoDTO buildBansRecord(DycProCommCatalogBanInfoChangeDTO dycProCommCatalogBanInfoChangeDTO, DycProCommSkuDTO sku, DycProCommCatalogBanInfoChangeItemDTO dycProCommCatalogBanInfoChangeItemDTO) {
        DycProCommBansRecordInfoDTO record = new DycProCommBansRecordInfoDTO();
        record.setBansRuleId(dycProCommCatalogBanInfoChangeDTO.getBansRuleId());
        record.setBansType(DycProCommConstants.bansRuleType.BANS_RULE);
        record.setCreateTime(new Date());
        record.setBansReason("\u7c7b\u76ee\u7981\u552e-" + dycProCommCatalogBanInfoChangeDTO.getBansRuleCode());
        record.setBansStartDate(dycProCommCatalogBanInfoChangeDTO.getBansStartDate());
        record.setBansEndDate(dycProCommCatalogBanInfoChangeItemDTO.getChngType() == DycProCommConstants.BansRuleChngType.DELETE ? new Date() : dycProCommCatalogBanInfoChangeDTO.getBansEndDate());
        record.setSkuId(sku.getSkuId());
        return record;
    }

    private void processInsertBatch(List<DycProCommBansRecordInfoDTO> batch, DycProCommCatalogBanInfoChangeItemDTO item) {
        block6: {
            try {
                if (batch.size() <= 200) {
                    DycProCommBansSyncProcessInsertBatchReqBO batchReqBO = new DycProCommBansSyncProcessInsertBatchReqBO();
                    List insertBatchBOS = JSON.parseArray((String)JSONObject.toJSONString(batch), DycProCommBansSyncProcessInsertBatchBO.class);
                    batchReqBO.setInsertBatchBOS(insertBatchBOS);
                    this.dycProCommBansSyncProcessBatchService.addBansRecordBatch(batchReqBO);
                } else {
                    List partitions = Lists.partition(batch, (int)200);
                    for (List subBatch : partitions) {
                        DycProCommBansSyncProcessInsertBatchReqBO batchReqBO = new DycProCommBansSyncProcessInsertBatchReqBO();
                        List insertBatchBOS = JSON.parseArray((String)JSONObject.toJSONString((Object)subBatch), DycProCommBansSyncProcessInsertBatchBO.class);
                        batchReqBO.setInsertBatchBOS(insertBatchBOS);
                        this.dycProCommBansSyncProcessBatchService.addBansRecordBatch(batchReqBO);
                    }
                }
                batch.clear();
                if (item != null) {
                    this.updateItemExecStatus(item, DycProCommConstants.BansRuleExecStatus.SUCCESS);
                }
            }
            catch (Exception e) {
                log.error("\u6279\u6b21\u5904\u7406\u5f02\u5e38", (Throwable)e);
                if (item == null) break block6;
                this.updateItemExecStatus(item, DycProCommConstants.BansRuleExecStatus.FAIL);
            }
        }
    }

    private void processUpdateBatch(List<DycProCommBansRecordInfoDTO> batch, DycProCommCatalogBanInfoChangeItemDTO item) {
        block6: {
            try {
                if (batch.size() <= 200) {
                    DycProCommBansSyncProcessInsertBatchReqBO batchReqBO = new DycProCommBansSyncProcessInsertBatchReqBO();
                    List insertBatchBOS = JSON.parseArray((String)JSONObject.toJSONString(batch), DycProCommBansSyncProcessInsertBatchBO.class);
                    batchReqBO.setInsertBatchBOS(insertBatchBOS);
                    this.dycProCommBansSyncProcessBatchService.updateBansRecordBatch(batchReqBO);
                } else {
                    List partitions = Lists.partition(batch, (int)200);
                    for (List subBatch : partitions) {
                        DycProCommBansSyncProcessInsertBatchReqBO batchReqBO = new DycProCommBansSyncProcessInsertBatchReqBO();
                        List insertBatchBOS = JSON.parseArray((String)JSONObject.toJSONString((Object)subBatch), DycProCommBansSyncProcessInsertBatchBO.class);
                        batchReqBO.setInsertBatchBOS(insertBatchBOS);
                        this.dycProCommBansSyncProcessBatchService.updateBansRecordBatch(batchReqBO);
                    }
                }
                batch.clear();
                if (item != null) {
                    this.updateItemExecStatus(item, DycProCommConstants.BansRuleExecStatus.SUCCESS);
                }
            }
            catch (Exception e) {
                log.error("\u6279\u6b21\u5904\u7406\u5f02\u5e38", (Throwable)e);
                if (item == null) break block6;
                this.updateItemExecStatus(item, DycProCommConstants.BansRuleExecStatus.FAIL);
            }
        }
    }

    private void updateItemExecStatus(DycProCommCatalogBanInfoChangeItemDTO item, Integer status) {
        DycProCommUpdateBansExecStatusReqBO updateParam = new DycProCommUpdateBansExecStatusReqBO();
        updateParam.setSkuRangeChngRecordId(item.getSkuRangeChngRecordId());
        updateParam.setExecStatus(status);
        this.dycProCommUpdateBansExecStatusService.updateBansItemExecStatus(updateParam);
    }
}

