/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.shopmanage.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.dmc.constant.DycProShopConstants;
import com.tydic.dyc.pro.dmc.dao.ShopApplyMapper;
import com.tydic.dyc.pro.dmc.dao.ShopBaseInfoMapper;
import com.tydic.dyc.pro.dmc.dao.ShopChngApplyMapper;
import com.tydic.dyc.pro.dmc.dao.ShopContactsInfoMapper;
import com.tydic.dyc.pro.dmc.dao.ShopDecorationInfoMapper;
import com.tydic.dyc.pro.dmc.dao.ShopFileInfoMapper;
import com.tydic.dyc.pro.dmc.dao.ShopFreezeInfoMapper;
import com.tydic.dyc.pro.dmc.dao.ShopListMapper;
import com.tydic.dyc.pro.dmc.po.ShopApplyPagePO;
import com.tydic.dyc.pro.dmc.po.ShopBaseInfoPO;
import com.tydic.dyc.pro.dmc.po.ShopChngApplyPO;
import com.tydic.dyc.pro.dmc.po.ShopContactsInfoPO;
import com.tydic.dyc.pro.dmc.po.ShopDecorationInfoPO;
import com.tydic.dyc.pro.dmc.po.ShopFileInfoPO;
import com.tydic.dyc.pro.dmc.po.ShopFreezeInfoPO;
import com.tydic.dyc.pro.dmc.po.ShopListPagePO;
import com.tydic.dyc.pro.dmc.repository.shopmanage.api.DycProShopRepository;
import com.tydic.dyc.pro.dmc.repository.shopmanage.dto.DycProShopApplyListQryDTO;
import com.tydic.dyc.pro.dmc.repository.shopmanage.dto.DycProShopContactsInfoDTO;
import com.tydic.dyc.pro.dmc.repository.shopmanage.dto.DycProShopDecorationInfoDTO;
import com.tydic.dyc.pro.dmc.repository.shopmanage.dto.DycProShopFileInfoDTO;
import com.tydic.dyc.pro.dmc.repository.shopmanage.dto.DycProShopInfoDTO;
import com.tydic.dyc.pro.dmc.repository.shopmanage.dto.DycProShopListQryDTO;
import com.tydic.dyc.pro.dmc.repository.shopmanage.dto.DycProShopStatusChangeDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycProShopRepositoryImpl
implements DycProShopRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProShopRepositoryImpl.class);
    @Autowired
    private ShopContactsInfoMapper shopContactsInfoMapper;
    @Autowired
    private ShopFileInfoMapper shopFileInfoMapper;
    @Autowired
    private ShopDecorationInfoMapper shopDecorationInfoMapper;
    @Autowired
    private ShopBaseInfoMapper shopBaseInfoMapper;
    @Autowired
    private ShopFreezeInfoMapper shopFreezeInfoMapper;
    @Autowired
    private ShopListMapper shopListMapper;
    @Autowired
    private ShopApplyMapper shopApplyMapper;
    @Autowired
    private ShopChngApplyMapper shopChngApplyMapper;

    @Override
    public DycProShopInfoDTO qryShopDetail(DycProShopInfoDTO dycProShopInfoDTO) {
        ShopBaseInfoPO shopBaseInfoPO = (ShopBaseInfoPO)this.shopBaseInfoMapper.selectById((Serializable)dycProShopInfoDTO.getShopId());
        if (shopBaseInfoPO == null) {
            throw new ZTBusinessException("\u5e97\u94fa\u4e0d\u5b58\u5728\uff1a\u3010" + dycProShopInfoDTO.getShopId() + "\u3011");
        }
        List shopContactsInfoPOS = this.shopContactsInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != dycProShopInfoDTO.getShopId(), ShopContactsInfoPO::getObjId, (Object)dycProShopInfoDTO.getShopId())).eq(ShopContactsInfoPO::getObjType, (Object)DycProShopConstants.ShopObjType.SHOP_CONTACTS));
        List shopFileInfoPOS = this.shopFileInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != dycProShopInfoDTO.getShopId(), ShopFileInfoPO::getObjId, (Object)dycProShopInfoDTO.getShopId())).eq(ShopFileInfoPO::getObjType, (Object)DycProShopConstants.ShopObjType.SHOP_FILE));
        List shopDecorationInfoPOS = this.shopDecorationInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(null != dycProShopInfoDTO.getShopId(), ShopDecorationInfoPO::getShopId, (Object)dycProShopInfoDTO.getShopId()));
        DycProShopInfoDTO rspDTO = (DycProShopInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)shopBaseInfoPO), DycProShopInfoDTO.class);
        if (!CollectionUtils.isEmpty((Collection)shopContactsInfoPOS)) {
            rspDTO.setDycProShopContactsInfoDTOList(JSON.parseArray((String)JSON.toJSONString((Object)shopContactsInfoPOS), DycProShopContactsInfoDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)shopFileInfoPOS)) {
            rspDTO.setDycProShopFileInfoDTOList(JSON.parseArray((String)JSON.toJSONString((Object)shopFileInfoPOS), DycProShopFileInfoDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)shopDecorationInfoPOS)) {
            rspDTO.setDycProShopDecorationInfoDTO(JSON.parseArray((String)JSON.toJSONString((Object)shopDecorationInfoPOS), DycProShopDecorationInfoDTO.class));
        }
        return rspDTO;
    }

    @Override
    public DycProShopInfoDTO queryShopMainInfo(DycProShopInfoDTO dycProShopInfoDTO) {
        this.validateParam(dycProShopInfoDTO);
        DycProShopInfoDTO rspDto = new DycProShopInfoDTO();
        List shopBaseInfoPOS = this.shopBaseInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != dycProShopInfoDTO.getShopId(), ShopBaseInfoPO::getShopId, (Object)dycProShopInfoDTO.getShopId())).eq(null != dycProShopInfoDTO.getSupplierId(), ShopBaseInfoPO::getSupplierId, (Object)dycProShopInfoDTO.getSupplierId()));
        if (shopBaseInfoPOS.size() > 1) {
            throw new ZTBusinessException("\u5e97\u94fa\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e\uff0c\u68c0\u67e5\u4f9b\u5e94\u5546\u4fe1\u606f\u3010" + dycProShopInfoDTO.getSupplierId() + "\u3011");
        }
        if (shopBaseInfoPOS.size() == 1) {
            BeanUtils.copyProperties(shopBaseInfoPOS.get(0), (Object)rspDto);
        }
        return rspDto;
    }

    @Override
    public DycProShopInfoDTO addShopDetail(DycProShopInfoDTO dycProShopInfoDTO) {
        dycProShopInfoDTO.setShopId(Sequence.getInstance().nextId());
        dycProShopInfoDTO.setShopStatus(DycProShopConstants.ShopStatusType.DRAFT);
        ShopBaseInfoPO shopBaseInfoPO = (ShopBaseInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProShopInfoDTO), ShopBaseInfoPO.class);
        this.shopBaseInfoMapper.insert((Object)shopBaseInfoPO);
        if (!CollectionUtils.isEmpty(dycProShopInfoDTO.getDycProShopContactsInfoDTOList())) {
            for (DycProShopContactsInfoDTO dycProShopContactsInfoDTO : dycProShopInfoDTO.getDycProShopContactsInfoDTOList()) {
                dycProShopContactsInfoDTO.setContactsId(Sequence.getInstance().nextId());
                dycProShopContactsInfoDTO.setObjId(dycProShopInfoDTO.getShopId());
                dycProShopContactsInfoDTO.setObjType(DycProShopConstants.ShopObjType.SHOP_CONTACTS);
            }
            List contactsInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProShopInfoDTO.getDycProShopContactsInfoDTOList()), ShopContactsInfoPO.class);
            this.shopContactsInfoMapper.insertBatch((Collection)contactsInfoPOS);
        }
        if (!CollectionUtils.isEmpty(dycProShopInfoDTO.getDycProShopFileInfoDTOList())) {
            for (DycProShopFileInfoDTO dycProShopFileInfoDTO : dycProShopInfoDTO.getDycProShopFileInfoDTOList()) {
                dycProShopFileInfoDTO.setFileId(Sequence.getInstance().nextId());
                dycProShopFileInfoDTO.setObjId(dycProShopInfoDTO.getShopId());
                dycProShopFileInfoDTO.setObjType(DycProShopConstants.ShopObjType.SHOP_FILE);
            }
            List fileInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProShopInfoDTO.getDycProShopFileInfoDTOList()), ShopFileInfoPO.class);
            this.shopFileInfoMapper.insertBatch((Collection)fileInfoPOS);
        }
        DycProShopInfoDTO rspDto = new DycProShopInfoDTO();
        rspDto.setShopId(dycProShopInfoDTO.getShopId());
        return rspDto;
    }

    @Override
    public void updateShopDetail(DycProShopInfoDTO dycProShopInfoDTO) {
        this.validateUpdateParam(dycProShopInfoDTO);
        ShopBaseInfoPO shopBaseInfoPO = (ShopBaseInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProShopInfoDTO), ShopBaseInfoPO.class);
        int update = this.shopBaseInfoMapper.updateById((Object)shopBaseInfoPO);
        if (update < 1) {
            throw new ZTBusinessException("\u5e97\u94fa\u57fa\u672c\u4fe1\u606f\u4fee\u6539\u5931\u8d25");
        }
        this.shopContactsInfoMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ShopContactsInfoPO::getObjId, (Object)dycProShopInfoDTO.getShopId())).eq(ShopContactsInfoPO::getObjType, (Object)DycProShopConstants.ShopObjType.SHOP_CONTACTS));
        if (!CollectionUtils.isEmpty(dycProShopInfoDTO.getDycProShopContactsInfoDTOList())) {
            for (DycProShopContactsInfoDTO dycProShopContactsInfoDTO : dycProShopInfoDTO.getDycProShopContactsInfoDTOList()) {
                dycProShopContactsInfoDTO.setContactsId(Sequence.getInstance().nextId());
                dycProShopContactsInfoDTO.setObjId(dycProShopInfoDTO.getShopId());
                dycProShopContactsInfoDTO.setObjType(DycProShopConstants.ShopObjType.SHOP_CONTACTS);
            }
            List contactsInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProShopInfoDTO.getDycProShopContactsInfoDTOList()), ShopContactsInfoPO.class);
            this.shopContactsInfoMapper.insertBatch((Collection)contactsInfoPOS);
        }
        this.shopFileInfoMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ShopFileInfoPO::getObjId, (Object)dycProShopInfoDTO.getShopId())).eq(ShopFileInfoPO::getObjType, (Object)DycProShopConstants.ShopObjType.SHOP_FILE));
        if (!CollectionUtils.isEmpty(dycProShopInfoDTO.getDycProShopFileInfoDTOList())) {
            for (DycProShopFileInfoDTO dycProShopFileInfoDTO : dycProShopInfoDTO.getDycProShopFileInfoDTOList()) {
                dycProShopFileInfoDTO.setFileId(Sequence.getInstance().nextId());
                dycProShopFileInfoDTO.setObjId(dycProShopInfoDTO.getShopId());
                dycProShopFileInfoDTO.setObjType(DycProShopConstants.ShopObjType.SHOP_FILE);
            }
            List fileInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProShopInfoDTO.getDycProShopFileInfoDTOList()), ShopFileInfoPO.class);
            this.shopFileInfoMapper.insertBatch((Collection)fileInfoPOS);
        }
    }

    @Override
    public void changeShopStatus(DycProShopStatusChangeDTO dycProShopStatusChangeDTO) {
        if (null == dycProShopStatusChangeDTO.getShopId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010shopId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == dycProShopStatusChangeDTO.getSourceShopStatus()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010SourceShopStatus\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == dycProShopStatusChangeDTO.getTargetShopStatus()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010TargetShopStatus\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ShopBaseInfoPO shopBaseInfoPO = (ShopBaseInfoPO)this.shopBaseInfoMapper.selectById((Serializable)dycProShopStatusChangeDTO.getShopId());
        if (shopBaseInfoPO == null) {
            throw new ZTBusinessException("\u5e97\u94fa\u4e0d\u5b58\u5728\uff1a\u3010" + dycProShopStatusChangeDTO.getShopId() + "\u3011");
        }
        if (!dycProShopStatusChangeDTO.getSourceShopStatus().equals(shopBaseInfoPO.getShopStatus())) {
            if (dycProShopStatusChangeDTO.getTargetShopStatus().equals(shopBaseInfoPO.getShopStatus())) {
                throw new ZTBusinessException("\u5f53\u524d\u6570\u636e\u5df2\u7ecf\u662f\u76ee\u6807\u72b6\u6001\uff0c\u4e0d\u80fd\u53d8\u66f4\uff01");
            }
            throw new ZTBusinessException("\u5f53\u524d\u6570\u636e\u975e\u3010" + dycProShopStatusChangeDTO.getSourceShopStatus() + "\u3011\u72b6\u6001\u4e0d\u80fd\u53d8\u66f4");
        }
        ShopBaseInfoPO updateShopBaseInfoPO = new ShopBaseInfoPO();
        updateShopBaseInfoPO.setShopId(dycProShopStatusChangeDTO.getShopId());
        updateShopBaseInfoPO.setShopStatus(dycProShopStatusChangeDTO.getTargetShopStatus());
        if (DycProShopConstants.ShopStatusType.FREEZE.equals(dycProShopStatusChangeDTO.getTargetShopStatus())) {
            updateShopBaseInfoPO.setFreezeWay(DycProShopConstants.ShopFreezeWay.MAN);
            updateShopBaseInfoPO.setFreezeReason(dycProShopStatusChangeDTO.getOperReason());
        }
        this.shopBaseInfoMapper.updateById((Object)updateShopBaseInfoPO);
        if (DycProShopConstants.ShopStatusType.FREEZE.equals(dycProShopStatusChangeDTO.getSourceShopStatus()) || DycProShopConstants.ShopStatusType.FREEZE.equals(dycProShopStatusChangeDTO.getTargetShopStatus())) {
            ShopFreezeInfoPO shopFreezeInfoPO = (ShopFreezeInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProShopStatusChangeDTO), ShopFreezeInfoPO.class);
            shopFreezeInfoPO.setOperId(Long.valueOf(Sequence.getInstance().nextId()));
            shopFreezeInfoPO.setFreezeWay(DycProShopConstants.ShopFreezeWay.MAN);
            if (DycProShopConstants.ShopStatusType.FREEZE.equals(dycProShopStatusChangeDTO.getSourceShopStatus())) {
                shopFreezeInfoPO.setOperType(DycProShopConstants.ShopOperType.THAW);
            }
            if (DycProShopConstants.ShopStatusType.FREEZE.equals(dycProShopStatusChangeDTO.getTargetShopStatus())) {
                shopFreezeInfoPO.setOperType(DycProShopConstants.ShopOperType.FREEZE);
            }
            this.shopFreezeInfoMapper.insert((Object)shopFreezeInfoPO);
            if (!CollectionUtils.isEmpty(dycProShopStatusChangeDTO.getDycProShopFileInfoDTOList())) {
                for (DycProShopFileInfoDTO each : dycProShopStatusChangeDTO.getDycProShopFileInfoDTOList()) {
                    each.setFileId(Sequence.getInstance().nextId());
                    each.setObjId(shopFreezeInfoPO.getOperId());
                    each.setObjType(DycProShopConstants.ShopObjType.FREEZE_FILE);
                }
                List fileInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProShopStatusChangeDTO.getDycProShopFileInfoDTOList()), ShopFileInfoPO.class);
                this.shopFileInfoMapper.insertBatch((Collection)fileInfoPOS);
            }
        }
    }

    @Override
    public DycProShopStatusChangeDTO qryStatusChangeInfo(DycProShopStatusChangeDTO dycProShopStatusChangeDTO) {
        List shopFileInfoPOS;
        if (null == dycProShopStatusChangeDTO.getShopId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010shopId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ShopBaseInfoPO shopBaseInfoPO = (ShopBaseInfoPO)this.shopBaseInfoMapper.selectById((Serializable)dycProShopStatusChangeDTO.getShopId());
        if (shopBaseInfoPO == null) {
            throw new ZTBusinessException("\u5e97\u94fa\u4e0d\u5b58\u5728\uff1a\u3010" + dycProShopStatusChangeDTO.getShopId() + "\u3011");
        }
        ShopFreezeInfoPO shopFreezeInfoPO = (ShopFreezeInfoPO)this.shopFreezeInfoMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ShopFreezeInfoPO::getShopId, (Object)dycProShopStatusChangeDTO.getShopId())).orderByDesc(ShopFreezeInfoPO::getOperId)).last("LIMIT 1"));
        DycProShopStatusChangeDTO rspDTO = new DycProShopStatusChangeDTO();
        BeanUtils.copyProperties((Object)shopFreezeInfoPO, (Object)rspDTO);
        if (null != shopFreezeInfoPO.getOperId() && !CollectionUtils.isEmpty((Collection)(shopFileInfoPOS = this.shopFileInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(ShopFileInfoPO::getObjId, (Object)shopFreezeInfoPO.getOperId()))))) {
            rspDTO.setDycProShopFileInfoDTOList(JSON.parseArray((String)JSON.toJSONString((Object)shopFileInfoPOS), DycProShopFileInfoDTO.class));
        }
        return rspDTO;
    }

    @Override
    public RspPage<DycProShopListQryDTO> qryDycProShopInfoDTOPage(DycProShopListQryDTO qryDTO) {
        Page page = new Page((long)qryDTO.getPageNo().intValue(), (long)qryDTO.getPageSize().intValue());
        page.setOptimizeCountSql(false);
        ShopListPagePO qryShopListPagePO = (ShopListPagePO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), ShopListPagePO.class);
        page = this.shopListMapper.selectShopListPage(qryShopListPagePO, page);
        List selectShopListPagePOS = new ArrayList();
        selectShopListPagePOS = page.getRecords();
        RspPage rspPage = new RspPage();
        if (!ObjectUtils.isEmpty(selectShopListPagePOS)) {
            List dycProShopListQryDTOS = JSON.parseArray((String)JSON.toJSONString(selectShopListPagePOS), DycProShopListQryDTO.class);
            rspPage.setRows(dycProShopListQryDTOS);
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProShopApplyListQryDTO> qryDycProShopApplyInfoDTOPage(DycProShopApplyListQryDTO qryDTO) {
        Page page = new Page((long)qryDTO.getPageNo().intValue(), (long)qryDTO.getPageSize().intValue());
        page.setOptimizeCountSql(false);
        ShopApplyPagePO qryShopApplyPagePO = (ShopApplyPagePO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), ShopApplyPagePO.class);
        page = this.shopApplyMapper.selectShopApplyPage(qryShopApplyPagePO, page);
        List selectShopApplyPagePOS = new ArrayList();
        selectShopApplyPagePOS = page.getRecords();
        RspPage rspPage = new RspPage();
        if (!ObjectUtils.isEmpty(selectShopApplyPagePOS)) {
            List dycProShopApplyListQryDTOS = JSON.parseArray((String)JSON.toJSONString(selectShopApplyPagePOS), DycProShopApplyListQryDTO.class);
            rspPage.setRows(dycProShopApplyListQryDTOS);
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public DycProShopInfoDTO addShopChangeDetail(DycProShopInfoDTO dycProShopInfoDTO) {
        dycProShopInfoDTO.setChngApplyId(Sequence.getInstance().nextId());
        dycProShopInfoDTO.setChngApplyStatus(DycProShopConstants.ShopStatusType.DRAFT);
        ShopChngApplyPO shopChngApplyPO = (ShopChngApplyPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProShopInfoDTO), ShopChngApplyPO.class);
        this.shopChngApplyMapper.insert((Object)shopChngApplyPO);
        if (!CollectionUtils.isEmpty(dycProShopInfoDTO.getDycProShopContactsInfoDTOList())) {
            for (DycProShopContactsInfoDTO dycProShopContactsInfoDTO : dycProShopInfoDTO.getDycProShopContactsInfoDTOList()) {
                dycProShopContactsInfoDTO.setContactsId(Sequence.getInstance().nextId());
                dycProShopContactsInfoDTO.setObjId(dycProShopInfoDTO.getChngApplyId());
                dycProShopContactsInfoDTO.setObjType(DycProShopConstants.ShopObjType.SHOP_CHANGE_CONTACTS);
            }
            List contactsInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProShopInfoDTO.getDycProShopContactsInfoDTOList()), ShopContactsInfoPO.class);
            this.shopContactsInfoMapper.insertBatch((Collection)contactsInfoPOS);
        }
        if (!CollectionUtils.isEmpty(dycProShopInfoDTO.getDycProShopFileInfoDTOList())) {
            for (DycProShopFileInfoDTO dycProShopFileInfoDTO : dycProShopInfoDTO.getDycProShopFileInfoDTOList()) {
                dycProShopFileInfoDTO.setFileId(Sequence.getInstance().nextId());
                dycProShopFileInfoDTO.setObjId(dycProShopInfoDTO.getChngApplyId());
                dycProShopFileInfoDTO.setObjType(DycProShopConstants.ShopObjType.SHOP_CHANGE_FILE);
            }
            List fileInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProShopInfoDTO.getDycProShopFileInfoDTOList()), ShopFileInfoPO.class);
            this.shopFileInfoMapper.insertBatch((Collection)fileInfoPOS);
        }
        DycProShopInfoDTO rspDto = new DycProShopInfoDTO();
        rspDto.setChngApplyId(dycProShopInfoDTO.getChngApplyId());
        return rspDto;
    }

    @Override
    public void changeShopChngStatus(DycProShopStatusChangeDTO dycProShopStatusChangeDTO) {
        if (null == dycProShopStatusChangeDTO.getChngApplyId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010chngApplyId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == dycProShopStatusChangeDTO.getSourceShopStatus()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010SourceShopStatus\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == dycProShopStatusChangeDTO.getTargetShopStatus()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010TargetShopStatus\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ShopChngApplyPO shopChngApplyPO = (ShopChngApplyPO)this.shopChngApplyMapper.selectById((Serializable)dycProShopStatusChangeDTO.getChngApplyId());
        if (shopChngApplyPO == null) {
            throw new ZTBusinessException("\u53d8\u66f4\u7533\u8bf7ID\u4e0d\u5b58\u5728\uff1a\u3010" + dycProShopStatusChangeDTO.getChngApplyId() + "\u3011");
        }
        if (!dycProShopStatusChangeDTO.getSourceShopStatus().equals(shopChngApplyPO.getChngApplyStatus())) {
            if (dycProShopStatusChangeDTO.getTargetShopStatus().equals(shopChngApplyPO.getChngApplyStatus())) {
                throw new ZTBusinessException("\u5f53\u524d\u6570\u636e\u5df2\u7ecf\u662f\u76ee\u6807\u72b6\u6001\uff0c\u4e0d\u80fd\u53d8\u66f4\uff01");
            }
            throw new ZTBusinessException("\u5f53\u524d\u6570\u636e\u975e\u3010" + dycProShopStatusChangeDTO.getSourceShopStatus() + "\u3011\u72b6\u6001\u4e0d\u80fd\u53d8\u66f4");
        }
        ShopChngApplyPO updateShopChngApplyPO = new ShopChngApplyPO();
        updateShopChngApplyPO.setChngApplyId(dycProShopStatusChangeDTO.getChngApplyId());
        updateShopChngApplyPO.setChngApplyStatus(dycProShopStatusChangeDTO.getTargetShopStatus());
        updateShopChngApplyPO.setChngApplyComment(dycProShopStatusChangeDTO.getChngApplyComment());
        this.shopChngApplyMapper.updateById((Object)updateShopChngApplyPO);
        if (DycProShopConstants.ShopStatusType.APPROVED.equals(dycProShopStatusChangeDTO.getTargetShopStatus())) {
            DycProShopInfoDTO qryDycProShopInfoDTO = new DycProShopInfoDTO();
            qryDycProShopInfoDTO.setChngApplyId(dycProShopStatusChangeDTO.getChngApplyId());
            this.updateShopDetail(this.qryShopChngDetail(qryDycProShopInfoDTO));
        }
    }

    @Override
    public DycProShopInfoDTO qryShopChngDetail(DycProShopInfoDTO dycProShopInfoDTO) {
        ShopChngApplyPO shopChngApplyPO = (ShopChngApplyPO)this.shopChngApplyMapper.selectById((Serializable)dycProShopInfoDTO.getChngApplyId());
        if (shopChngApplyPO == null) {
            throw new ZTBusinessException("\u53d8\u66f4\u7533\u8bf7ID\u4e0d\u5b58\u5728\uff1a\u3010" + dycProShopInfoDTO.getChngApplyId() + "\u3011");
        }
        List shopContactsInfoPOS = this.shopContactsInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ShopContactsInfoPO::getObjId, (Object)dycProShopInfoDTO.getChngApplyId())).eq(ShopContactsInfoPO::getObjType, (Object)DycProShopConstants.ShopObjType.SHOP_CHANGE_CONTACTS));
        List shopFileInfoPOS = this.shopFileInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ShopFileInfoPO::getObjId, (Object)dycProShopInfoDTO.getChngApplyId())).eq(ShopFileInfoPO::getObjType, (Object)DycProShopConstants.ShopObjType.SHOP_CHANGE_FILE));
        DycProShopInfoDTO rspDTO = (DycProShopInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)shopChngApplyPO), DycProShopInfoDTO.class);
        if (!CollectionUtils.isEmpty((Collection)shopContactsInfoPOS)) {
            rspDTO.setDycProShopContactsInfoDTOList(JSON.parseArray((String)JSON.toJSONString((Object)shopContactsInfoPOS), DycProShopContactsInfoDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)shopFileInfoPOS)) {
            rspDTO.setDycProShopFileInfoDTOList(JSON.parseArray((String)JSON.toJSONString((Object)shopFileInfoPOS), DycProShopFileInfoDTO.class));
        }
        return rspDTO;
    }

    @Override
    public DycProShopInfoDTO qryShopChngIdByShopId(DycProShopInfoDTO dycProShopInfoDTO) {
        this.validateUpdateParam(dycProShopInfoDTO);
        ShopChngApplyPO shopChngApplyPO = (ShopChngApplyPO)this.shopChngApplyMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ShopChngApplyPO::getShopId, (Object)dycProShopInfoDTO.getShopId())).orderByDesc(ShopChngApplyPO::getChngApplyId)).last("LIMIT 1"));
        DycProShopInfoDTO rspDTO = (DycProShopInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)shopChngApplyPO), DycProShopInfoDTO.class);
        if (shopChngApplyPO != null) {
            rspDTO.setChngApplyId(shopChngApplyPO.getChngApplyId());
            rspDTO.setChngApplyStatus(shopChngApplyPO.getChngApplyStatus());
        }
        return rspDTO;
    }

    private void validateParam(DycProShopInfoDTO reqBO) {
        if (null == reqBO.getShopId() && null == reqBO.getSupplierId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010shopId\u3011\u3010supplierId\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
    }

    private void validateUpdateParam(DycProShopInfoDTO reqBO) {
        if (null == reqBO.getShopId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010shopId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

